/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.objstore.jndi;

import com.tongtech.tmqi.admin.objstore.AuthenticationException;
import com.tongtech.tmqi.admin.objstore.AuthenticationNotSupportedException;
import com.tongtech.tmqi.admin.objstore.CommunicationException;
import com.tongtech.tmqi.admin.objstore.GeneralNamingException;
import com.tongtech.tmqi.admin.objstore.InitializationException;
import com.tongtech.tmqi.admin.objstore.InvalidAttributesException;
import com.tongtech.tmqi.admin.objstore.NameAlreadyExistsException;
import com.tongtech.tmqi.admin.objstore.NameNotFoundException;
import com.tongtech.tmqi.admin.objstore.NoPermissionException;
import com.tongtech.tmqi.admin.objstore.NotContextException;
import com.tongtech.tmqi.admin.objstore.ObjStore;
import com.tongtech.tmqi.admin.objstore.ObjStoreAttrs;
import com.tongtech.tmqi.admin.objstore.ObjStoreException;
import com.tongtech.tmqi.admin.objstore.SchemaViolationException;
import com.tongtech.tmqi.admin.resources.AdminResources;
import com.tongtech.tmqi.admin.util.Globals;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class JNDIStore
implements ObjStore {
    private ObjStoreAttrs attrs = null;
    private boolean open = false;
    private DirContext dirCtx;
    private AdminResources ar = Globals.getAdminResources();
    private static final String SUN_LDAP_IC = "com.sun.jndi.ldap.LdapCtxFactory";

    public JNDIStore(ObjStoreAttrs attrs) {
        this.attrs = attrs;
    }

    @Override
    public void open() throws ObjStoreException {
        try {
            this.dirCtx = this.attrs != null ? new InitialDirContext(this.attrs) : new InitialDirContext();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.open = true;
    }

    @Override
    public void close() throws ObjStoreException {
        try {
            this.dirCtx.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.open = false;
    }

    @Override
    public void add(String lookupName, Object obj, boolean overwrite) throws ObjStoreException {
        BasicAttributes bindAttrs = null;
        try {
            Hashtable<?, ?> storedEnv = this.dirCtx.getEnvironment();
            String initialContextValue = null;
            if (storedEnv.containsKey("java.naming.factory.initial") && SUN_LDAP_IC.equals(initialContextValue = (String)storedEnv.get("java.naming.factory.initial")) && lookupName.startsWith("cn=")) {
                bindAttrs = new BasicAttributes();
                bindAttrs.put("cn", lookupName.substring(3));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        try {
            if (bindAttrs != null) {
                this.dirCtx.bind(lookupName, obj, bindAttrs);
            } else {
                this.dirCtx.bind(lookupName, obj);
            }
        }
        catch (NameAlreadyBoundException nabe) {
            if (overwrite) {
                try {
                    if (bindAttrs != null) {
                        this.dirCtx.rebind(lookupName, obj, bindAttrs);
                    }
                    this.dirCtx.rebind(lookupName, obj);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            NameAlreadyExistsException naee = new NameAlreadyExistsException(this.ar.getString("A4002"));
            naee.setLinkedException(nabe);
            throw naee;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void add(String lookupName, Object obj, Attributes bindAttrs, boolean overwrite) throws ObjStoreException {
        try {
            Hashtable<?, ?> storedEnv = this.dirCtx.getEnvironment();
            String initialContextValue = null;
            if (storedEnv.containsKey("java.naming.factory.initial") && SUN_LDAP_IC.equals(initialContextValue = (String)storedEnv.get("java.naming.factory.initial")) && lookupName.startsWith("cn=")) {
                bindAttrs.put("cn", lookupName.substring(3));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        try {
            this.dirCtx.bind(lookupName, obj, bindAttrs);
        }
        catch (NameAlreadyBoundException nabe) {
            if (overwrite) {
                try {
                    this.dirCtx.rebind(lookupName, obj, bindAttrs);
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
            NameAlreadyExistsException naee = new NameAlreadyExistsException(this.ar.getString("A4002"));
            naee.setLinkedException(nabe);
            throw naee;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void delete(String lookupName) throws ObjStoreException {
        try {
            this.dirCtx.unbind(lookupName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public Object retrieve(String lookupName) throws ObjStoreException {
        Object obj = null;
        try {
            obj = this.dirCtx.lookup(lookupName);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return obj;
    }

    @Override
    public Vector list() throws ObjStoreException {
        Vector<NameClassPair> vec = new Vector<NameClassPair>();
        try {
            NamingEnumeration<NameClassPair> nameEnum = this.dirCtx.list("");
            while (nameEnum.hasMore()) {
                NameClassPair obj = nameEnum.next();
                vec.add(obj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return vec;
    }

    @Override
    public Vector list(int[] type) throws ObjStoreException {
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public String getID() {
        return this.attrs.getID();
    }

    @Override
    public String getDescription() {
        return this.attrs.getDescription();
    }

    @Override
    public void setObjStoreAttrs(ObjStoreAttrs newAttrs) throws ObjStoreException {
        this.attrs = newAttrs;
    }

    @Override
    public ObjStoreAttrs getObjStoreAttrs() {
        return this.attrs;
    }

    private void handleException(Exception e) throws ObjStoreException {
        if (e instanceof javax.naming.AuthenticationException) {
            AuthenticationException ae = new AuthenticationException(this.ar.getString("A4003"));
            ae.setLinkedException(e);
            throw ae;
        }
        if (e instanceof javax.naming.AuthenticationNotSupportedException) {
            AuthenticationNotSupportedException anse = new AuthenticationNotSupportedException(this.ar.getString("A4004"));
            anse.setLinkedException(e);
            throw anse;
        }
        if (e instanceof javax.naming.NoPermissionException) {
            NoPermissionException pe = new NoPermissionException(this.ar.getString("A4005"));
            pe.setLinkedException(e);
            throw pe;
        }
        if (e instanceof javax.naming.CommunicationException) {
            CommunicationException ce = new CommunicationException(this.ar.getString("A4006"));
            ce.setLinkedException(e);
            throw ce;
        }
        if (e instanceof NoInitialContextException) {
            InitializationException ie = new InitializationException(this.ar.getString("A4007"));
            ie.setLinkedException(e);
            throw ie;
        }
        if (e instanceof javax.naming.directory.SchemaViolationException) {
            SchemaViolationException sve = new SchemaViolationException(this.ar.getString("A4008"));
            sve.setLinkedException(e);
            throw sve;
        }
        if (e instanceof javax.naming.NameNotFoundException) {
            NameNotFoundException nnfe = new NameNotFoundException(this.ar.getString("A4009"));
            nnfe.setLinkedException(e);
            throw nnfe;
        }
        if (e instanceof NameAlreadyBoundException) {
            NameAlreadyExistsException naee = new NameAlreadyExistsException(this.ar.getString("A4010"));
            naee.setLinkedException(e);
            throw naee;
        }
        if (e instanceof javax.naming.NotContextException) {
            NotContextException nce = new NotContextException(this.ar.getString("A4011"));
            nce.setLinkedException(e);
            throw nce;
        }
        if (e instanceof javax.naming.directory.InvalidAttributesException) {
            InvalidAttributesException iae = new InvalidAttributesException(this.ar.getString("A4012"));
            iae.setLinkedException(e);
            throw iae;
        }
        if (e instanceof NamingException) {
            GeneralNamingException gne = new GeneralNamingException(this.ar.getString("A4013"));
            gne.setLinkedException(e);
            throw gne;
        }
        ObjStoreException ose = new ObjStoreException();
        ose.setLinkedException(e);
        throw ose;
    }

    @Override
    public Vector checkAuthentication(ObjStoreAttrs osa) {
        Vector<String> missingAuthInfo = new Vector<String>();
        String authType = null;
        if (osa.containsKey("java.naming.security.authentication") && "simple".equals(authType = (String)osa.get("java.naming.security.authentication"))) {
            if (!osa.containsKey("java.naming.security.principal")) {
                missingAuthInfo.addElement("java.naming.security.principal");
            }
            if (!osa.containsKey("java.naming.security.credentials")) {
                missingAuthInfo.addElement("java.naming.security.credentials");
            }
        }
        return missingAuthInfo;
    }

    @Override
    public void addObjStoreAttr(String name, String value) {
        this.attrs.put(name, value);
    }

    @Override
    public void search() {
    }

    public void dump(Object obj) {
    }

    private String getUserInput(String question) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint(question);
            return in.readLine();
        }
        catch (IOException ex) {
            Globals.stdErrPrintln(this.ar.getString("A1001"), this.ar.getKString("A3081"));
            return null;
        }
    }
}

