/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.util;

import com.tongtech.tmqi.Version;
import com.tongtech.tmqi.admin.resources.AdminConsoleResources;
import com.tongtech.tmqi.admin.resources.AdminResources;
import java.io.File;
import java.io.PrintStream;
import java.util.Locale;

public class Globals {
    private static final Object lock = Globals.class;
    private static Version version = null;
    private static Globals globals = null;
    private static AdminResources ar = null;
    private static AdminConsoleResources acr = null;
    private static boolean silentMode = false;
    public static final String JMQ_HOME_PROPERTY = "tmqi.home";
    public static final String JMQ_VAR_HOME_PROPERTY = "tmqi.varhome";
    public static final String JMQ_LIB_HOME_PROPERTY = "tmqi.libhome";
    public static final String JMQ_HOME_default = ".";
    public static final String JMQ_VAR_HOME_default = "var";
    public static final String JMQ_HOME = System.getProperty("tmqi.home", ".");
    public static final String JMQ_VAR_HOME = System.getProperty("tmqi.varhome", JMQ_HOME + File.separator + "var");
    public static final String JMQ_LIB_HOME = System.getProperty("tmqi.libhome", JMQ_HOME + File.separator + "lib");
    public static final String JMQ_ADMIN_PROP_LOC = "props" + File.separator + "admin" + File.separator;

    private Globals() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Globals getGlobals() {
        if (globals == null) {
            Object object = lock;
            synchronized (object) {
                if (globals == null) {
                    globals = new Globals();
                }
            }
        }
        return globals;
    }

    public static Version getVersion() {
        if (version == null) {
            version = new Version();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminResources getAdminResources() {
        if (ar == null) {
            Object object = lock;
            synchronized (object) {
                if (ar == null) {
                    ar = AdminResources.getResources(Locale.getDefault());
                }
            }
        }
        return ar;
    }

    public static void setSilentMode(boolean mode) {
        silentMode = mode;
    }

    public static void stdErrPrintln(String msg) {
        Globals.doPrintln(System.err, msg, false);
    }

    public static void stdErrPrintln(String msg, boolean exit) {
        Globals.doPrintln(System.err, msg, exit);
    }

    public static void stdErrPrintln(String type, String msg) {
        Globals.doPrintln(System.err, type + " " + msg, false);
    }

    public static void stdErrPrintln(String type, String msg, boolean exit) {
        Globals.doPrintln(System.err, type + " " + msg, exit);
    }

    public static void stdOutPrintln(String msg) {
        Globals.doPrintln(System.out, msg, false);
    }

    public static void stdOutPrintln(String msg, boolean exit) {
        Globals.doPrintln(System.out, msg, exit);
    }

    public static void stdOutPrintln(String type, String msg) {
        Globals.doPrintln(System.out, type + " " + msg, false);
    }

    public static void stdOutPrintln(String type, String msg, boolean exit) {
        Globals.doPrintln(System.out, type + " " + msg, exit);
    }

    public static void stdErrPrint(String msg) {
        Globals.doPrint(System.err, msg, false);
    }

    public static void stdErrPrint(String msg, boolean exit) {
        Globals.doPrint(System.err, msg, exit);
    }

    public static void stdErrPrint(String type, String msg) {
        Globals.doPrint(System.err, type + " " + msg, false);
    }

    public static void stdErrPrint(String type, String msg, boolean exit) {
        Globals.doPrint(System.err, type + " " + msg, exit);
    }

    public static void stdOutPrint(String msg) {
        Globals.doPrint(System.out, msg, false);
    }

    public static void stdOutPrint(String msg, boolean exit) {
        Globals.doPrint(System.out, msg, exit);
    }

    public static void stdOutPrint(String type, String msg) {
        Globals.doPrint(System.out, type + " " + msg, false);
    }

    public static void stdOutPrint(String type, String msg, boolean exit) {
        Globals.doPrint(System.out, type + " " + msg, exit);
    }

    private static void doPrintln(PrintStream out, String msg, boolean exit) {
        if (silentMode) {
            return;
        }
        out.println(msg);
        if (exit) {
            System.exit(1);
        }
    }

    private static void doPrint(PrintStream out, String msg, boolean exit) {
        if (silentMode) {
            return;
        }
        out.print(msg);
        if (exit) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminConsoleResources getAdminConsoleResources() {
        if (acr == null) {
            Object object = lock;
            synchronized (object) {
                if (acr == null) {
                    acr = AdminConsoleResources.getResources(Locale.getDefault());
                }
            }
        }
        return acr;
    }
}

