/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.admin.util;

import com.tongtech.tmqi.admin.util.UserPropertiesException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class UserProperties
extends Properties {
    private static final String JMQPREFSROOT = ".tmqi";
    private static final String JMQADMINROOT = "admin";
    private String fileName;
    private String dirName;

    public UserProperties() {
        String userHome = System.getProperty("user.home");
        this.fileName = "admin.properties";
        this.dirName = userHome + File.separator + JMQPREFSROOT + File.separator + JMQADMINROOT;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAbsoluteFileName() {
        String absFileName = this.dirName + File.separator + this.fileName;
        return absFileName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public void load() throws UserPropertiesException, SecurityException {
        String absFileName = this.dirName + File.separator + this.fileName;
        File propFile = new File(absFileName);
        if (!propFile.exists()) {
            return;
        }
        if (!propFile.canRead()) {
            UserPropertiesException upe = new UserPropertiesException("");
            throw upe;
        }
        this.loadFile(propFile);
    }

    private void loadFile(File propFile) throws UserPropertiesException {
        try {
            FileInputStream fis = new FileInputStream(propFile);
            this.load(fis);
        }
        catch (Exception ex) {
            UserPropertiesException upe = new UserPropertiesException("");
            throw upe;
        }
    }

    public void save() throws UserPropertiesException, SecurityException {
        String absFileName = this.dirName + File.separator + this.fileName;
        File propDir = new File(this.dirName);
        File propFile = new File(absFileName);
        if (propFile.exists()) {
            if (!propFile.canWrite()) {
                UserPropertiesException upe = new UserPropertiesException("");
                throw upe;
            }
        } else if (propDir.exists()) {
            if (!propDir.canWrite()) {
                UserPropertiesException upe = new UserPropertiesException("");
                throw upe;
            }
        } else {
            propDir.mkdirs();
        }
        try {
            FileOutputStream fos = new FileOutputStream(propFile);
            this.store(fos, null);
        }
        catch (IOException ioe) {
            UserPropertiesException upe = new UserPropertiesException("");
            throw upe;
        }
    }
}

