/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.tmqi.clusterclient.ClusterConnection;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class ClusterConnectionFactory {
    private ConnectionFactory connectionFactory;
    private ClusterConnection[] connections;
    private ClusterQueueSupport clusterQueueSupport;

    public ClusterConnectionFactory(ClusterQueueSupport clusterQueueSupport, ConnectionFactory connectionFactory) throws JMSException {
        this.clusterQueueSupport = clusterQueueSupport;
        this.connections = new ClusterConnection[clusterQueueSupport.getConnectionNum()];
        this.connectionFactory = connectionFactory;
    }

    protected void createConnection() throws JMSException {
        for (int i = 0; i < this.clusterQueueSupport.getConnectionNum(); ++i) {
            ClusterConnection clusterConn;
            this.connections[i] = clusterConn = new ClusterConnection(this, i);
            try {
                clusterConn.createConnection();
                continue;
            }
            catch (JMSException e) {
                clusterConn.onException(e);
            }
        }
    }

    public void createProducers() throws JMSException {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].createProducers();
            }
        }
    }

    public void createConsumers() throws JMSException {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].createConsumers();
            }
        }
    }

    public ClusterConnection[] getConnections() {
        return this.connections;
    }

    public void start() throws JMSException {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].start();
            }
        }
    }

    protected void stop() throws JMSException {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].stop();
            }
        }
    }

    protected void setMessageListener() throws JMSException {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].setMessageListener();
            }
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    protected void closeProducers() {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].closeProducers();
            }
        }
    }

    protected void closeConsumers() {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].closeConsumers();
            }
        }
    }

    protected void close(boolean isExited) {
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                if (this.connections[i] == null) continue;
                this.connections[i].close(isExited);
            }
        }
    }

    public ClusterQueueSupport getClusterQueueSupport() {
        return this.clusterQueueSupport;
    }
}

