/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.zip.CRC32;

public class ClusterMessageIDGenerator {
    static Logger logger;
    private static String ipStr;
    private static String portStr;
    private static String timeValue;
    private static String msValue;
    private static String seqValue;
    private static int seqGenerator;
    private static final int MAXSEQ = 100000;
    private static DecimalFormat dformat;
    private static String TlQcuMng;
    static Hashtable allMsgID;

    public static synchronized String nextMessageId() {
        StringBuffer idStr = new StringBuffer("ID:");
        if (seqGenerator == 0) {
            int port = 1;
            try {
                ServerSocket ss = new ServerSocket(0);
                port = ss.getLocalPort();
                long timestamp = System.currentTimeMillis();
                timeValue = ClusterMessageIDGenerator.toHexString(new Long(timestamp / 1000L).intValue());
                msValue = String.valueOf(timestamp).substring(10);
                Thread.sleep(100L);
                ss.close();
            }
            catch (Exception e) {
                logger.error("clusterGenerateMsgID", e);
                long timestamp = System.currentTimeMillis();
                timeValue = ClusterMessageIDGenerator.toHexString(new Long(timestamp / 1000L).intValue());
                msValue = String.valueOf(timestamp).substring(10);
            }
            portStr = ClusterMessageIDGenerator.toHexString(port, 4);
            logger.info(ipStr + " " + TlQcuMng + " " + portStr + " " + timeValue + " " + msValue + " " + seqValue);
        }
        seqValue = dformat.format(seqGenerator++);
        if (seqGenerator == 100000) {
            seqGenerator = 0;
        }
        String result = idStr.append(ipStr).append(TlQcuMng).append(portStr).append(timeValue).append(msValue).append(seqValue).toString();
        return result;
    }

    public static String toHexString(int value) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() < 8) {
            int len = 8 - hexString.length();
            for (int i = 0; i < len; ++i) {
                hexString = "0" + hexString;
            }
        }
        return hexString;
    }

    public static String toHexString(int value, int length) {
        String hexString = Integer.toHexString(value);
        if (hexString.length() < length) {
            int len = length - hexString.length();
            for (int i = 0; i < len; ++i) {
                hexString = "0" + hexString;
            }
        }
        return hexString;
    }

    public static void main(String[] argv) {
        System.out.println("crc:" + Integer.toHexString(Integer.MIN_VALUE));
        ClusterMessageIDGenerator msgid = new ClusterMessageIDGenerator();
        for (int i = 0; i < 100002; ++i) {
            System.out.println(msgid.nextMessageId());
        }
        long time = System.currentTimeMillis();
        System.out.println(time);
    }

    static {
        String ipAddress;
        logger = LoggerFactory.getLogger(ClusterMessageIDGenerator.class);
        dformat = new DecimalFormat("00000");
        TlQcuMng = "3";
        allMsgID = new Hashtable();
        boolean canAccessSystemProps = true;
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPropertiesAccess();
            }
        }
        catch (SecurityException se) {
            canAccessSystemProps = false;
        }
        if (canAccessSystemProps) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception ioe) {
                ipAddress = "127.0.0.1";
            }
        } else {
            ipAddress = "127.0.0.1";
        }
        StringBuffer sb = new StringBuffer(ipAddress);
        for (int i = 0; i < 48 - ipAddress.length(); ++i) {
            sb.append(" ");
        }
        String ip = sb.toString();
        CRC32 crc = new CRC32();
        crc.update(sb.toString().getBytes());
        ipStr = ClusterMessageIDGenerator.toHexString((int)crc.getValue());
    }
}

