/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.clusterclient.ClusterJMSConnecton;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.NamingException;

public class ClusterQueue
implements ConnectionFactory {
    private String jndiUrl;
    private String queueName;
    private HashMap nameFactoryObject = new HashMap();
    private ConnectionFactory[] brokerConnectionFactories;
    Logger logger = LoggerFactory.getLogger(ClusterQueue.class);
    private Queue queue;

    public HashMap getNameFactoryObject() {
        return this.nameFactoryObject;
    }

    public String getJndiUrl() {
        return this.jndiUrl;
    }

    public void setJndiUrl(String jndiUrl) {
        this.jndiUrl = jndiUrl;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void addFactory(String jndiName, Object factory) {
        this.nameFactoryObject.put(jndiName, factory);
    }

    public void setBrokerConnectionFactories(ConnectionFactory[] brokerConnectionFactories) {
        this.brokerConnectionFactories = brokerConnectionFactories;
    }

    public void setBrokerConnectionFactories(String[] factoryNames) throws JMSException {
        for (int i = 0; i < factoryNames.length; ++i) {
            QueueConnectionFactory factory = new QueueConnectionFactory();
            factory.setProperty("tmqiAddressList", factoryNames[i]);
            this.addFactory(factoryNames[i], factory);
        }
    }

    public ConnectionFactory[] getBrokerConnectionFactories() {
        return this.brokerConnectionFactories;
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String arg0, String arg1) throws JMSException {
        try {
            ClusterQueueSupport support = ClusterQueueSupport.createSupport(this);
            ClusterJMSConnecton connection = new ClusterJMSConnecton(support);
            return connection;
        }
        catch (NamingException e) {
            JMSException ex = new JMSException(e.getMessage());
            ex.setLinkedException((Exception)e);
            throw ex;
        }
    }
}

