/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.tmqi.clusterclient.ClusterMessageListener;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import com.tongtech.tmqi.clusterclient.MessageRecvDispatchThread;
import javax.jms.JMSException;
import javax.jms.MessageListener;

public class ClusterQueueConsumer {
    private ClusterQueueSupport clusterQueueSupport;
    private ClusterMessageListener messageListener;
    private String selector;
    private boolean usePriority;
    private MessageRecvDispatchThread dispatchThread;

    protected ClusterQueueConsumer(ClusterQueueSupport clusterQueueSupport, String selector, boolean usePriority) throws JMSException {
        this.clusterQueueSupport = clusterQueueSupport;
        this.selector = selector;
        this.usePriority = usePriority;
        if (usePriority) {
            this.dispatchThread = new MessageRecvDispatchThread(clusterQueueSupport);
            new Thread((Runnable)this.dispatchThread, "Priority_dispatch_thread_" + System.currentTimeMillis()).start();
        }
    }

    protected void createConsumers() throws JMSException {
        this.clusterQueueSupport.createConsumers();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.messageListener = new ClusterMessageListener(messageListener, this.clusterQueueSupport, this.usePriority);
        this.clusterQueueSupport.setMessageListener();
    }

    public ClusterMessageListener getMessageListener() {
        return this.messageListener;
    }

    protected String getSelector() {
        return this.selector;
    }

    public void close() throws InterruptedException {
        this.clusterQueueSupport.closeConsumers();
        if (this.dispatchThread != null) {
            this.dispatchThread.waitClose();
        }
    }

    public void closeNotWait() {
        this.clusterQueueSupport.closeConsumers();
        if (this.dispatchThread != null) {
            this.dispatchThread.close();
        }
    }
}

