/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.clusterclient.ClusterQueueException;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import com.tongtech.tmqi.clusterclient.ProducerThread;
import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.FileMessageImpl;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;

public class ClusterQueueProducer {
    private static final int RETRY_TIME = 10;
    static Logger logger = LoggerFactory.getLogger(ClusterQueueProducer.class);
    private ClusterQueueSupport clusterQueueSupport;
    private boolean isClosed;

    protected ClusterQueueProducer(ClusterQueueSupport clusterQueueSupport) throws JMSException {
        this.clusterQueueSupport = clusterQueueSupport;
        clusterQueueSupport.createProducers();
    }

    public Message send(byte[] content, Properties props, int priority) throws JMSException {
        BytesMessageImpl message = new BytesMessageImpl(2);
        message.writeBytes(content);
        message.setJMSPriority(priority);
        return this.send(message, props);
    }

    public Message send(byte[] content, int priority) throws JMSException {
        return this.send(content, null, priority);
    }

    public Message sendFile(String path, int priority) throws JMSException {
        return this.sendFile(path, null, priority);
    }

    public Message sendFile(String path, Properties props, int priority) throws JMSException {
        FileMessageImpl message = new FileMessageImpl(2);
        message.setFile(path);
        message.setJMSPriority(priority);
        return this.send(message, props);
    }

    public Message send(byte[] content, Properties props) throws JMSException {
        BytesMessageImpl message = new BytesMessageImpl(2);
        message.writeBytes(content);
        return this.send(message, props);
    }

    public Message send(byte[] content) throws JMSException {
        return this.send(content, null);
    }

    public Message sendFile(String path) throws JMSException {
        FileMessageImpl message = new FileMessageImpl(2);
        message.setFile(path);
        return this.send(message, null);
    }

    public Message sendFile(String path, Properties props) throws JMSException {
        return this.sendFile(path, props, 4);
    }

    public void closeNotWait() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message send(Message msg, Properties props) throws JMSException {
        StringBuilder sb;
        int retryMaxNum;
        int retry;
        block19: {
            Object var10_13;
            ProducerThread producer;
            block18: {
                try {
                    retry = 0;
                    retryMaxNum = this.clusterQueueSupport.getProducerThreadSizeNotWork();
                    producer = null;
                    sb = new StringBuilder();
                    while (retry < retryMaxNum) {
                        try {
                            try {}
                            catch (JMSException e) {
                                if (this.clusterQueueSupport.getExceptionLinstener(producer.connection) != null) {
                                    ClusterQueueException clusterEx = new ClusterQueueException(producer.connection.toString(), (Exception)((Object)e));
                                    this.clusterQueueSupport.getExceptionLinstener(producer.connection).onException(clusterEx);
                                    ++retry;
                                    sb.append(e.getMessage()).append("\n");
                                    producer = null;
                                    var10_13 = null;
                                    if (producer == null) continue;
                                    this.clusterQueueSupport.addProducer(producer);
                                    continue;
                                }
                                ++retry;
                                if (e.getMessage().indexOf("errorCode:[1017]") > 0) {
                                    if (retry == retryMaxNum) {
                                        throw new JMSException("The queue still full after retry for " + retry + " times");
                                    }
                                    var10_13 = null;
                                    if (producer == null) continue;
                                    this.clusterQueueSupport.addProducer(producer);
                                    continue;
                                }
                                if (!e.getMessage().contains("Cannot perform operation, session is closed") && !e.getMessage().contains("producer is closed")) {
                                    producer = null;
                                    throw e;
                                }
                                if (retry == retryMaxNum) {
                                    throw new JMSException("connection close too more, after retry for " + retry + " times");
                                }
                                producer = null;
                                var10_13 = null;
                                if (producer == null) continue;
                                this.clusterQueueSupport.addProducer(producer);
                                continue;
                            }
                            break block18;
                        }
                        catch (Throwable throwable) {
                            var10_13 = null;
                            if (producer == null) throw throwable;
                            this.clusterQueueSupport.addProducer(producer);
                            throw throwable;
                        }
                    }
                    break block19;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return msg;
            }
            do {
                producer = this.clusterQueueSupport.getProducerThread(500L);
                if (!this.isClosed) continue;
                Message message = msg;
                var10_13 = null;
                if (producer == null) return message;
                this.clusterQueueSupport.addProducer(producer);
                return message;
            } while (producer == null);
            if (this.isClosed) {
                Message message = msg;
                var10_13 = null;
                if (producer == null) return message;
                this.clusterQueueSupport.addProducer(producer);
                return message;
            }
            if (props != null) {
                for (Object object : props.keySet()) {
                    if (object instanceof String) {
                        msg.setObjectProperty((String)object, props.get(object));
                        continue;
                    }
                    logger.warn("Property key must be String type. {}", object);
                }
            }
            producer.sendMessageDirect(msg);
            var10_13 = null;
            if (producer != null) {
                this.clusterQueueSupport.addProducer(producer);
            }
        }
        if (retry != retryMaxNum) return msg;
        throw new JMSException("message send failed, after retry for " + retry + " times, errstr=[\n" + sb.toString() + "]");
    }

    public void close() throws InterruptedException {
    }
}

