/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.backport.java.util.concurrent.BlockingQueue;
import com.tongtech.backport.java.util.concurrent.BoundedPriorityBlockingQueue;
import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.backport.java.util.concurrent.LinkedBlockingQueue;
import com.tongtech.backport.java.util.concurrent.ThreadFactory;
import com.tongtech.backport.java.util.concurrent.ThreadPoolExecutor;
import com.tongtech.backport.java.util.concurrent.TimeUnit;
import com.tongtech.backport.java.util.concurrent.atomic.AtomicInteger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.Queue;
import com.tongtech.tmqi.clusterclient.ClusterConnectionFactory;
import com.tongtech.tmqi.clusterclient.ClusterQueue;
import com.tongtech.tmqi.clusterclient.ClusterQueueConsumer;
import com.tongtech.tmqi.clusterclient.ClusterQueueException;
import com.tongtech.tmqi.clusterclient.ClusterQueueExceptionListener;
import com.tongtech.tmqi.clusterclient.ClusterQueueProducer;
import com.tongtech.tmqi.clusterclient.DynamicLookupThread;
import com.tongtech.tmqi.clusterclient.ProducerThread;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.CRC32;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ClusterQueueSupport {
    static Logger logger = LoggerFactory.getLogger(ClusterQueueSupport.class);
    protected Map clusterFactories;
    private ClusterQueue queue;
    private int sessionNum;
    private int connectionNum;
    private ClusterQueueProducer clusterQueueProdcuer;
    private ClusterQueueConsumer clusterQueueConsumer;
    protected boolean isClosed;
    protected BoundedPriorityBlockingQueue recvMessagePriorityQueue = new BoundedPriorityBlockingQueue(10000, new Comparator(){

        public int compare(Object o1, Object o2) {
            Message msg1 = (Message)o1;
            Message msg2 = (Message)o2;
            try {
                return msg1.getJMSPriority() - msg2.getJMSPriority();
            }
            catch (JMSException e) {
                logger.trace("error ", e);
                return 0;
            }
        }
    });
    protected AtomicInteger producerSize = new AtomicInteger();
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAXIMUM_POOL_SIZE = 128;
    private static final int KEEP_ALIVE = 10;
    private LinkedBlockingQueue clusterProducers;
    private boolean connectionStarted;
    private boolean listenerSetted;
    private final BlockingQueue sWorkQueue = new LinkedBlockingQueue();
    private final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    private final ThreadPoolExecutor sExecutor = new ThreadPoolExecutor(5, 128, 10L, TimeUnit.SECONDS, this.sWorkQueue, this.sThreadFactory);
    private DynamicLookupThread lookupThread;
    private boolean isConnectionCreated;
    private Hashtable<Object, ClusterQueueExceptionListener> exceptionListener;

    public static ClusterQueueSupport createSupport(ClusterQueue clusterQueue) throws NamingException, JMSException {
        ClusterQueueSupport support = new ClusterQueueSupport(clusterQueue);
        return support;
    }

    public static ClusterQueueSupport createSupport(String queueName, String[] addressList) throws JMSException {
        ClusterQueue cq = new ClusterQueue();
        cq.setQueue(new Queue(queueName));
        cq.setBrokerConnectionFactories(addressList);
        return new ClusterQueueSupport(cq);
    }

    private ClusterQueueSupport(ClusterQueue clusterQueue) throws JMSException {
        this.queue = clusterQueue;
        this.clusterProducers = new LinkedBlockingQueue();
        this.clusterFactories = new ConcurrentHashMap();
        this.exceptionListener = new Hashtable();
    }

    private void startLookupThread() {
        this.lookupThread = new DynamicLookupThread(this.queue, this);
        new Thread((Runnable)this.lookupThread, "LookupThread" + System.currentTimeMillis()).start();
    }

    public void createConnection(int sessionNum, int connectionNum, int queueSize) throws JMSException {
        this.sessionNum = sessionNum;
        this.connectionNum = connectionNum;
        for (Map.Entry entry : this.queue.getNameFactoryObject().entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            ClusterConnectionFactory factory = new ClusterConnectionFactory(this, (ConnectionFactory)val);
            this.clusterFactories.put(key, factory);
            factory.createConnection();
        }
        this.isConnectionCreated = true;
    }

    public void createConnection(int sessionNum, int connectionNum) throws JMSException {
        this.createConnection(sessionNum, connectionNum, 0);
    }

    public void createConnection() throws JMSException {
        this.createConnection(1, 1, 1000);
    }

    public int getConnectionNum() {
        return this.connectionNum;
    }

    public static ClusterQueue lookupClusterQueue(String jndiUrl, String queueName) throws NamingException {
        String[] urls = jndiUrl.indexOf(44) > 0 ? jndiUrl.split(",") : new String[]{jndiUrl};
        return ClusterQueueSupport.lookupClusterQueue(urls, queueName);
    }

    private static ClusterQueue lookupClusterQueueByUrl(String jndiUrl, String queueName) throws NamingException {
        Properties pro = new Properties();
        pro.setProperty("java.naming.factory.initial", "tongtech.jms.jndi.JmsContextFactory");
        pro.setProperty("java.naming.provider.url", jndiUrl);
        pro.setProperty("lookupMultiCluster", "true");
        InitialContext ctx = new InitialContext(pro);
        logger.info("Looking up cluster queue :[{}], url :[{}]", (Object)queueName, (Object)jndiUrl);
        ClusterQueue clusterQueue = (ClusterQueue)ctx.lookup(queueName);
        clusterQueue.setJndiUrl(jndiUrl);
        clusterQueue.setQueueName(queueName);
        return clusterQueue;
    }

    public static ClusterQueue lookupClusterQueue(String[] urls, String queueName) throws NamingException {
        if (urls != null) {
            int size = urls.length;
            for (int i = 0; i < size; ++i) {
                ClusterQueue queue;
                try {
                    queue = ClusterQueueSupport.lookupClusterQueueByUrl(urls[i], queueName);
                }
                catch (NamingException e) {
                    continue;
                }
                return queue;
            }
        }
        throw new NamingException("Can't find out cluster queue name :[" + queueName + "] in all the jndi servers");
    }

    protected void setMessageListener() throws JMSException {
        this.listenerSetted = true;
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.setMessageListener();
        }
    }

    public void connectionStart() throws JMSException {
        this.connectionStarted = true;
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.start();
        }
    }

    public void connectionStop() throws JMSException {
        this.connectionStarted = false;
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.stop();
        }
    }

    public ClusterQueueProducer createClusterQueueProducer() throws JMSException {
        if (this.clusterQueueProdcuer == null) {
            this.clusterQueueProdcuer = new ClusterQueueProducer(this);
        }
        return this.clusterQueueProdcuer;
    }

    public ClusterQueueConsumer createClusterQueueConsumer() throws JMSException {
        return this.createClusterQueueConsumer(null);
    }

    public ClusterQueueConsumer createClusterQueueConsumer(String selector) throws JMSException {
        if (this.clusterQueueConsumer == null) {
            this.clusterQueueConsumer = new ClusterQueueConsumer(this, selector, false);
            this.clusterQueueConsumer.createConsumers();
        }
        return this.clusterQueueConsumer;
    }

    public ClusterQueueConsumer createClusterQueuePriorityConsumer() throws JMSException {
        return this.createClusterQueuePriorityConsumer(null);
    }

    public ClusterQueueConsumer createClusterQueuePriorityConsumer(String selector) throws JMSException {
        if (this.clusterQueueConsumer == null) {
            this.clusterQueueConsumer = new ClusterQueueConsumer(this, selector, true);
            this.clusterQueueConsumer.createConsumers();
        }
        return this.clusterQueueConsumer;
    }

    public ClusterQueue getQueue() {
        return this.queue;
    }

    public int getSessionNum() {
        return this.sessionNum;
    }

    public ClusterQueueProducer getClusterQueueProdcuer() {
        return this.clusterQueueProdcuer;
    }

    public ClusterQueueConsumer getClusterQueueConsumer() {
        return this.clusterQueueConsumer;
    }

    public void closeNotWait() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.sExecutor.shutdown();
        if (this.clusterQueueProdcuer != null) {
            this.clusterQueueProdcuer.closeNotWait();
        }
        if (this.lookupThread != null) {
            this.lookupThread.close();
        }
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.close(true);
        }
    }

    public void close() throws InterruptedException {
        if (this.isClosed) {
            return;
        }
        if (this.clusterQueueProdcuer != null) {
            this.clusterQueueProdcuer.close();
        }
        if (this.clusterQueueConsumer != null) {
            this.clusterQueueConsumer.close();
        }
        this.closeNotWait();
    }

    protected void addProducer(ProducerThread pt) {
        this.clusterProducers.add(pt);
    }

    protected void removeProducer(ProducerThread pt) {
        this.clusterProducers.remove(pt);
    }

    protected ProducerThread getProducerThread(long timeout) throws InterruptedException {
        ProducerThread thread = timeout < 0L ? (ProducerThread)this.clusterProducers.take() : (ProducerThread)this.clusterProducers.poll(timeout, TimeUnit.MILLISECONDS);
        return thread;
    }

    protected void executeSend(Runnable command) {
        this.sExecutor.execute(command);
    }

    protected int getProducerThreadSizeNotWork() {
        return this.clusterProducers.size();
    }

    protected boolean isProducerThreadAllinQueue() {
        return this.producerSize.get() == this.getProducerThreadSizeNotWork();
    }

    protected void createConsumers() throws JMSException {
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.createConsumers();
        }
    }

    protected void closeConsumers() {
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.closeConsumers();
        }
    }

    protected void createProducers() throws JMSException {
        for (ClusterConnectionFactory factroy : this.clusterFactories.values()) {
            factroy.createProducers();
        }
    }

    protected boolean isConnectionStarted() {
        return this.connectionStarted;
    }

    protected boolean isListenerSetted() {
        return this.listenerSetted;
    }

    public ClusterQueueExceptionListener getExceptionLinstener(Object key) {
        return this.exceptionListener.get(key);
    }

    public void setExceptionListener(Object key, ClusterQueueExceptionListener exceptionListener) {
        this.exceptionListener.put(key, exceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] argv) {
        block19: {
            ClusterQueueProducer producer = null;
            ClusterQueueConsumer consumer = null;
            ClusterQueueSupport support = null;
            CRC32 crc = new CRC32();
            byte[] ip = new byte[48];
            try {
                byte[] addr = InetAddress.getLocalHost().getHostAddress().getBytes();
                System.arraycopy(addr, 0, ip, 0, addr.length);
                crc.update(ip);
                System.out.println(Long.toHexString(crc.getValue()));
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
            ClusterQueue clusterQueue = ClusterQueueSupport.lookupClusterQueue("tlq://localhost:10024", "cq1");
            support = ClusterQueueSupport.createSupport(clusterQueue);
            support.createConnection(1, 1, 1000);
            support.connectionStart();
            producer = support.createClusterQueueProducer();
            consumer = support.createClusterQueueConsumer();
            Random r = new Random();
            for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                producer.send(new byte[]{0, 1, 2}, new Random(r.nextLong()).nextInt(10));
            }
            consumer.setMessageListener((MessageListener)new ClusterQueueExceptionListener(){

                @Override
                public void onException(ClusterQueueException ex) {
                }
            });
            try {
                ClusterQueueConsumer i = consumer;
                synchronized (i) {
                    consumer.wait(10L);
                }
            }
            catch (InterruptedException e) {
                logger.trace("exception:", e);
            }
            Object var11_15 = null;
            try {
                consumer.close();
                producer.close();
                support.close();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            break block19;
            {
                catch (NamingException e) {
                    e.printStackTrace();
                    logger.trace("exception:", e);
                    Object var11_16 = null;
                    try {
                        consumer.close();
                        producer.close();
                        support.close();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    break block19;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.trace("exception:", e);
                    Object var11_17 = null;
                    try {
                        consumer.close();
                        producer.close();
                        support.close();
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                try {
                    consumer.close();
                    producer.close();
                    support.close();
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

