/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.ConnectionFactory;
import com.tongtech.tmqi.clusterclient.ClusterConnectionFactory;
import com.tongtech.tmqi.clusterclient.ClusterQueue;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import java.util.HashMap;

public class DynamicLookupThread
implements Runnable {
    Logger logger = LoggerFactory.getLogger(DynamicLookupThread.class);
    ClusterQueue clusterQueue;
    private ClusterQueueSupport support;
    private boolean isClosed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.isClosed) {
            try {
                ClusterConnectionFactory cluster;
                Object factory;
                DynamicLookupThread dynamicLookupThread = this;
                synchronized (dynamicLookupThread) {
                    this.wait(60000L);
                }
                if (this.isClosed) {
                    return;
                }
                ClusterQueue newClusterQueue = ClusterQueueSupport.lookupClusterQueue(this.clusterQueue.getJndiUrl(), this.clusterQueue.getQueueName());
                HashMap oldNameFactoryObj = new HashMap();
                oldNameFactoryObj.putAll(this.support.clusterFactories);
                HashMap newNameFactoryObj = newClusterQueue.getNameFactoryObject();
                HashMap<String, Object> deletedFactory = new HashMap<String, Object>();
                for (String jndiName : oldNameFactoryObj.keySet()) {
                    this.logger.trace("oldNameFactoryObj :" + jndiName);
                }
                for (String jndiName : newNameFactoryObj.keySet()) {
                    factory = (ClusterConnectionFactory)oldNameFactoryObj.get(jndiName);
                    if (factory == null) {
                        javax.jms.ConnectionFactory newConnectionFactory = (javax.jms.ConnectionFactory)newNameFactoryObj.get(jndiName);
                        cluster = new ClusterConnectionFactory(this.support, newConnectionFactory);
                        cluster.createConnection();
                        if (this.support.getClusterQueueConsumer() != null) {
                            cluster.createConsumers();
                        }
                        if (this.support.getClusterQueueProdcuer() != null) {
                            cluster.createProducers();
                        }
                        if (this.support.isConnectionStarted()) {
                            cluster.start();
                        }
                        if (this.support.isListenerSetted()) {
                            cluster.setMessageListener();
                        }
                        this.support.clusterFactories.put(jndiName, cluster);
                        this.logger.trace("\ufffd\u00bc\u04f9\ufffd\ufffd\ufffd\ufffd\ufffd" + newConnectionFactory);
                        continue;
                    }
                    this.logger.trace("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                }
                for (String jndiName : oldNameFactoryObj.keySet()) {
                    factory = (ConnectionFactory)newNameFactoryObj.get(jndiName);
                    if (factory == null) {
                        deletedFactory.put(jndiName, factory);
                        Object object = this.support.clusterFactories.get(jndiName);
                        this.logger.trace("\u027e\ufffd\ufffd" + jndiName);
                        if (object == null) continue;
                        cluster = (ClusterConnectionFactory)object;
                        cluster.close(false);
                        this.support.clusterFactories.remove(jndiName);
                        continue;
                    }
                    this.logger.trace("\ufffd\ufffdshanchu");
                }
            }
            catch (Exception e) {
                this.logger.trace("exception:", e);
            }
        }
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notify();
    }

    public DynamicLookupThread(ClusterQueue clusterQueue, ClusterQueueSupport support) {
        this.clusterQueue = clusterQueue;
        this.support = support;
    }
}

