/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.clusterclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.clusterclient.ClusterConnection;
import com.tongtech.tmqi.clusterclient.ClusterQueueSupport;
import java.util.Random;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class ProducerThread {
    private static final int RETRY_TIMES = 1000;
    static Logger logger = LoggerFactory.getLogger(ProducerThread.class);
    private MessageProducer producer;
    protected ClusterConnection connection;
    private Session session;
    Message message = null;
    private ClusterQueueSupport support;
    private boolean isClosed;

    public ProducerThread(ClusterConnection clusterConnection, MessageProducer producer, Session session, ClusterQueueSupport support) {
        this.producer = producer;
        this.connection = clusterConnection;
        this.session = session;
        this.support = support;
    }

    protected synchronized void close() {
        this.isClosed = true;
        try {
            this.producer.close();
            this.session.close();
        }
        catch (JMSException e) {
            logger.trace("exception:", e);
        }
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public static long genRandomTime(long range) {
        Random random = new Random();
        long num = random.nextInt((int)range - 1);
        return num + 1L;
    }

    protected void sendMessageDirect(Message msg) throws JMSException {
        this.producer.setPriority(msg.getJMSPriority());
        this.producer.setDeliveryMode(msg.getJMSDeliveryMode());
        this.producer.setTimeToLive(msg.getJMSExpiration());
        this.producer.send(msg);
    }
}

