/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

public class JMQByteBufferOutputStream
extends OutputStream {
    protected ByteBuffer buf = null;
    private boolean isClosed = false;

    private void ensureOpen() {
    }

    public JMQByteBufferOutputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public synchronized void write(int b) throws BufferOverflowException {
        this.ensureOpen();
        this.buf.put((byte)b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws BufferOverflowException {
        this.ensureOpen();
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buf.put(b, off, len);
    }

    public synchronized void reset() {
        this.ensureOpen();
        this.buf.clear();
    }

    public synchronized ByteBuffer getByteBuffer() {
        return this.buf;
    }

    public int size() {
        return this.buf.capacity();
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.buf = null;
    }
}

