/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.io.JMQByteBufferInputStream;
import com.tongtech.tmqi.io.PacketProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class PacketPayload {
    protected ByteBuffer propBuf_v1 = null;
    protected ByteBuffer propBuf_v2 = null;
    protected Hashtable properties = null;
    protected ByteBuffer bodyBuf = null;

    public PacketPayload() {
        this.reset();
    }

    public synchronized void reset() {
        this.propBuf_v1 = null;
        this.propBuf_v2 = null;
        this.properties = null;
        this.bodyBuf = null;
    }

    public synchronized ByteBuffer getBodyBytes() {
        if (this.bodyBuf == null) {
            return null;
        }
        this.bodyBuf.rewind();
        return this.bodyBuf;
    }

    public int getBodySize() {
        if (this.bodyBuf == null) {
            return 0;
        }
        return this.bodyBuf.limit();
    }

    public InputStream getBodyStream() {
        if (this.bodyBuf == null) {
            return null;
        }
        return new JMQByteBufferInputStream(this.getBodyBytes());
    }

    public synchronized Hashtable getProperties() throws IOException, ClassNotFoundException {
        if (this.properties != null) {
            return this.properties;
        }
        ByteBuffer propBuf = this.propBuf_v2;
        short version = 301;
        if (propBuf == null && this.propBuf_v1 != null) {
            propBuf = this.propBuf_v1;
            version = 200;
        }
        if (propBuf != null) {
            propBuf.rewind();
            try {
                InputStream is = this.getPropertiesStream(version);
                this.properties = version >= 301 ? PacketProperties.parseProperties(is) : this.parseProperties(is);
            }
            catch (IOException e) {
                System.err.println("Could not parse properties " + e);
                e.printStackTrace();
                throw e;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Could not parse properties " + e);
                e.printStackTrace();
                throw e;
            }
            return this.properties;
        }
        return null;
    }

    public synchronized ByteBuffer getPropertiesBytes(short version) {
        ByteBuffer propBuf;
        if (this.propBuf_v1 == null && this.propBuf_v2 == null && this.properties == null) {
            return null;
        }
        ByteBuffer byteBuffer = propBuf = version >= 301 ? this.propBuf_v2 : this.propBuf_v1;
        if (propBuf == null && this.properties == null) {
            try {
                this.getProperties();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (propBuf == null) {
            JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(new byte[256]);
            try {
                if (version >= 301) {
                    PacketProperties.write(this.properties, bos);
                } else {
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(this.properties);
                    oos.close();
                }
            }
            catch (Exception e) {
                System.err.println("Could not marshal properties " + e);
                e.printStackTrace();
            }
            propBuf = ByteBuffer.wrap(bos.getBuf(), 0, bos.getCount());
        }
        propBuf.rewind();
        return propBuf;
    }

    public InputStream getPropertiesStream(short version) {
        ByteBuffer buf = this.getPropertiesBytes(version);
        if (buf == null) {
            return null;
        }
        return new JMQByteBufferInputStream(buf);
    }

    public synchronized void setBody(ByteBuffer body) {
        if (body == null) {
            this.bodyBuf = null;
        } else {
            this.bodyBuf = body;
            this.bodyBuf.rewind();
        }
    }

    public synchronized void setProperties(Hashtable props) {
        this.properties = props;
        this.propBuf_v1 = null;
        this.propBuf_v2 = null;
    }

    public synchronized void setPropertiesBytes(ByteBuffer buf, short version) {
        if (buf == null) {
            this.propBuf_v1 = null;
            this.propBuf_v2 = null;
        } else {
            ByteBuffer propBuf = null;
            propBuf = version >= 301 ? (this.propBuf_v2 = buf) : (this.propBuf_v1 = buf);
            propBuf.rewind();
        }
        this.properties = null;
    }

    private Hashtable parseProperties(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream p = new ObjectInputStream(is);
        return (Hashtable)p.readObject();
    }
}

