/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.Packet;
import java.util.ArrayList;

public class PacketPool {
    ArrayList pool = null;
    static final int INITIALSIZE = 128;
    int capacity = 128;
    int size = 0;
    int hits = 0;
    int misses = 0;
    int drops = 0;
    int adds = 0;
    boolean resetPacket = false;
    boolean dontTimestampPacket = false;

    public PacketPool() {
        this.pool = new ArrayList(128);
    }

    public PacketPool(int capacity) {
        this.capacity = capacity;
        this.pool = new ArrayList(128);
    }

    public PacketPool(int capacity, boolean resetPacket, boolean dontTiemstamp) {
        this.capacity = capacity;
        this.pool = new ArrayList(128);
        this.dontTimestampPacket = dontTiemstamp;
        this.resetPacket = resetPacket;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized Packet get() {
        if (this.size > 0) {
            --this.size;
            ++this.hits;
            return (Packet)this.pool.remove(this.pool.size() - 1);
        }
        ++this.misses;
        Packet p = new Packet();
        if (this.dontTimestampPacket) {
            p.generateSequenceNumber(false);
            p.generateTimestamp(false);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Packet p) {
        if (p == null) {
            return;
        }
        if (this.resetPacket) {
            p.reset();
        }
        PacketPool packetPool = this;
        synchronized (packetPool) {
            if (this.size < this.capacity) {
                ++this.size;
                this.pool.add(p);
                ++this.adds;
            } else {
                ++this.drops;
            }
        }
    }

    public synchronized void clear() {
        this.pool = null;
        this.size = 0;
        this.pool = new ArrayList(128);
    }

    public String toString() {
        return super.toString() + ": capacity=" + this.capacity + ", size=" + this.size;
    }

    public String toDiagString() {
        return this.toString() + ", hits=" + this.hits + ", misses=" + this.misses + ", adds=" + this.adds + ", drops=" + this.drops;
    }
}

