/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import java.util.HashMap;

public class PacketType {
    static Logger logger = LoggerFactory.getLogger(PacketType.class);
    public static final String AC_PRODUCE = "produce";
    public static final String AC_CONSUME = "consume";
    public static final String AC_BROWSE = "browse";
    public static final String AC_DESTCREATE = "create";
    public static final int NONE = 0;
    public static final int CONSUMERID_I_SYSMESSAGEID = 1;
    public static final int CONSUMERID_L_SYSMESSAGEID = 2;
    public static final int SYSMESSAGEID = 3;
    public static final int SESSIONID_SYSMESSAGEID = 4;
    public static final int UNIFICATION_MESSAGE = 1;
    public static final int NULL = 0;
    public static final int TEXT_MESSAGE = 1;
    public static final int BYTES_MESSAGE = 2;
    public static final int MAP_MESSAGE = 3;
    public static final int STREAM_MESSAGE = 4;
    public static final int OBJECT_MESSAGE = 5;
    public static final int MESSAGE = 6;
    public static final int FILE_MESSAGE = 7;
    public static final int SEND_REPLY = 0;
    public static final int HELLO = 10;
    public static final int HELLO_REPLY = 11;
    public static final int AUTHENTICATE = 12;
    public static final int AUTHENTICATE_REPLY = 13;
    public static final int ADD_CONSUMER = 14;
    public static final int ADD_CONSUMER_REPLY = 15;
    public static final int DELETE_CONSUMER = 16;
    public static final int DELETE_CONSUMER_REPLY = 17;
    public static final int ADD_PRODUCER = 18;
    public static final int ADD_PRODUCER_REPLY = 19;
    public static final int START = 20;
    public static final int START_REPLY = 119;
    public static final int STOP = 22;
    public static final int STOP_REPLY = 120;
    public static final int ACKNOWLEDGE = 24;
    public static final int ACKNOWLEDGE_REPLY = 125;
    public static final int BROWSE = 26;
    public static final int BROWSE_REPLY = 123;
    public static final int MESSAGE_SET = 27;
    public static final int GOODBYE = 28;
    public static final int GOODBYE_REPLY = 160;
    public static final int ERROR = 30;
    public static final int REDELIVER = 32;
    public static final int CREATE_DESTINATION = 34;
    public static final int CREATE_DESTINATION_REPLY = 157;
    public static final int TCP_CREATE_DESTINATION_REPLY = 35;
    public static final int DESTROY_DESTINATION = 36;
    public static final int DESTROY_DESTINATION_REPLY = 37;
    public static final int AUTHENTICATE_REQUEST = 38;
    public static final int VERIFY_DESTINATION = 40;
    public static final int VERIFY_DESTINATION_REPLY = 41;
    public static final int DELIVER = 42;
    public static final int DELIVER_REPLY = 168;
    public static final int START_TRANSACTION = 44;
    public static final int START_TRANSACTION_REPLY = 126;
    public static final int COMMIT_TRANSACTION = 46;
    public static final int COMMIT_TRANSACTION_REPLY = 127;
    public static final int ROLLBACK_TRANSACTION = 48;
    public static final int ROLLBACK_TRANSACTION_REPLY = 128;
    public static final int SET_CLIENTID = 50;
    public static final int SET_CLIENTID_REPLY = 51;
    public static final int RESUME_FLOW = 121;
    public static final int PING = 54;
    public static final int PING_REPLY = 55;
    public static final int PREPARE_TRANSACTION = 56;
    public static final int PREPARE_TRANSACTION_REPLY = 57;
    public static final int END_TRANSACTION = 58;
    public static final int END_TRANSACTION_REPLY = 59;
    public static final int RECOVER_TRANSACTION = 60;
    public static final int RECOVER_TRANSACTION_REPLY = 61;
    public static final int GENERATE_UID = 62;
    public static final int GENERATE_UID_REPLY = 63;
    public static final int FLOW_PAUSED = 137;
    public static final int FLOW_PAUSED_REPLY = 65;
    public static final int DELETE_PRODUCER = 66;
    public static final int DELETE_PRODUCER_REPLY = 67;
    public static final int CREATE_SESSION = 68;
    public static final int CREATE_SESSION_REPLY = 69;
    public static final int DESTROY_SESSION = 70;
    public static final int DESTROY_SESSION_REPLY = 71;
    public static final int INFO_REQUEST = 72;
    public static final int INFO = 73;
    public static final int DEBUG = 74;
    public static final int GET_LICENSE = 76;
    public static final int GET_LICENSE_REPLY = 77;
    public static final int VERIFY_TRANSACTION = 78;
    public static final int VERIFY_TRANSACTION_REPLY = 79;
    public static final int LAST = 160;
    public static final int CHECK_IN = 117;
    public static final int CHECK_OUT = 118;
    public static final int SUB_MESSAGE = 210;
    public static final int UNSUBSCRIBE = 211;
    public static final int CONSUMER_CHECKIN = 200;
    public static final int CONSUMER_CHECKOUT = 201;
    public static final int SESSION_CHECKOUT = 202;
    public static final int OPEN_CONECTION = 300;
    public static final int CLOSE_CONECTION = 301;
    public static final int WRITE_CLOSE = 1000;
    public static final int DELIVER_MESSAGE = 168;
    public static final int CREATE_TEMPQUEUE_REPLY = 213;
    public static final int CREATE_TEMPTOPIC_REPLY = 177;
    public static final int DELETE_TEMPQUEUE_REPLY = 216;
    public static final int DELETE_TEMPTOPIC_REPLY = 180;
    public static final int UNSUBSCRIBE_REPLY = 8;
    private static HashMap typeStringMapp = new HashMap();
    private static HashMap replyMap;
    static int DEBUG_LEVEL;
    public static final int VERSION1 = 100;
    public static final int VERSION2 = 200;
    public static final int VERSION350 = 350;
    public static final int VERSION360 = 360;
    public static final int VERSION364 = 364;
    public static final int VERSION400 = 400;
    public static final int VERSION410 = 410;
    private static final String[][] names;

    public static int getReplyType(int n) {
        Object obj = replyMap.get(new Integer(n));
        if (obj == null) {
            logger.warn("NOT FOUND[" + n + "], please add to PacketType.replyMap");
            return -1;
        }
        return (Integer)obj;
    }

    public static String getString(int n) {
        if (DEBUG_LEVEL <= 3) {
            return "";
        }
        String s = (String)typeStringMapp.get(new Integer(n));
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            sb.append("UNKNOWN[");
            sb.append(n);
            sb.append("]");
        } else {
            sb.append(s);
            sb.append("[");
            sb.append(n);
            sb.append("]");
        }
        return sb.toString();
    }

    public static String mapOperation(int n) {
        if (n < 0 || n >= 160) {
            return null;
        }
        return names[n][1];
    }

    public static int getProtocolVersion() {
        return 400;
    }

    static {
        typeStringMapp.put(new Integer(0), "NULL");
        typeStringMapp.put(new Integer(1), "TEXT_MESSAGE[1]]");
        typeStringMapp.put(new Integer(2), "BYTES_MESSAGE[2]");
        typeStringMapp.put(new Integer(3), "MAP_MESSAGE[3]");
        typeStringMapp.put(new Integer(4), "STREAM_MESSAGE[4]");
        typeStringMapp.put(new Integer(5), "OBJECT_MESSAGE[5]");
        typeStringMapp.put(new Integer(6), "MESSAGE[6]");
        typeStringMapp.put(new Integer(7), "FILE_MESSAGE[7]");
        typeStringMapp.put(new Integer(9), "SEND_REPLY[9]");
        typeStringMapp.put(new Integer(10), "HELLO[10]");
        typeStringMapp.put(new Integer(11), "HELLO_REPLY[11]");
        typeStringMapp.put(new Integer(12), "AUTHENTICATE[12]");
        typeStringMapp.put(new Integer(13), "AUTHENTICATE_REPLY[13]");
        typeStringMapp.put(new Integer(14), "ADD_CONSUMER[14]");
        typeStringMapp.put(new Integer(15), "ADD_CONSUMER_REPLY[15]");
        typeStringMapp.put(new Integer(16), "DELETE_CONSUMER[16]");
        typeStringMapp.put(new Integer(17), "DELETE_CONSUMER_REPLY[17]");
        typeStringMapp.put(new Integer(18), "ADD_PRODUCER[18]");
        typeStringMapp.put(new Integer(19), "ADD_PRODUCER_REPLY[19]");
        typeStringMapp.put(new Integer(20), "START[20]");
        typeStringMapp.put(new Integer(119), "START_REPLY[119]");
        typeStringMapp.put(new Integer(22), "STOP[22]");
        typeStringMapp.put(new Integer(120), "STOP_REPLY[120]");
        typeStringMapp.put(new Integer(24), "ACKNOWLEDGE[24]");
        typeStringMapp.put(new Integer(125), "ACKNOWLEDGE_REPLY[125]");
        typeStringMapp.put(new Integer(26), "BROWSE[26]");
        typeStringMapp.put(new Integer(123), "BROWSE_REPLY[123]");
        typeStringMapp.put(new Integer(27), "MESSAGE_SET[27]");
        typeStringMapp.put(new Integer(28), "GOODBYE[28]");
        typeStringMapp.put(new Integer(160), "GOODBYE_REPLY[160]");
        typeStringMapp.put(new Integer(30), "ERROR[30]");
        typeStringMapp.put(new Integer(32), "REDELIVER[32]");
        typeStringMapp.put(new Integer(34), "CREATE_DESTINATION[34]");
        typeStringMapp.put(new Integer(157), "CREATE_DESTINATION_REPLY[157]");
        typeStringMapp.put(new Integer(36), "DESTROY_DESTINATION[36]");
        typeStringMapp.put(new Integer(37), "DESTROY_DESTINATION_REPLY[37]");
        typeStringMapp.put(new Integer(38), "AUTHENTICATE_REQUEST[38]");
        typeStringMapp.put(new Integer(40), "VERIFY_DESTINATION[40]");
        typeStringMapp.put(new Integer(41), "VERIFY_DESTINATION_REPLY[41]");
        typeStringMapp.put(new Integer(42), "DELIVER[42]");
        typeStringMapp.put(new Integer(43), "DELIVER_REPLY[43]");
        typeStringMapp.put(new Integer(44), "START_TRANSACTION[44]");
        typeStringMapp.put(new Integer(126), "START_TRANSACTION_REPLY[126]");
        typeStringMapp.put(new Integer(46), "COMMIT_TRANSACTION[46]");
        typeStringMapp.put(new Integer(127), "COMMIT_TRANSACTION_REPLY[127]");
        typeStringMapp.put(new Integer(48), "ROLLBACK_TRANSACTION[48]");
        typeStringMapp.put(new Integer(128), "ROLLBACK_TRANSACTION_REPLY[128]");
        typeStringMapp.put(new Integer(50), "SET_CLIENTID[50]");
        typeStringMapp.put(new Integer(51), "SET_CLIENTID_REPLY[51]");
        typeStringMapp.put(new Integer(121), "RESUME_FLOW[121]");
        typeStringMapp.put(new Integer(54), "PING[54]");
        typeStringMapp.put(new Integer(55), "PING_REPLY[55]");
        typeStringMapp.put(new Integer(56), "PREPARE_TRANSACTION[56]");
        typeStringMapp.put(new Integer(57), "PREPARE_TRANSACTION_REPLY[57]");
        typeStringMapp.put(new Integer(58), "END_TRANSACTION[58]");
        typeStringMapp.put(new Integer(59), "END_TRANSACTION_REPLY[59]");
        typeStringMapp.put(new Integer(60), "RECOVER_TRANSACTION[60]");
        typeStringMapp.put(new Integer(61), "RECOVER_TRANSACTION_REPLY[61]");
        typeStringMapp.put(new Integer(62), "GENERATE_UID[62]");
        typeStringMapp.put(new Integer(63), "GENERATE_UID_REPLY[63]");
        typeStringMapp.put(new Integer(137), "FLOW_PAUSED[137]");
        typeStringMapp.put(new Integer(65), "FLOW_PAUSED_REPLY[65]");
        typeStringMapp.put(new Integer(66), "DELETE_PRODUCER[66]");
        typeStringMapp.put(new Integer(67), "DELETE_PRODUCER_REPLY[67]");
        typeStringMapp.put(new Integer(68), "CREATE_SESSION[68]");
        typeStringMapp.put(new Integer(69), "CREATE_SESSION_REPLY[69]");
        typeStringMapp.put(new Integer(70), "DESTROY_SESSION[70]");
        typeStringMapp.put(new Integer(71), "DESTROY_SESSION_REPLY[71]");
        typeStringMapp.put(new Integer(72), "INFO_REQUEST[72]");
        typeStringMapp.put(new Integer(73), "INFO[73]");
        typeStringMapp.put(new Integer(74), "DEBUG[74]");
        typeStringMapp.put(new Integer(76), "GET_LICENSE[76]");
        typeStringMapp.put(new Integer(77), "GET_LICENSE_REPLY[77]");
        typeStringMapp.put(new Integer(78), "VERIFY_TRANSACTION[78]");
        typeStringMapp.put(new Integer(79), "VERIFY_TRANSACTION_REPLY[79]");
        typeStringMapp.put(new Integer(80), "LAST[80]");
        typeStringMapp.put(new Integer(117), "CHECK_IN[117]");
        typeStringMapp.put(new Integer(118), "CHECK_OUT[118]");
        typeStringMapp.put(new Integer(210), "SUB_MESSAGE[210]");
        typeStringMapp.put(new Integer(211), "UNSUBSCRIBE[211]");
        typeStringMapp.put(new Integer(200), "CONSUMER_CHECKIN[200]");
        typeStringMapp.put(new Integer(201), "CONSUMER_CHECKOUT[201]");
        typeStringMapp.put(new Integer(202), "SESSION_CHECKOUT[202]");
        typeStringMapp.put(new Integer(300), "OPEN_CONECTION[300]");
        typeStringMapp.put(new Integer(301), "CLOSE_CONECTION[301]");
        typeStringMapp.put(new Integer(1000), "WRITE_CLOSE[1000]");
        typeStringMapp.put(new Integer(168), "DELIVER_MESSAGE[168]");
        typeStringMapp.put(new Integer(171), "CREATE_TEMPQUEUE_REPLY[171]");
        typeStringMapp.put(new Integer(177), "CREATE_TEMPTOPIC_REPLY[177]");
        typeStringMapp.put(new Integer(174), "DELETE_TEMPQUEUE_REPLY[174]");
        typeStringMapp.put(new Integer(180), "DELETE_TEMPTOPIC_REPLY[180]");
        typeStringMapp.put(new Integer(168), "DELIVER_MESSAGE[168]");
        typeStringMapp.put(new Integer(171), "CREATE_TEMPQUEUE_REPLY[171]");
        typeStringMapp.put(new Integer(177), "CREATE_TEMPTOPIC_REPLY[177]");
        typeStringMapp.put(new Integer(174), "DELETE_TEMPQUEUE_REPLY[174]");
        typeStringMapp.put(new Integer(180), "DELETE_TEMPTOPIC_REPLY[180]");
        typeStringMapp.put(new Integer(8), "UNSUBSCRIBE_REPLY[8]");
        replyMap = new HashMap();
        replyMap.put(new Integer(1), new Integer(0));
        replyMap.put(new Integer(2), new Integer(0));
        replyMap.put(new Integer(3), new Integer(0));
        replyMap.put(new Integer(4), new Integer(0));
        replyMap.put(new Integer(5), new Integer(0));
        replyMap.put(new Integer(6), new Integer(0));
        replyMap.put(new Integer(7), new Integer(0));
        replyMap.put(new Integer(10), new Integer(11));
        replyMap.put(new Integer(12), new Integer(13));
        replyMap.put(new Integer(14), new Integer(15));
        replyMap.put(new Integer(16), new Integer(17));
        replyMap.put(new Integer(18), new Integer(19));
        replyMap.put(new Integer(20), new Integer(119));
        replyMap.put(new Integer(22), new Integer(120));
        replyMap.put(new Integer(24), new Integer(125));
        replyMap.put(new Integer(26), new Integer(123));
        replyMap.put(new Integer(28), new Integer(160));
        replyMap.put(new Integer(34), new Integer(157));
        replyMap.put(new Integer(36), new Integer(37));
        replyMap.put(new Integer(40), new Integer(41));
        replyMap.put(new Integer(42), new Integer(168));
        replyMap.put(new Integer(44), new Integer(126));
        replyMap.put(new Integer(46), new Integer(127));
        replyMap.put(new Integer(48), new Integer(128));
        replyMap.put(new Integer(50), new Integer(51));
        replyMap.put(new Integer(54), new Integer(55));
        replyMap.put(new Integer(56), new Integer(57));
        replyMap.put(new Integer(58), new Integer(59));
        replyMap.put(new Integer(60), new Integer(61));
        replyMap.put(new Integer(62), new Integer(63));
        replyMap.put(new Integer(137), new Integer(65));
        replyMap.put(new Integer(65), new Integer(-1));
        replyMap.put(new Integer(66), new Integer(67));
        replyMap.put(new Integer(68), new Integer(69));
        replyMap.put(new Integer(70), new Integer(71));
        replyMap.put(new Integer(76), new Integer(77));
        replyMap.put(new Integer(78), new Integer(79));
        replyMap.put(new Integer(117), new Integer(117));
        replyMap.put(new Integer(118), new Integer(118));
        replyMap.put(new Integer(210), new Integer(210));
        replyMap.put(new Integer(200), new Integer(200));
        replyMap.put(new Integer(201), new Integer(201));
        replyMap.put(new Integer(300), new Integer(300));
        replyMap.put(new Integer(301), new Integer(301));
        replyMap.put(new Integer(1000), new Integer(1000));
        DEBUG_LEVEL = Integer.parseInt(System.getProperty("debug", "4"));
        names = new String[][]{{"NULL", null}, {"TEXT_MESSAGE", null}, {"BYTES_MESSAGE", null}, {"MAP_MESSAGE", null}, {"STREAM_MESSAGE", null}, {"OBJECT_MESSAGE", null}, {"MESSAGE", null}, {"TBD", null}, {"TBD", null}, {"SEND_REPLY", null}, {"HELLO", null}, {"HELLO_REPLY", null}, {"AUTHENTICATE", null}, {"AUTHENTICATE_REPLY", null}, {"ADD_CONSUMER", AC_CONSUME}, {"ADD_CONSUMER_REPLY", null}, {"DELETE_CONSUMER", null}, {"DELETE_CONSUMER_REPLY", null}, {"ADD_PRODUCER", AC_PRODUCE}, {"ADD_PRODUCER_REPLY", null}, {"START", null}, {"TBD", null}, {"STOP", null}, {"STOP_REPLY", null}, {"ACKNOWLEDGE", null}, {"ACKNOWLEDGE_REPLY", null}, {"BROWSE", AC_BROWSE}, {"BROWSE_REPLY", null}, {"GOODBYE", null}, {"GOODBYE_REPLY", null}, {"ERROR", null}, {"TBD", null}, {"REDELIVER", null}, {"TBD", null}, {"CREATE_DESTINATION", AC_DESTCREATE}, {"CREATE_DESTINATION_REPLY", null}, {"DESTROY_DESTINATION", null}, {"DESTROY_DESTINATION_REPLY", null}, {"AUTHENTICATE_REQUEST", null}, {"TBD", null}, {"VERIFY_DESTINATION", null}, {"VERIFY_DESTINATION_REPLY", null}, {"DELIVER", null}, {"DELIVER_REPLY", null}, {"START_TRANSACTION", null}, {"START_TRANSACTION_REPLY", null}, {"COMMIT_TRANSACTION", null}, {"COMMIT_TRANSACTION_REPLY", null}, {"ROLLBACK_TRANSACTION", null}, {"ROLLBACK_REPLY", null}, {"SET_CLIENTID", null}, {"SET_CLIENTID_REPLY", null}, {"RESUME_FLOW", null}, {"TBD", null}, {"PING", null}, {"PING_REPLY", null}, {"PREPARE_TRANSACTION", null}, {"PREPARE_TRANSACTION_REPLY", null}, {"END_TRANSACTION", null}, {"END_TRANSACTION_REPLY", null}, {"RECOVER_TRANSACTION", null}, {"RECOVER_TRANSACTION_REPLY", null}, {"GENERATE_UID", null}, {"GENERATE_UID_REPLY", null}, {"FLOW_PAUSED", null}, {"TBD", null}, {"DELETE_PRODUCER", null}, {"DELETE_PRODUCER_REPLY", null}, {"CREATE_SESSION", null}, {"CREATE_SESSION_REPLY", null}, {"DESTROY_SESSION", null}, {"DESTROY_SESSION_REPLY", null}, {"INFO_REQUEST", null}, {"INFO", null}, {"DEBUG", null}, {"TBD", null}, {"GET_LICENSE", null}, {"GET_LICENSE_REPLY", null}, {"VERIFY_TRANSACTION", null}, {"VERIFY_TRANSACTION_REPLY", null}, {"LAST", null}, {"START_REPLY", null}};
    }
}

