/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.net.IPAddress;
import com.tongtech.tmqi.util.Bits;
import com.tongtech.tmqi.util.TupleOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class SysMessageID
implements Cloneable {
    public static final int ID_SIZE = 32;
    private static String ID_PREFIX = "ID:";
    public int sequence;
    public int port;
    public long timestamp;
    public IPAddress ip;
    private String msgID = null;
    private boolean dirty = true;

    public void clear() {
    }

    public String toString() {
        return "";
    }

    public String getUniqueName() {
        return this.toString();
    }

    public String getUniqueNameOldFormat() {
        String uniqueName = String.valueOf(this.sequence) + String.valueOf(this.timestamp) + String.valueOf(this.port) + IPAddress.rawIPToString(this.ip.getAddress(), false);
        return uniqueName;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getIPAddress() {
        return this.ip.getAddress();
    }

    public void setSequence(int n) {
        this.dirty = true;
        this.sequence = n;
    }

    public void setPort(int n) {
        this.dirty = true;
        this.port = n;
    }

    public void setTimestamp(long n) {
        this.dirty = true;
        this.timestamp = n;
    }

    public void setIPAddress(byte[] newip) throws IllegalArgumentException {
        this.ip.setAddress(newip);
        this.dirty = true;
    }

    public void setIPAddress(byte[] newip, byte[] mac) throws IllegalArgumentException {
        this.ip.setAddress(newip);
        if (mac != null && this.ip.getType() != 2) {
            this.ip.setMac(mac);
        }
        this.dirty = true;
    }

    public void writeID(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        this.ip.writeAddress(out);
        out.writeInt(this.port);
        out.writeInt(this.sequence);
        if (out instanceof DataOutputStream) {
            ((DataOutputStream)out).flush();
        }
    }

    public byte[] getRawID() {
        byte[] buf = new byte[32];
        int i = 0;
        i = Bits.put(buf, i, this.timestamp);
        i = Bits.put(buf, i, this.ip.getAddressUnsafe());
        i = Bits.put(buf, i, this.port);
        Bits.put(buf, i, this.sequence);
        return buf;
    }

    public void readID(DataInput in) throws IOException {
        this.timestamp = in.readLong();
        this.ip.readAddress(in);
        this.port = in.readInt();
        this.sequence = in.readInt();
    }

    public Object clone() {
        try {
            SysMessageID newID = (SysMessageID)super.clone();
            return newID;
        }
        catch (CloneNotSupportedException e) {
            System.out.println("SysMessageID: Could not clone: " + e);
            return null;
        }
    }

    public void writeID(TupleOutput out) throws IOException {
        out.writeLong(this.timestamp);
        this.ip.writeAddress(out);
        out.writeInt(this.port);
        out.writeInt(this.sequence);
        if (out instanceof TupleOutput) {
            out.flush();
        }
    }
}

