/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.VRFile;
import com.tongtech.tmqi.io.VRFileWarning;
import com.tongtech.tmqi.io.VRecord;
import com.tongtech.tmqi.io.VRecordRAF;
import com.tongtech.tmqi.resources.SharedResources;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class VRFileRAF
extends VRFile {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    private RandomAccessFile myRAF = null;
    private FileChannel myChannel = null;

    public VRFileRAF(File file) {
        this(file, 0xA00000L);
    }

    public VRFileRAF(String name) {
        this(new File(name), 0xA00000L);
    }

    public VRFileRAF(String name, long size) {
        this(new File(name), size);
    }

    public VRFileRAF(File file, long size) {
        super(file, size);
    }

    @Override
    public synchronized void open() throws IOException, VRFileWarning {
        this.open(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void open(boolean create) throws IOException, VRFileWarning {
        if (this.opened) {
            return;
        }
        this.myRAF = new RandomAccessFile(this.backingFile, "rw");
        this.myChannel = this.myRAF.getChannel();
        long fsize = this.myRAF.length();
        if (fsize == 0L) {
            if (!create) return;
            this.initNewFile(this.myRAF);
        } else {
            this.loadFile(this.myRAF);
        }
        this.fileSize = this.myRAF.length();
        this.opened = true;
        this.force();
        if (DEBUG) {
            System.out.println("file version=" + this.fileversion);
            System.out.println("number of allocated buffer loaded " + this.allocated.size());
            System.out.println("number of free buffer loaded " + this.numFree);
            System.out.println("safe=" + this.safe);
        }
        if (this.warning == null) return;
        throw this.warning;
    }

    @Override
    public synchronized void close() {
        if (!this.opened) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.backingFile + ": closing...");
            System.out.println("filePointer = " + this.filePointer);
            System.out.println("number of allocated buffers =" + this.allocated.size());
            System.out.println("number of free buffers = " + this.numFree);
        }
        try {
            this.force();
            this.myChannel.close();
            this.myRAF.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.myRAF = null;
        this.reset();
    }

    @Override
    public synchronized int[] getMap() throws IOException {
        if (!this.opened) {
            try {
                this.open(false);
            }
            catch (VRFileWarning vRFileWarning) {
                // empty catch block
            }
        }
        if (this.allocated.size() + this.numFree == 0) {
            return new int[0];
        }
        int[] map = new int[this.allocated.size() + this.numFree];
        int offset = this.fileversion == 2 ? 24 : 16;
        long frompos = offset;
        boolean done = false;
        int index = 0;
        while (!done) {
            this.myRAF.seek(frompos);
            try {
                int magic = this.myRAF.readInt();
                int cap = this.myRAF.readInt();
                short state = this.adjustRecordState(this.fileversion, this.myRAF.readShort());
                switch (state) {
                    case 2: 
                    case 4: {
                        map[index++] = cap;
                        break;
                    }
                    case 1: {
                        map[index++] = 0 - cap;
                        break;
                    }
                    case 1001: {
                        done = true;
                        break;
                    }
                }
                frompos += (long)cap;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    @Override
    public synchronized VRecord allocate(int size) throws IOException {
        VRecord record;
        this.checkOpenAndWrite();
        int allocateSize = (size + 12 + this.blockSize - 1) / this.blockSize * this.blockSize;
        if (DEBUG) {
            System.out.println("allocating " + allocateSize);
        }
        if ((record = this.findFreeRecord(allocateSize)) != null) {
            if (DEBUG) {
                System.out.println("reuse: " + record);
            }
            record.allocate((short)2);
            if (this.safe) {
                record.force();
            }
            --this.numFree;
            ++this.hits;
            if (DEBUG) {
                System.out.println("allocate(): hit, requested " + size + ", allocated " + record.getCapacity());
            }
        } else {
            if (this.numFree > 0) {
                ++this.misses;
            }
            if (this.remaining() < (long)allocateSize) {
                this.growfile(allocateSize + 12);
            }
            record = this.getNewSlice(allocateSize);
        }
        this.putAllocatedList(record);
        if (DEBUG) {
            System.out.println("allcoated record: " + record);
        }
        return record;
    }

    private long remaining() {
        return this.fileSize - this.filePointer;
    }

    @Override
    public synchronized void force() throws IOException {
        this.checkOpen();
        this.myChannel.force(false);
    }

    @Override
    public synchronized void clear(boolean truncate) throws IOException {
        if (this.opened) {
            this.reset();
            this.opened = true;
            if (truncate) {
                this.myRAF.seek(0L);
                this.initNewFile(this.myRAF);
                this.fileSize = this.myRAF.length();
            } else {
                this.myRAF.seek(0L);
                this.writeFileHeader(this.myRAF);
                this.writeLastRecordHeader(this.myRAF);
                this.filePointer = 24L;
            }
            this.force();
        } else {
            if (!this.backingFile.exists()) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(this.backingFile, "rw");
            if (truncate) {
                raf.setLength(0L);
            } else {
                this.writeFileHeader(raf);
                this.writeLastRecordHeader(raf);
            }
            raf.getChannel().force(false);
            raf.close();
        }
    }

    public String toString() {
        return "VRFileRAF:" + this.backingFile + ":# of buffers=" + this.allocated.size() + ":# of free buffers=" + this.numFree + ":file pointer=" + this.filePointer;
    }

    private void initNewFile(RandomAccessFile raf) throws IOException {
        if (DEBUG) {
            System.out.println("Creating new backing file with initial size " + this.initialFileSize);
        }
        raf.setLength(this.initialFileSize);
        this.writeFileHeader(raf);
        this.writeLastRecordHeader(raf);
        this.filePointer = 24L;
    }

    private void loadFile(RandomAccessFile raf) throws IOException {
        byte[] bbuf;
        int num;
        if (DEBUG) {
            System.out.println("Loading backing file with size " + raf.length());
        }
        if ((num = raf.read(bbuf = new byte[16])) != 16) {
            throw new IOException(SharedResources.getResources().getString("S3017", this.backingFile, new Integer(num)));
        }
        short fversion = this.checkFileHeader(ByteBuffer.wrap(bbuf));
        if (fversion == 2) {
            long l = raf.readLong();
        }
        boolean done = false;
        long frompos = raf.getFilePointer();
        long filelength = raf.length();
        ByteBuffer recordheader = ByteBuffer.wrap(new byte[12]);
        while (!done) {
            int capacity = 0;
            VRecordRAF record = null;
            raf.seek(frompos);
            short state = this.getRecordState(raf, recordheader, frompos, filelength);
            switch (state) {
                case 1: 
                case 2: {
                    capacity = recordheader.getInt(4);
                    record = new VRecordRAF(this, frompos, capacity, state);
                    if (state == 2) {
                        if (DEBUG) {
                            System.out.println("loaded record:" + record);
                        }
                        this.putAllocatedList(record);
                    } else {
                        if (DEBUG) {
                            System.out.println("loaded free record:" + record);
                        }
                        this.putFreeList(record, true);
                    }
                    capacity = recordheader.getInt(4);
                    break;
                }
                case 1001: {
                    done = true;
                    break;
                }
                case -7: 
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -2: {
                    long nextstart = this.findGoodRecord(raf, frompos, filelength);
                    if (nextstart == filelength) {
                        raf.seek(frompos);
                        this.writeLastRecordHeader(raf);
                        done = true;
                        VRFileRAF.addWarning(this.getNewWarning(), state, frompos, recordheader, null);
                        break;
                    }
                    capacity = (int)(nextstart - frompos);
                    record = new VRecordRAF(this, frompos, capacity, 1, true);
                    this.putFreeList(record, true);
                    VRFileRAF.addWarning(this.getNewWarning(), state, frompos, recordheader, record);
                    break;
                }
            }
            if (done) {
                raf.seek(frompos);
                this.filePointer = frompos;
                continue;
            }
            frompos += (long)capacity;
        }
    }

    private VRecord getNewSlice(int size) throws IOException {
        long bytesLeft = this.remaining() - (long)size;
        long newPosition = this.filePointer + (long)size;
        VRecordRAF record = new VRecordRAF(this, this.filePointer, size, 2, true);
        this.filePointer += (long)size;
        if (DEBUG) {
            System.out.println("getNewSlice(" + size + "):");
            System.out.println("filePointer advanced to " + this.filePointer);
        }
        this.myRAF.seek(this.filePointer);
        this.writeLastRecordHeader(this.myRAF);
        if (this.safe) {
            ((VRecord)record).force();
        }
        return record;
    }

    private void growfile(int needSize) throws IOException {
        if (DEBUG) {
            System.out.println("growfile(): need to grow file; remaining = " + this.remaining() + "; need = " + needSize);
        }
        long newfileSize = 0L;
        newfileSize = this.isThresholdReached() ? (long)((float)this.fileSize + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)this.fileSize + (float)this.fileSize * this.getGrowthFactor());
        long remaining = this.remaining() + (newfileSize - this.fileSize);
        while (remaining < (long)needSize) {
            newfileSize = this.isThresholdReached() ? (long)((float)newfileSize + (float)this.getThreshold() * this.getThresholdFactor()) : (long)((float)newfileSize + (float)newfileSize * this.getGrowthFactor());
            remaining = this.remaining() + (newfileSize - this.fileSize);
            if (!DEBUG) continue;
            System.out.println("Remaing = " + this.remaining() + " needSize = " + needSize);
        }
        try {
            this.myRAF.setLength(newfileSize);
            this.fileSize = newfileSize;
        }
        catch (IOException e) {
            if (DEBUG) {
                System.out.println(e);
                e.printStackTrace();
                System.out.println("file position= " + this.filePointer);
                System.out.println("current file size= " + this.fileSize);
                System.out.println("new file size= " + newfileSize);
            }
            throw e;
        }
    }

    FileChannel getChannel() {
        this.checkOpen();
        return this.myChannel;
    }

    synchronized int writeByteBuffer(long pos, ByteBuffer bbuf) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:writeByteBuffer writing " + bbuf.remaining() + " bytes from " + pos);
        }
        return this.myChannel.write(bbuf, pos);
    }

    synchronized int readByteBuffer(long pos, ByteBuffer bbuf) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:readByteBuffer reading " + bbuf.remaining() + " bytes from " + pos);
        }
        return this.myChannel.read(bbuf, pos);
    }

    synchronized void writeShort(long pos, short v) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:writeShort writing " + v + " from " + pos);
        }
        this.myRAF.seek(pos);
        this.myRAF.writeShort(v);
    }

    synchronized int readInt(long pos) throws IOException {
        this.myRAF.seek(pos);
        int data = this.myRAF.readInt();
        if (DEBUG) {
            System.out.println("VRFileRAF:readInt read " + data + " from " + pos);
        }
        return data;
    }

    synchronized short readShort(long pos) throws IOException {
        this.myRAF.seek(pos);
        short data = this.myRAF.readShort();
        if (DEBUG) {
            System.out.println("VRFileRAF:readShort read " + data + " from " + pos);
        }
        return data;
    }

    synchronized long readLong(long pos) throws IOException {
        this.myRAF.seek(pos);
        long data = this.myRAF.readLong();
        if (DEBUG) {
            System.out.println("VRFileRAF:readLong read " + data + " from " + pos);
        }
        return data;
    }

    synchronized void writeLong(long pos, long v) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:writeLong writing " + v + " from " + pos);
        }
        this.myRAF.seek(pos);
        this.myRAF.writeLong(v);
    }

    synchronized void writeInt(long pos, int v) throws IOException {
        if (DEBUG) {
            System.out.println("VRFRAF:writeInt writing " + v + " from " + pos);
        }
        this.myRAF.seek(pos);
        this.myRAF.writeInt(v);
    }

    void write(long pos, byte[] buf) throws IOException {
        this.write(pos, buf, 0, buf.length);
    }

    synchronized void write(long pos, byte[] buf, int offset, int len) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:write writing " + len + " bytes from the byte array at offset " + offset + " from file position " + pos);
        }
        this.myRAF.seek(pos);
        this.myRAF.write(buf, offset, len);
    }

    int read(long pos, byte[] buf) throws IOException {
        return this.read(pos, buf, 0, buf.length);
    }

    synchronized int read(long pos, byte[] buf, int offset, int len) throws IOException {
        if (DEBUG) {
            System.out.println("VRFileRAF:read reading up to " + len + " bytes of data from file position " + pos + " into a byte array at offset " + offset);
        }
        this.myRAF.seek(pos);
        int n = this.myRAF.read(buf, offset, len);
        return n;
    }
}

