/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.io;

import com.tongtech.tmqi.io.VRFileMap;
import com.tongtech.tmqi.io.VRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class VRecordMap
extends VRecord {
    private static boolean DEBUG = Boolean.getBoolean("vrfile.debug");
    private VRFileMap vrfile;
    private ByteBuffer bbuf;
    private ByteBuffer databuf;
    private MappedByteBuffer parent;

    VRecordMap(VRFileMap v, MappedByteBuffer p, ByteBuffer buf) {
        this.vrfile = v;
        this.parent = p;
        this.bbuf = buf;
        this.magic = this.bbuf.getInt();
        this.capacity = this.bbuf.getInt();
        this.state = this.bbuf.getShort();
        this.cookie = this.bbuf.getShort();
        this.bbuf.limit(this.capacity);
        this.bbuf.position(12);
        this.databuf = this.bbuf.slice();
    }

    VRecordMap(VRFileMap v, MappedByteBuffer p, ByteBuffer buf, int size) {
        this.vrfile = v;
        this.parent = p;
        this.bbuf = buf;
        this.capacity = size;
        this.state = (short)2;
        this.bbuf.putInt(this.magic);
        this.bbuf.putInt(this.capacity);
        this.bbuf.putShort(this.state);
        this.bbuf.putShort(this.cookie);
        this.bbuf.limit(this.capacity);
        this.bbuf.position(12);
        this.databuf = this.bbuf.slice();
    }

    public ByteBuffer getBuffer() {
        return this.databuf;
    }

    @Override
    public void force() throws IOException {
        if (DEBUG) {
            System.out.println("will do force on " + this.parent);
        }
        this.parent.force();
    }

    @Override
    public void setCookie(short c) throws IOException {
        this.cookie = c;
        this.bbuf.putShort(10, this.cookie);
        if (this.vrfile.getSafe()) {
            this.force();
        }
    }

    @Override
    public short getCookie() {
        return this.cookie;
    }

    public String toString() {
        return "VRecordMap: " + this.bbuf.toString();
    }

    MappedByteBuffer getParent() {
        return this.parent;
    }

    @Override
    void free() {
        this.state = 1;
        this.bbuf.putShort(8, this.state);
        this.bbuf.putShort(10, (short)0);
        this.databuf.rewind();
    }

    @Override
    void allocate(short s) {
        this.state = s;
        this.bbuf.putShort(8, this.state);
    }
}

