/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.PrintStream;
import java.util.logging.Level;

public class AckQueue
extends SessionQueue
implements Traceable {
    static Logger logger;
    protected static long DEFAULT_TIMEOUT;
    private static int DEFAULT_DUMP_COUNTER;
    private static boolean dumpConnectionState;

    public AckQueue() {
    }

    public AckQueue(boolean useSequential, int size) {
        super(useSequential, size);
    }

    public synchronized Object dequeueWait(ConnectionImpl conn, ReadWritePacket pkt, long timeout) {
        long total = 0L;
        long waitTimeout = DEFAULT_TIMEOUT;
        long timeLeft = timeout;
        int icounter = 0;
        if (timeout > 0L && timeout < DEFAULT_TIMEOUT) {
            waitTimeout = timeout;
        }
        while (this.isEmpty() && !this.isClosed) {
            if (icounter > 0) {
                // empty if block
            }
            try {
                this.wait(waitTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isEmpty() || this.isClosed) continue;
            if (this.shouldExit(conn)) {
                return null;
            }
            String ts = String.valueOf((total += waitTimeout) / 1000L);
            if (++icounter == DEFAULT_DUMP_COUNTER) {
                String msg = "[Informational]: \n";
                ConnectionImpl.connectionLogger.log(Level.WARNING, msg);
                if (dumpConnectionState) {
                    // empty if block
                }
            }
            if (timeout > 0L) {
                if ((timeLeft -= waitTimeout) > 0L) {
                    if (timeLeft < (waitTimeout *= 2L)) {
                        waitTimeout = timeLeft;
                    }
                } else {
                    this.isClosed = true;
                }
            } else {
                waitTimeout *= 2L;
            }
            if (!logger.isTraceEnabled()) continue;
            logger.trace("*** wait time out: {}", waitTimeout);
        }
        if (this.isClosed) {
            return null;
        }
        return this.dequeue();
    }

    private boolean shouldExit(ConnectionImpl conn) {
        return conn.connectionIsBroken || conn.protocolHandler == null || conn.recoverInProcess;
    }

    protected void resend(ConnectionImpl conn, ReadWritePacket pkt) {
        try {
            boolean shouldResend = this.checkPacketType(conn, pkt);
            if (shouldResend) {
                conn.protocolHandler.resend(pkt);
            }
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("", e);
            }
            this.isClosed = true;
        }
    }

    private boolean checkPacketType(ConnectionImpl conn, ReadWritePacket pkt) {
        if (!conn.isConnectedToHABroker) {
            return false;
        }
        boolean canResend = false;
        int ptype = pkt.getPacketType();
        switch (ptype) {
            case 10: 
            case 14: 
            case 18: 
            case 22: 
            case 28: 
            case 34: 
            case 46: 
            case 48: 
            case 50: 
            case 56: 
            case 68: 
            case 76: 
            case 78: {
                canResend = true;
                break;
            }
            default: {
                canResend = false;
            }
        }
        return canResend;
    }

    protected void printInfo(ConnectionImpl conn, ReadWritePacket pkt, String duration) {
    }

    @Override
    public void dump(PrintStream ps) {
    }

    static {
        block5: {
            logger = LoggerFactory.getLogger(AckQueue.class);
            DEFAULT_TIMEOUT = 120000L;
            DEFAULT_DUMP_COUNTER = 3;
            dumpConnectionState = true;
            try {
                boolean nostate;
                String dump_prop;
                String prop = System.getProperty("tmqi.ackWaitTime");
                if (prop != null) {
                    DEFAULT_TIMEOUT = Long.parseLong(prop);
                }
                if ((dump_prop = System.getProperty("tmqi.ackDumpCount")) != null) {
                    DEFAULT_DUMP_COUNTER = Integer.parseInt(dump_prop);
                }
                if (nostate = Boolean.getBoolean("tmqi.noConnectionState")) {
                    dumpConnectionState = false;
                }
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block5;
                logger.trace("", e);
            }
        }
    }
}

