/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.QueueBrowserImpl;
import com.tongtech.tmqi.jmsclient.ReceiveQueue;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public abstract class BrowserConsumer
extends Consumer
implements Enumeration,
Traceable {
    static Logger logger = LoggerFactory.getLogger(BrowserConsumer.class);
    public SessionImpl session = null;
    protected QueueBrowserImpl browser = null;
    protected ReceiveQueue receiveQueue = null;
    protected long browseTimeout = 60000L;
    protected int browseChunkLimit = 1000;
    protected SysMessageID[] messageIDs = null;
    protected int cursor = 0;
    protected int cursorEnd = 0;
    protected int waitCounter = 0;
    private List messageIDList;
    private static int browserMaxMessage = 800;

    public BrowserConsumer(QueueBrowserImpl browser, Destination dest) throws JMSException {
        this(browser, dest, null);
    }

    public BrowserConsumer(QueueBrowserImpl browser, Destination dest, String messageSelector) throws JMSException {
        super(browser.getSession().getConnection(), dest, messageSelector, false);
        this.browser = browser;
        this.session = browser.getSession();
        try {
            this.browseTimeout = Long.parseLong(this.session.getConnection().getProperty("tmqiQueueBrowserRetrieveTimeout"));
            this.browseChunkLimit = Integer.parseInt(this.session.getConnection().getProperty("tmqiQueueBrowserMaxMessagesPerRetrieve"));
            if (this.browseChunkLimit > browserMaxMessage) {
                this.browseChunkLimit = browserMaxMessage;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.init();
    }

    protected abstract void init() throws JMSException;

    protected void addInterest() {
        this.connection.addLocalInterest(this);
    }

    private void removeInterest() {
        this.connection.removeLocalInterest(this);
        this.session.removeBrowserConsumer(this);
        FlowControl fc = this.connection.flowControl;
        fc.removeConsumerFlowControl(this);
    }

    @Override
    public Long getReadQueueId() {
        return this.session.getSessionId();
    }

    @Override
    public void onMessage(MessageImpl message) throws JMSException {
        if (this.receiveQueue.getIsClosed()) {
            return;
        }
        this.receiveQueue.enqueueNotify(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message receive(long timeout) throws JMSException {
        MessageImpl message = null;
        try {
            message = (MessageImpl)this.receiveQueue.dequeueWait(timeout);
            if (message != null) {
                message.setIsBrowserMsg(true);
            }
        }
        finally {
            this.receiveQueue.setReceiveInProcess(false);
        }
        return message;
    }

    protected void moreMessage() throws JMSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
        DataOutputStream dos = new DataOutputStream(bos);
        boolean moreComming = false;
        SysMessageID messageID = null;
        while (!moreComming && this.cursor <= this.cursorEnd) {
            int count;
            for (count = 0; this.cursor <= this.cursorEnd && count < this.browseChunkLimit; ++count) {
                messageID = this.messageIDs[this.cursor];
                try {
                    messageID.writeID(dos);
                }
                catch (IOException e) {
                    ExceptionHandler.handleException((Exception)e, "C4038");
                }
                ++this.cursor;
            }
            if (count <= 0) continue;
            try {
                dos.flush();
                bos.flush();
            }
            catch (IOException e) {
                ExceptionHandler.handleException((Exception)e, "C4038");
            }
            moreComming = this.session.requestMessages(bos, this);
            bos.reset();
        }
        if (moreComming) {
            ++this.waitCounter;
        }
    }

    @Override
    public abstract boolean hasMoreElements();

    private boolean requestMessage() throws JMSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
        DataOutputStream dos = new DataOutputStream(bos);
        boolean moreComming = false;
        SysMessageID messageID = null;
        int listSize = this.messageIDList.size();
        int j = 0;
        while (!moreComming && j < listSize) {
            int count;
            ArrayList<SysMessageID> removeList = null;
            for (count = 0; j < listSize && count < this.browseChunkLimit; ++count, ++j) {
                removeList = new ArrayList<SysMessageID>();
                messageID = (SysMessageID)this.messageIDList.get(j);
                removeList.add(messageID);
                try {
                    messageID.writeID(dos);
                }
                catch (IOException e) {
                    ExceptionHandler.handleException((Exception)e, "C4038");
                }
                ++this.cursor;
            }
            if (count > 0) {
                try {
                    dos.flush();
                    bos.flush();
                }
                catch (IOException e) {
                    ExceptionHandler.handleException((Exception)e, "C4038");
                }
                moreComming = this.session.requestMessages(bos, this);
                bos.reset();
                if (removeList != null && removeList.size() != 0) {
                    this.messageIDList.removeAll(removeList);
                }
            }
            if (!moreComming) continue;
            return true;
        }
        return false;
    }

    public abstract Object nextElement();

    protected boolean isLast(MessageImpl message) {
        return message.getPacket().getIsLast();
    }

    protected QueueBrowserImpl getBrowser() {
        return this.browser;
    }

    @Override
    public SessionImpl getSession() {
        return this.session;
    }

    protected void close() {
        if (this.receiveQueue.getIsClosed()) {
            return;
        }
        this.receiveQueue.close();
        this.removeInterest();
        if (logger.isTraceEnabled()) {
            logger.trace("browser consumer closed ...{}", this);
        }
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

