/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.MessageEOFException;
import com.tongtech.jms.MessageFormatException;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.JMQByteArrayOutputStream;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
Traceable {
    private byte[] messageBody = null;
    private JMQByteArrayOutputStream byteArrayOutputStream = null;
    private DataOutputStream dataOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private DataInputStream dataInputStream = null;
    private boolean bufferIsDirty = false;
    private int validCount = 0;

    public BytesMessageImpl(int protocolType) throws JMSException {
        super(protocolType);
        this.setPacketType(2);
        this.initOutputStream();
    }

    protected BytesMessageImpl(boolean constructOutputStream, int protocolType) throws JMSException {
        this(protocolType);
        if (constructOutputStream) {
            this.initOutputStream();
        }
    }

    protected void initOutputStream() {
        this.byteArrayOutputStream = new JMQByteArrayOutputStream(new byte[32]);
        this.dataOutputStream = new DataOutputStream(this.byteArrayOutputStream);
        this.validCount = 0;
    }

    @Override
    public void setMessageBodyToPacket() throws JMSException {
        this.reset();
        if (this.getStringProperty("JMS_TONG_SM4_ID") != null) {
            this.setIntProperty("JMS_TONG_SM4_LEN", this.validCount);
            this.messageBody = this.sm4crypt(this.messageBody, this.getStringProperty("JMS_TONG_SM4_ID"));
            this.validCount = this.messageBody.length;
        }
        this.pkt.setMessageBody(this.messageBody, 0, this.validCount);
    }

    @Override
    public void getMessageBodyFromPacket() throws JMSException {
        this.messageBody = this.getMessageBody();
        int blen = 0;
        if (this.getStringProperty("JMS_TONG_SM4_ID") != null) {
            this.messageBody = this.sm4decrypt(this.messageBody, this.getStringProperty("JMS_TONG_SM4_ID"));
            blen = this.getIntProperty("JMS_TONG_SM4_LEN");
        }
        this.validCount = this.messageBody == null ? 0 : (blen > 0 ? blen : this.messageBody.length);
        this.reset();
    }

    protected void setBufferIsDirty(boolean state) {
        this.bufferIsDirty = state;
    }

    protected boolean getBufferIsDirty() {
        return this.bufferIsDirty;
    }

    @Override
    public void clearBody() throws JMSException {
        this.messageBody = null;
        this.setMessageBody(null);
        this.initOutputStream();
        this.setMessageReadMode(false);
    }

    public long getBodyLength() throws JMSException {
        this.checkReadAccess();
        if (this.messageBody == null) {
            return 0L;
        }
        return this.validCount;
    }

    public boolean readBoolean() throws JMSException {
        boolean value = false;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readBoolean();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (IOException ioe) {
            ExceptionHandler.handleException(ioe, "C4010", true);
        }
        return value;
    }

    public byte readByte() throws JMSException {
        byte value = 0;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readByte();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public int readUnsignedByte() throws JMSException {
        int value = 0;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readUnsignedByte();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public short readShort() throws JMSException {
        short value = 0;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readShort();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public int readUnsignedShort() throws JMSException {
        int value = 0;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readUnsignedShort();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public char readChar() throws JMSException {
        char value = '\u0000';
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readChar();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public int readInt() throws JMSException {
        int value = 0;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readInt();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public long readLong() throws JMSException {
        long value = 0L;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readLong();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public float readFloat() throws JMSException {
        float value = 0.0f;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readFloat();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public double readDouble() throws JMSException {
        double value = 0.0;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readDouble();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public String readUTF() throws JMSException {
        String value = null;
        this.checkReadAccess();
        try {
            value = this.dataInputStream.readUTF();
        }
        catch (EOFException eofe) {
            String errorString = ExceptionHandler.getExceptionMessage(eofe, "C4013");
            MessageEOFException meofe = new MessageEOFException(errorString, "C4013");
            ExceptionHandler.handleException((Exception)eofe, (JMSException)((Object)meofe));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return value;
    }

    public int readBytes(byte[] value) throws JMSException {
        int bytesRead = -1;
        this.checkReadAccess();
        try {
            bytesRead = this.dataInputStream.read(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return bytesRead;
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        int bytesRead = -1;
        this.checkReadAccess();
        try {
            bytesRead = this.dataInputStream.read(value, 0, length);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4010", true);
        }
        return bytesRead;
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeBoolean(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeByte(byte value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeByte(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeShort(short value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeShort(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeChar(char value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeChar(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeInt(int value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeInt(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeLong(long value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeLong(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeFloat(float value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeFloat(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeDouble(double value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeDouble(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeUTF(String value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.writeUTF(value);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.write(value);
        }
        catch (NullPointerException nullpe) {
            throw nullpe;
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkMessageAccess();
        try {
            this.dataOutputStream.write(value, offset, length);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4011", true);
        }
        this.setBufferIsDirty(true);
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof String) {
            this.writeUTF((String)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else {
            String errorString = AdministeredObject.cr.getKString("C4017");
            MessageFormatException jmse = new MessageFormatException(errorString, "C4017");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.bufferIsDirty) {
                this.dataOutputStream.flush();
                this.messageBody = this.byteArrayOutputStream.getBuf();
                this.validCount = this.byteArrayOutputStream.getCount();
                this.dataOutputStream.close();
                this.byteArrayOutputStream.close();
            }
            if (this.messageBody == null) {
                this.messageBody = new byte[0];
                this.validCount = 0;
            }
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody, 0, this.validCount);
            this.dataInputStream = new DataInputStream(this.byteArrayInputStream);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4012", true);
        }
        this.setBufferIsDirty(false);
        this.setMessageReadMode(true);
    }

    @Override
    public void dump(PrintStream ps) {
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

