/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ClusterConnectionFactoryImpl;
import com.tongtech.tmqi.jmsclient.ClusterConnectionMetaDataImpl;
import com.tongtech.tmqi.jmsclient.ClusterSessionImpl;
import com.tongtech.tmqi.jmsclient.ConnectionRecordContainer;
import com.tongtech.tmqi.jmsclient.QueueClusterSessionImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import tongtech.jms.jndi.TlqFactoryRecord;

public class ClusterConnectionImpl
implements Connection,
Runnable,
XAConnection {
    private ClusterConnectionFactoryImpl clusterFactory;
    private List<TlqFactoryRecord> factoryRecords;
    private HashMap<Integer, ConnectionRecordContainer> connectionRecovery;
    private boolean isClosed = false;
    private static final int SLEEP_INTERVAL = 6000;
    private int sessionId = 0;
    protected boolean isXAConnection = false;

    public ClusterConnectionImpl(ClusterConnectionFactoryImpl clusterFactory) {
        this.clusterFactory = clusterFactory;
        this.init();
        if (this.clusterFactory.isXAConnectionFactory()) {
            this.isXAConnection = true;
        }
    }

    private void init() {
        this.factoryRecords = this.clusterFactory.getClusterFactories();
        this.connectionRecovery = new HashMap();
        for (int i = 0; i < this.factoryRecords.size(); ++i) {
            ConnectionRecordContainer recordContainer = new ConnectionRecordContainer(this.factoryRecords.get(i));
            this.connectionRecovery.put(this.factoryRecords.get(i).getRecordId(), recordContainer);
        }
    }

    public HashMap<Integer, ConnectionRecordContainer> getConnectionRecovery() {
        return this.connectionRecovery;
    }

    public void setConnectionRecovery(HashMap<Integer, ConnectionRecordContainer> connectionRecovery) {
        this.connectionRecovery = connectionRecovery;
    }

    private synchronized int createSessionId() {
        ++this.sessionId;
        return this.sessionId;
    }

    public void close() throws JMSException {
        this.isClosed = true;
        Set<Integer> keys = this.connectionRecovery.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        if (ids.length > 0) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(ids[0]);
            HashMap<Integer, ClusterSessionImpl> clusterSessions = recordContainer.getSessions();
            Set<Integer> skeys = clusterSessions.keySet();
            Integer[] sids = new Integer[skeys.size()];
            skeys.toArray(sids);
            for (int i = 0; i < sids.length; ++i) {
                ClusterSessionImpl clusterSession = clusterSessions.get(sids[i]);
                clusterSession.close();
            }
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination arg0, String arg1, ServerSessionPool arg2, int arg3) throws JMSException {
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        return null;
    }

    public Session createSession(boolean arg0, int arg1) throws JMSException {
        if (this.isXAConnection) {
            return this.createXASession();
        }
        if (!arg0 && arg1 != 1 && arg1 != 2) {
            throw new JMSException("cluster only support auto_acknowledge or client_acknowledge mode");
        }
        int sid = this.createSessionId();
        ClusterSessionImpl sess = null;
        sess = arg0 || arg1 == 0 ? new ClusterSessionImpl(this, sid, true, false) : new ClusterSessionImpl(this, sid);
        sess.setAcknowledgeMode(arg1);
        Set<Integer> keys = this.connectionRecovery.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(ids[i]);
            recordContainer.addSession(sid, sess);
        }
        return sess;
    }

    protected QueueSession createQueueSession(boolean arg0, int arg1) throws JMSException {
        if (this.isXAConnection) {
            throw new JMSException("Connection is currently  a XAConnection");
        }
        if (!arg0 && arg1 != 1 && arg1 != 2) {
            throw new JMSException("cluster only support auto_acknowledge or client_acknowledge mode");
        }
        int sid = this.createSessionId();
        QueueClusterSessionImpl sess = null;
        sess = arg0 || arg1 == 0 ? new QueueClusterSessionImpl(this, sid, true, false) : new QueueClusterSessionImpl(this, sid);
        sess.setAcknowledgeMode(arg1);
        Set<Integer> keys = this.connectionRecovery.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(ids[i]);
            recordContainer.addSession(sid, sess);
        }
        return sess;
    }

    public String getClientID() throws JMSException {
        return null;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return null;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return new ClusterConnectionMetaDataImpl();
    }

    public void setClientID(String arg0) throws JMSException {
    }

    public void setExceptionListener(ExceptionListener arg0) throws JMSException {
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    @Override
    public void run() {
        while (!this.isClosed) {
            try {
                Thread.currentThread();
                Thread.sleep(6000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Set<Integer> keys = this.connectionRecovery.keySet();
            Integer[] ids = new Integer[keys.size()];
            keys.toArray(ids);
            if (ids.length <= 0) continue;
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(ids[0]);
            HashMap<Integer, ClusterSessionImpl> clusterSessions = recordContainer.getSessions();
            Set<Integer> skeys = clusterSessions.keySet();
            Integer[] sids = new Integer[skeys.size()];
            skeys.toArray(sids);
            for (int i = 0; i < sids.length; ++i) {
                ClusterSessionImpl clusterSession = clusterSessions.get(sids[i]);
                if (!clusterSession.isBad()) continue;
                for (int j = 0; j < ids.length; ++j) {
                    clusterSessions.remove(sids[i]);
                }
            }
        }
    }

    public XASession createXASession() throws JMSException {
        if (!this.isXAConnection) {
            throw new JMSException("Connection is not a XAConnection");
        }
        int sid = this.createSessionId();
        ClusterSessionImpl xasess = new ClusterSessionImpl(this, sid, false, true);
        Set<Integer> keys = this.connectionRecovery.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(ids[i]);
            recordContainer.addSession(sid, xasess);
        }
        return xasess;
    }

    protected XAQueueSession createXAQueueSession() throws JMSException {
        if (!this.isXAConnection) {
            throw new JMSException("Connection is not a XAConnection");
        }
        int sid = this.createSessionId();
        QueueClusterSessionImpl xasess = new QueueClusterSessionImpl(this, sid, false, true);
        Set<Integer> keys = this.connectionRecovery.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(ids[i]);
            recordContainer.addSession(sid, xasess);
        }
        return xasess;
    }
}

