/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.atomikos.icatch.jta.UserTransactionManager;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class ClusterLocalXAResourceManager {
    UserTransactionManager tm;
    Transaction tx;
    List<XAResource> xaResourceList;
    Object lock = new Object();

    public ClusterLocalXAResourceManager() throws SystemException, NotSupportedException {
        this.tm = new UserTransactionManager();
        this.tm.begin();
        this.tx = this.tm.getTransaction();
    }

    public List<XAResource> getXAResourceList() {
        return this.xaResourceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXAResource(XAResource resource) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            this.xaResourceList.add(resource);
            try {
                this.tx.enlistResource(resource);
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeXAResource(XAResource resource) throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            this.xaResourceList.remove(resource);
            try {
                this.tx.delistResource(resource, 0x4000000);
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            Iterator<XAResource> it;
            try {
                it = this.xaResourceList.iterator();
                while (it.hasNext()) {
                    this.tx.delistResource(it.next(), 0x4000000);
                }
                this.tm.commit();
            }
            catch (Exception e) {
                try {
                    this.tm.rollback();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw new JMSException(e.getMessage());
            }
            try {
                it = this.xaResourceList.iterator();
                while (it.hasNext()) {
                    this.tx.enlistResource(it.next());
                }
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        Object object = this.lock;
        synchronized (object) {
            Iterator<XAResource> it;
            boolean rollbackFlag = false;
            try {
                it = this.xaResourceList.iterator();
                while (it.hasNext()) {
                    this.tx.delistResource(it.next(), 0x4000000);
                }
                rollbackFlag = true;
                this.tm.rollback();
            }
            catch (Exception e) {
                try {
                    if (!rollbackFlag) {
                        this.tm.rollback();
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw new JMSException(e.getMessage());
            }
            try {
                it = this.xaResourceList.iterator();
                while (it.hasNext()) {
                    this.tx.enlistResource(it.next());
                }
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
    }

    public void close() {
    }
}

