/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ClusterReceiver;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;

public class ClusterMessage {
    private Message msg;
    private ClusterReceiver receiver;
    private ArrayBlockingQueue notifyQueue;

    public Message getMsg() {
        return this.msg;
    }

    public void setMsg(Message msg) {
        this.msg = msg;
    }

    public ClusterReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(ClusterReceiver receiver) {
        this.receiver = receiver;
        this.notifyQueue = receiver.getNotifyQueue();
    }

    public void alarm() {
        if (this.notifyQueue != null) {
            this.notifyQueue.offer(new Object());
        }
    }

    public boolean setAlarm() throws InterruptedException {
        if (this.notifyQueue != null) {
            this.notifyQueue.take();
            return true;
        }
        return false;
    }

    public boolean setAlarm(int seconds) throws InterruptedException {
        if (this.notifyQueue != null) {
            Object obj = this.notifyQueue.poll(seconds, TimeUnit.SECONDS);
            return obj != null;
        }
        return false;
    }

    public void commit() throws JMSException {
        if (this.receiver != null) {
            this.receiver.commit();
        }
    }

    public void close() throws JMSException {
        if (this.receiver != null) {
            this.receiver.closeConnection();
        }
    }
}

