/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.XAQueueConnectionFactory;
import com.tongtech.tmqi.jmsclient.ClusterId;
import com.tongtech.tmqi.jmsclient.ClusterLocalXAResourceManager;
import com.tongtech.tmqi.jmsclient.ClusterMessage;
import com.tongtech.tmqi.jmsclient.ClusterReceiver;
import com.tongtech.tmqi.jmsclient.ClusterSessionImpl;
import com.tongtech.tmqi.jmsclient.ClusterUtils;
import com.tongtech.tmqi.jmsclient.ClusterXAResourceImpl;
import com.tongtech.tmqi.jmsclient.ConnectionRecordContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class ClusterMessageConsumerImpl
implements MessageConsumer,
Runnable {
    public static final int MIN_CACHE_CAPACITY = 1;
    public static final int DEFAULT_CACHE_CAPACITY = 10000;
    private ArrayBlockingQueue receiveQueue = null;
    private ClusterSessionImpl clusterSession;
    private HashMap<Integer, ConnectionRecordContainer> connectionRecovery;
    private int activeNum = 0;
    private Boolean isClosed = false;
    private HashMap<Integer, ClusterReceiver> receivers = new HashMap();
    private Destination destination;
    private ClusterId recordIds = new ClusterId();
    private int reconnectInterval = 30;
    private static final int SLEEP_INTERVAL = 3000;
    private String messageSelector = null;
    private MessageListener messageListener = null;
    private boolean noLocal = false;
    private Boolean toggled = false;
    private int cachSize = 10000;
    private Boolean enableLocalTrans = false;
    private ClusterXAResourceImpl clusterXAResource = null;
    private ClusterLocalXAResourceManager localXAManager = null;

    public ClusterMessageConsumerImpl(ClusterSessionImpl clusterSession, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        this.clusterSession = clusterSession;
        this.destination = destination;
        this.messageSelector = messageSelector;
        if (clusterSession.getTransacted()) {
            this.initLocalXA();
        } else if (clusterSession.isXATransaction()) {
            this.initXA();
        } else {
            this.init();
        }
    }

    private void init() throws JMSException {
        int i;
        this.connectionRecovery = this.clusterSession.getClusterConnection().getConnectionRecovery();
        Set<Integer> keys = this.connectionRecovery.keySet();
        this.activeNum = keys.size();
        Integer[] intKeys = new Integer[this.activeNum];
        keys.toArray(intKeys);
        for (i = 0; i < this.activeNum; ++i) {
            this.recordIds.add(intKeys[i]);
        }
        this.reconnectInterval = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getReconnectInterval();
        this.cachSize = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getConsumerCacheSize();
        this.receiveQueue = new ArrayBlockingQueue(this.cachSize, true);
        if (this.cachSize == 1) {
            this.enableLocalTrans = true;
        }
        for (i = 0; i < this.activeNum; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(intKeys[i]);
            this.clusterSession.getConsumers().add(this);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            QueueConnectionFactory qcf = null;
            Connection conn = null;
            Session sess = null;
            MessageConsumer consumer = null;
            boolean initOK = false;
            try {
                qcf = new QueueConnectionFactory();
                qcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(qcf, recordContainer.getFactoryRecord());
                conn = qcf.createConnection();
                sess = this.enableLocalTrans.booleanValue() ? conn.createSession(true, 0) : conn.createSession(false, this.clusterSession.getAcknowledgeMode());
                consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                initOK = true;
            }
            catch (JMSException e) {
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            ClusterReceiver receiver = new ClusterReceiver(intKeys[i]);
            receiver.setEnableLocalTran(this.enableLocalTrans);
            receiver.setConn(conn);
            receiver.setSess(sess);
            receiver.setConsumer(consumer);
            receiver.setStatus(2);
            this.receivers.put(intKeys[i], receiver);
        }
        if (this.receivers.keySet().size() == 0) {
            this.isClosed = true;
            throw new JMSException("no connection available");
        }
        new Thread(this).start();
    }

    private void initXA() throws JMSException {
        int i;
        this.connectionRecovery = this.clusterSession.getClusterConnection().getConnectionRecovery();
        Set<Integer> keys = this.connectionRecovery.keySet();
        this.activeNum = keys.size();
        Integer[] intKeys = new Integer[this.activeNum];
        keys.toArray(intKeys);
        for (i = 0; i < this.activeNum; ++i) {
            this.recordIds.add(intKeys[i]);
        }
        this.reconnectInterval = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getReconnectInterval();
        this.clusterXAResource = (ClusterXAResourceImpl)this.clusterSession.getXAResource();
        this.cachSize = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getConsumerCacheSize();
        this.receiveQueue = new ArrayBlockingQueue(this.cachSize, true);
        for (i = 0; i < this.activeNum; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(intKeys[i]);
            this.clusterSession.getConsumers().add(this);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageConsumer consumer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.clusterXAResource.addXAResource(xaResource);
                consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.clusterXAResource.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            ClusterReceiver receiver = new ClusterReceiver(intKeys[i]);
            receiver.setEnableLocalTran(false);
            receiver.setConn((Connection)conn);
            receiver.setSess((Session)sess);
            receiver.setConsumer(consumer);
            receiver.setClusterXAResource(this.clusterXAResource);
            receiver.setStatus(2);
            this.receivers.put(intKeys[i], receiver);
        }
        if (this.receivers.keySet().size() == 0) {
            this.isClosed = true;
            throw new JMSException("no connection available");
        }
        new Thread(this).start();
    }

    private void initLocalXA() throws JMSException {
        int i;
        this.connectionRecovery = this.clusterSession.getClusterConnection().getConnectionRecovery();
        Set<Integer> keys = this.connectionRecovery.keySet();
        this.activeNum = keys.size();
        Integer[] intKeys = new Integer[this.activeNum];
        keys.toArray(intKeys);
        for (i = 0; i < this.activeNum; ++i) {
            this.recordIds.add(intKeys[i]);
        }
        this.reconnectInterval = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getReconnectInterval();
        this.clusterXAResource = (ClusterXAResourceImpl)this.clusterSession.getXAResource();
        this.cachSize = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getConsumerCacheSize();
        this.receiveQueue = new ArrayBlockingQueue(this.cachSize, true);
        this.localXAManager = this.clusterSession.getLocalXAResourceManager();
        for (i = 0; i < this.activeNum; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(intKeys[i]);
            this.clusterSession.getConsumers().add(this);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageConsumer consumer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.localXAManager.addXAResource(xaResource);
                consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.localXAManager.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            ClusterReceiver receiver = new ClusterReceiver(intKeys[i]);
            receiver.setEnableLocalTran(false);
            receiver.setConn((Connection)conn);
            receiver.setSess((Session)sess);
            receiver.setConsumer(consumer);
            receiver.setLocalXAResource(this.localXAManager);
            receiver.setStatus(2);
            this.receivers.put(intKeys[i], receiver);
        }
        if (this.receivers.keySet().size() == 0) {
            this.isClosed = true;
            throw new JMSException("no connection available");
        }
        new Thread(this).start();
    }

    private void setInternalListener() throws JMSException {
        Set<Integer> keys = this.receivers.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ClusterReceiver receiver = this.receivers.get(ids[i]);
            receiver.setInternalListener(this.receiveQueue);
        }
    }

    private void setExternalListener(MessageListener listener) throws JMSException {
        Set<Integer> keys = this.receivers.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ClusterReceiver receiver = this.receivers.get(ids[i]);
            receiver.setListener(listener);
        }
    }

    private void resetListener() throws JMSException {
        Set<Integer> keys = this.receivers.keySet();
        Integer[] ids = new Integer[keys.size()];
        keys.toArray(ids);
        for (int i = 0; i < ids.length; ++i) {
            ClusterReceiver receiver = this.receivers.get(ids[i]);
            receiver.resetInternalListener();
        }
    }

    public boolean isBad() {
        return this.isClosed;
    }

    private void reconnect() throws JMSException {
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            int id = ids.get(i);
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(id);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            ClusterReceiver receiver = this.receivers.get(id);
            if (receiver == null) {
                QueueConnectionFactory qcf = null;
                Connection conn = null;
                Session sess = null;
                MessageConsumer consumer = null;
                boolean initOK = false;
                try {
                    qcf = new QueueConnectionFactory();
                    qcf.setProperty("tmqiAddressList", url);
                    ClusterUtils.setFactoryProperties(qcf, recordContainer.getFactoryRecord());
                    conn = qcf.createConnection();
                    sess = this.enableLocalTrans.booleanValue() ? conn.createSession(true, 0) : conn.createSession(false, this.clusterSession.getAcknowledgeMode());
                    consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                    initOK = true;
                }
                catch (JMSException e) {
                    if (sess != null) {
                        try {
                            sess.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initOK = false;
                }
                if (!initOK) continue;
                receiver = new ClusterReceiver(id);
                receiver.setEnableLocalTran(this.enableLocalTrans);
                receiver.setConn(conn);
                receiver.setSess(sess);
                receiver.setConsumer(consumer);
                receiver.setStatus(2);
                this.receivers.put(id, receiver);
                if (receiver.getInternalToggled().booleanValue()) {
                    receiver.setInternalListener(this.receiveQueue);
                    continue;
                }
                if (this.messageListener == null) continue;
                receiver.setListener(this.messageListener);
                continue;
            }
            int status = receiver.getStatus();
            if (status == 2 || status == 3 || status == 1 || status != 0) continue;
            QueueConnectionFactory qcf = null;
            Connection conn = null;
            Session sess = null;
            MessageConsumer consumer = null;
            boolean initOK = false;
            try {
                qcf = new QueueConnectionFactory();
                qcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(qcf, recordContainer.getFactoryRecord());
                conn = qcf.createConnection();
                sess = this.enableLocalTrans.booleanValue() ? conn.createSession(true, 0) : conn.createSession(false, this.clusterSession.getAcknowledgeMode());
                consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                initOK = true;
            }
            catch (JMSException e) {
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            receiver.setEnableLocalTran(this.enableLocalTrans);
            receiver.setConn(conn);
            receiver.setSess(sess);
            receiver.setConsumer(consumer);
            receiver.setStatus(2);
            if (receiver.getInternalToggled().booleanValue()) {
                receiver.setInternalListener(this.receiveQueue);
                continue;
            }
            if (this.messageListener == null) continue;
            receiver.setListener(this.messageListener);
        }
    }

    private void reconnectXA() throws JMSException {
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            int id = ids.get(i);
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(id);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            ClusterReceiver receiver = this.receivers.get(id);
            if (receiver == null) {
                XAQueueConnectionFactory xaqcf = null;
                XAConnection conn = null;
                XASession sess = null;
                XAResource xaResource = null;
                MessageConsumer consumer = null;
                boolean initOK = false;
                try {
                    xaqcf = new XAQueueConnectionFactory();
                    xaqcf.setProperty("tmqiAddressList", url);
                    ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                    conn = xaqcf.createXAConnection();
                    sess = conn.createXASession();
                    xaResource = sess.getXAResource();
                    this.clusterXAResource.addXAResource(xaResource);
                    consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                    initOK = true;
                }
                catch (JMSException e) {
                    if (xaResource != null) {
                        try {
                            this.clusterXAResource.removeXAResource(xaResource);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (sess != null) {
                        try {
                            sess.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initOK = false;
                }
                if (!initOK) continue;
                receiver = new ClusterReceiver(id);
                receiver.setEnableLocalTran(false);
                receiver.setConn((Connection)conn);
                receiver.setSess((Session)sess);
                receiver.setConsumer(consumer);
                receiver.setClusterXAResource(this.clusterXAResource);
                receiver.setStatus(2);
                this.receivers.put(id, receiver);
                if (receiver.getInternalToggled().booleanValue()) {
                    receiver.setInternalListener(this.receiveQueue);
                    continue;
                }
                if (this.messageListener == null) continue;
                receiver.setListener(this.messageListener);
                continue;
            }
            int status = receiver.getStatus();
            if (status == 2 || status == 3 || status == 1 || status != 0) continue;
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageConsumer consumer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.clusterXAResource.addXAResource(xaResource);
                consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.clusterXAResource.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            receiver.setEnableLocalTran(false);
            receiver.setConn((Connection)conn);
            receiver.setSess((Session)sess);
            receiver.setConsumer(consumer);
            receiver.setClusterXAResource(this.clusterXAResource);
            receiver.setStatus(2);
            if (receiver.getInternalToggled().booleanValue()) {
                receiver.setInternalListener(this.receiveQueue);
                continue;
            }
            if (this.messageListener == null) continue;
            receiver.setListener(this.messageListener);
        }
    }

    private void reconnectLocalXA() throws JMSException {
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            int id = ids.get(i);
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(id);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            ClusterReceiver receiver = this.receivers.get(id);
            if (receiver == null) {
                XAQueueConnectionFactory xaqcf = null;
                XAConnection conn = null;
                XASession sess = null;
                XAResource xaResource = null;
                MessageConsumer consumer = null;
                boolean initOK = false;
                try {
                    xaqcf = new XAQueueConnectionFactory();
                    xaqcf.setProperty("tmqiAddressList", url);
                    ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                    conn = xaqcf.createXAConnection();
                    sess = conn.createXASession();
                    xaResource = sess.getXAResource();
                    this.localXAManager.addXAResource(xaResource);
                    consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                    initOK = true;
                }
                catch (JMSException e) {
                    if (xaResource != null) {
                        try {
                            this.localXAManager.removeXAResource(xaResource);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (sess != null) {
                        try {
                            sess.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initOK = false;
                }
                if (!initOK) continue;
                receiver = new ClusterReceiver(id);
                receiver.setEnableLocalTran(false);
                receiver.setConn((Connection)conn);
                receiver.setSess((Session)sess);
                receiver.setConsumer(consumer);
                receiver.setLocalXAResource(this.localXAManager);
                receiver.setStatus(2);
                this.receivers.put(id, receiver);
                if (receiver.getInternalToggled().booleanValue()) {
                    receiver.setInternalListener(this.receiveQueue);
                    continue;
                }
                if (this.messageListener == null) continue;
                receiver.setListener(this.messageListener);
                continue;
            }
            int status = receiver.getStatus();
            if (status == 2 || status == 3 || status == 1 || status != 0) continue;
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageConsumer consumer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.localXAManager.addXAResource(xaResource);
                consumer = sess.createConsumer(this.destination, this.messageSelector, this.noLocal);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.localXAManager.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            receiver.setEnableLocalTran(false);
            receiver.setConn((Connection)conn);
            receiver.setSess((Session)sess);
            receiver.setConsumer(consumer);
            receiver.setLocalXAResource(this.localXAManager);
            receiver.setStatus(2);
            if (receiver.getInternalToggled().booleanValue()) {
                receiver.setInternalListener(this.receiveQueue);
                continue;
            }
            if (this.messageListener == null) continue;
            receiver.setListener(this.messageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        int i;
        Boolean bl = this.isClosed;
        synchronized (bl) {
            if (this.isClosed.booleanValue()) {
                return;
            }
            this.isClosed = true;
        }
        List<Integer> ids = this.recordIds.getCloned();
        for (i = 0; i < ids.size(); ++i) {
            ClusterReceiver receiver = this.receivers.get(ids.get(i));
            if (receiver == null) continue;
            receiver.close();
        }
        this.receivers.clear();
        for (i = 0; i < ids.size(); ++i) {
            try {
                if (this.receiveQueue.remainingCapacity() <= 0) continue;
                this.receiveQueue.offer(new Object(), 1L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public String getMessageSelector() throws JMSException {
        return this.messageSelector;
    }

    /*
     * Exception decompiling
     */
    public Message receive() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Message receiveNoWait() throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long paramLong) throws JMSException {
        Message message;
        block11: {
            message = null;
            Object obj = null;
            if (this.isClosed.booleanValue()) {
                throw new JMSException("ClusterMessageConsumer has been closed");
            }
            if (paramLong == 0L) {
                return this.receive();
            }
            if (paramLong < 0L) {
                throw new JMSException("timeout value " + paramLong + " is invalid");
            }
            try {
                Boolean bl = this.toggled;
                synchronized (bl) {
                    if (!this.toggled.booleanValue()) {
                        this.setInternalListener();
                        this.toggled = true;
                    }
                }
                obj = this.receiveQueue.poll(paramLong, TimeUnit.MILLISECONDS);
                if (obj instanceof ClusterMessage) {
                    ClusterMessage cmsg = obj;
                    message = cmsg.getMsg();
                    cmsg.alarm();
                    break block11;
                }
                if (obj instanceof Message) {
                    message = obj;
                    break block11;
                }
                return null;
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
        return message;
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener paramMessageListener) throws JMSException {
        Boolean bl = this.toggled;
        synchronized (bl) {
            if (this.toggled.booleanValue()) {
                this.toggled = false;
            }
        }
        this.setExternalListener(paramMessageListener);
        this.messageListener = paramMessageListener;
    }

    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public void run() {
        while (!this.isClosed.booleanValue()) {
            try {
                if (this.clusterSession.getTransacted()) {
                    this.reconnectLocalXA();
                } else if (this.clusterSession.isXATransaction()) {
                    this.reconnectXA();
                } else {
                    this.reconnect();
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            int interval = this.reconnectInterval;
            try {
                while (!this.isClosed.booleanValue()) {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                    if ((interval -= 3) > 0) continue;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

