/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.QueueConnectionFactory;
import com.tongtech.tmqi.XAQueueConnectionFactory;
import com.tongtech.tmqi.jmsclient.ClusterId;
import com.tongtech.tmqi.jmsclient.ClusterLocalXAResourceManager;
import com.tongtech.tmqi.jmsclient.ClusterSender;
import com.tongtech.tmqi.jmsclient.ClusterSenderStrategy;
import com.tongtech.tmqi.jmsclient.ClusterSessionImpl;
import com.tongtech.tmqi.jmsclient.ClusterUtils;
import com.tongtech.tmqi.jmsclient.ClusterXAResourceImpl;
import com.tongtech.tmqi.jmsclient.ConnectionRecordContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class ClusterMessageProducerImpl
implements MessageProducer,
Runnable {
    private ClusterSessionImpl clusterSession;
    private HashMap<Integer, ConnectionRecordContainer> connectionRecovery;
    private int activeNum = 0;
    private Boolean isClosed = false;
    private HashMap<Integer, ClusterSender> senders = new HashMap();
    private Destination destination;
    private ClusterId recordIds = new ClusterId();
    private int reconnectInterval = 30;
    private static final int SLEEP_INTERVAL = 3000;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    private ClusterXAResourceImpl clusterXAResource = null;
    private ClusterLocalXAResourceManager localXAManager = null;

    public ClusterMessageProducerImpl(ClusterSessionImpl clusterSession, Destination dest) throws JMSException {
        this.clusterSession = clusterSession;
        this.destination = dest;
        if (clusterSession.getTransacted()) {
            this.initLocalXA();
        } else if (clusterSession.isXATransaction()) {
            this.initXA();
        } else {
            this.init();
        }
    }

    private void init() throws JMSException {
        int i;
        this.connectionRecovery = this.clusterSession.getClusterConnection().getConnectionRecovery();
        Set<Integer> keys = this.connectionRecovery.keySet();
        this.activeNum = keys.size();
        Integer[] intKeys = new Integer[this.activeNum];
        keys.toArray(intKeys);
        for (i = 0; i < this.activeNum; ++i) {
            this.recordIds.add(intKeys[i]);
        }
        this.reconnectInterval = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getReconnectInterval();
        for (i = 0; i < this.activeNum; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(intKeys[i]);
            this.clusterSession.getProducers().add(this);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            QueueConnectionFactory qcf = null;
            Connection conn = null;
            Session sess = null;
            MessageProducer producer = null;
            boolean initOK = false;
            try {
                qcf = new QueueConnectionFactory();
                qcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(qcf, recordContainer.getFactoryRecord());
                conn = qcf.createConnection();
                sess = conn.createSession(false, this.clusterSession.getAcknowledgeMode());
                producer = sess.createProducer(null);
                initOK = true;
            }
            catch (JMSException e) {
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            ClusterSender sender = new ClusterSender(intKeys[i]);
            sender.setConn(conn);
            sender.setSess(sess);
            sender.setProducer(producer);
            sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
            sender.setCurWeight(0);
            sender.setStatus(2);
            this.senders.put(intKeys[i], sender);
        }
        if (this.senders.keySet().size() == 0) {
            this.isClosed = true;
            throw new JMSException("no connection available");
        }
        new Thread(this).start();
    }

    private void initXA() throws JMSException {
        int i;
        this.connectionRecovery = this.clusterSession.getClusterConnection().getConnectionRecovery();
        Set<Integer> keys = this.connectionRecovery.keySet();
        this.activeNum = keys.size();
        Integer[] intKeys = new Integer[this.activeNum];
        keys.toArray(intKeys);
        for (i = 0; i < this.activeNum; ++i) {
            this.recordIds.add(intKeys[i]);
        }
        this.reconnectInterval = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getReconnectInterval();
        this.clusterXAResource = (ClusterXAResourceImpl)this.clusterSession.getXAResource();
        for (i = 0; i < this.activeNum; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(intKeys[i]);
            this.clusterSession.getProducers().add(this);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageProducer producer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.clusterXAResource.addXAResource(xaResource);
                producer = sess.createProducer(null);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.clusterXAResource.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            ClusterSender sender = new ClusterSender(intKeys[i]);
            sender.setConn((Connection)conn);
            sender.setSess((Session)sess);
            sender.setProducer(producer);
            sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
            sender.setCurWeight(0);
            sender.setClusterXAResource(this.clusterXAResource);
            sender.setStatus(2);
            this.senders.put(intKeys[i], sender);
        }
        if (this.senders.keySet().size() == 0) {
            this.isClosed = true;
            throw new JMSException("no connection available");
        }
        new Thread(this).start();
    }

    private void initLocalXA() throws JMSException {
        int i;
        this.connectionRecovery = this.clusterSession.getClusterConnection().getConnectionRecovery();
        Set<Integer> keys = this.connectionRecovery.keySet();
        this.activeNum = keys.size();
        Integer[] intKeys = new Integer[this.activeNum];
        keys.toArray(intKeys);
        for (i = 0; i < this.activeNum; ++i) {
            this.recordIds.add(intKeys[i]);
        }
        this.reconnectInterval = this.connectionRecovery.get(intKeys[0]).getFactoryRecord().getReconnectInterval();
        this.localXAManager = this.clusterSession.getLocalXAResourceManager();
        for (i = 0; i < this.activeNum; ++i) {
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(intKeys[i]);
            this.clusterSession.getProducers().add(this);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageProducer producer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.localXAManager.addXAResource(xaResource);
                producer = sess.createProducer(null);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.localXAManager.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            ClusterSender sender = new ClusterSender(intKeys[i]);
            sender.setConn((Connection)conn);
            sender.setSess((Session)sess);
            sender.setProducer(producer);
            sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
            sender.setCurWeight(0);
            sender.setLocalXAResource(this.localXAManager);
            sender.setStatus(2);
            this.senders.put(intKeys[i], sender);
        }
        if (this.senders.keySet().size() == 0) {
            this.isClosed = true;
            throw new JMSException("no connection available");
        }
        new Thread(this).start();
    }

    private void reconnect() {
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            int id = ids.get(i);
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(id);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            ClusterSender sender = this.senders.get(id);
            if (sender == null) {
                QueueConnectionFactory qcf = null;
                Connection conn = null;
                Session sess = null;
                MessageProducer producer = null;
                boolean initOK = false;
                try {
                    qcf = new QueueConnectionFactory();
                    qcf.setProperty("tmqiAddressList", url);
                    ClusterUtils.setFactoryProperties(qcf, recordContainer.getFactoryRecord());
                    conn = qcf.createConnection();
                    sess = conn.createSession(false, this.clusterSession.getAcknowledgeMode());
                    producer = sess.createProducer(null);
                    initOK = true;
                }
                catch (JMSException e) {
                    if (sess != null) {
                        try {
                            sess.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initOK = false;
                }
                if (!initOK) continue;
                sender = new ClusterSender(id);
                sender.setConn(conn);
                sender.setSess(sess);
                sender.setProducer(producer);
                sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
                sender.setCurWeight(0);
                sender.setStatus(2);
                this.senders.put(id, sender);
                continue;
            }
            int status = sender.getStatus();
            if (status == 2 || status == 3 || status == 1 || status != 0) continue;
            QueueConnectionFactory qcf = null;
            Connection conn = null;
            Session sess = null;
            MessageProducer producer = null;
            boolean initOK = false;
            try {
                qcf = new QueueConnectionFactory();
                qcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(qcf, recordContainer.getFactoryRecord());
                conn = qcf.createConnection();
                sess = conn.createSession(false, this.clusterSession.getAcknowledgeMode());
                producer = sess.createProducer(null);
                initOK = true;
            }
            catch (JMSException e) {
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            sender.setConn(conn);
            sender.setSess(sess);
            sender.setProducer(producer);
            sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
            sender.setCurWeight(0);
            sender.setStatus(2);
        }
    }

    private void reconnectXA() {
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            int id = ids.get(i);
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(id);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            ClusterSender sender = this.senders.get(id);
            if (sender == null) {
                XAQueueConnectionFactory xaqcf = null;
                XAConnection conn = null;
                XASession sess = null;
                XAResource xaResource = null;
                MessageProducer producer = null;
                boolean initOK = false;
                try {
                    xaqcf = new XAQueueConnectionFactory();
                    xaqcf.setProperty("tmqiAddressList", url);
                    ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                    conn = xaqcf.createXAConnection();
                    sess = conn.createXASession();
                    xaResource = sess.getXAResource();
                    this.clusterXAResource.addXAResource(xaResource);
                    producer = sess.createProducer(null);
                    initOK = true;
                }
                catch (JMSException e) {
                    if (xaResource != null) {
                        try {
                            this.clusterXAResource.removeXAResource(xaResource);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (sess != null) {
                        try {
                            sess.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initOK = false;
                }
                if (!initOK) continue;
                sender = new ClusterSender(id);
                sender.setConn((Connection)conn);
                sender.setSess((Session)sess);
                sender.setProducer(producer);
                sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
                sender.setCurWeight(0);
                sender.setClusterXAResource(this.clusterXAResource);
                sender.setStatus(2);
                this.senders.put(id, sender);
                continue;
            }
            int status = sender.getStatus();
            if (status == 2 || status == 3 || status == 1 || status != 0) continue;
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageProducer producer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.clusterXAResource.addXAResource(xaResource);
                producer = sess.createProducer(null);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.clusterXAResource.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            sender.setConn((Connection)conn);
            sender.setSess((Session)sess);
            sender.setProducer(producer);
            sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
            sender.setCurWeight(0);
            sender.setClusterXAResource(this.clusterXAResource);
            sender.setStatus(2);
        }
    }

    private void reconnectLocalXA() {
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            int id = ids.get(i);
            ConnectionRecordContainer recordContainer = this.connectionRecovery.get(id);
            String url = recordContainer.getFactoryRecord().getRemoteAddress();
            ClusterSender sender = this.senders.get(id);
            if (sender == null) {
                XAQueueConnectionFactory xaqcf = null;
                XAConnection conn = null;
                XASession sess = null;
                XAResource xaResource = null;
                MessageProducer producer = null;
                boolean initOK = false;
                try {
                    xaqcf = new XAQueueConnectionFactory();
                    xaqcf.setProperty("tmqiAddressList", url);
                    ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                    conn = xaqcf.createXAConnection();
                    sess = conn.createXASession();
                    xaResource = sess.getXAResource();
                    this.localXAManager.addXAResource(xaResource);
                    producer = sess.createProducer(null);
                    initOK = true;
                }
                catch (JMSException e) {
                    if (xaResource != null) {
                        try {
                            this.localXAManager.removeXAResource(xaResource);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (sess != null) {
                        try {
                            sess.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    initOK = false;
                }
                if (!initOK) continue;
                sender = new ClusterSender(id);
                sender.setConn((Connection)conn);
                sender.setSess((Session)sess);
                sender.setProducer(producer);
                sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
                sender.setCurWeight(0);
                sender.setLocalXAResource(this.localXAManager);
                sender.setStatus(2);
                this.senders.put(id, sender);
                continue;
            }
            int status = sender.getStatus();
            if (status == 2 || status == 3 || status == 1 || status != 0) continue;
            XAQueueConnectionFactory xaqcf = null;
            XAConnection conn = null;
            XASession sess = null;
            XAResource xaResource = null;
            MessageProducer producer = null;
            boolean initOK = false;
            try {
                xaqcf = new XAQueueConnectionFactory();
                xaqcf.setProperty("tmqiAddressList", url);
                ClusterUtils.setFactoryProperties(xaqcf, recordContainer.getFactoryRecord());
                conn = xaqcf.createXAConnection();
                sess = conn.createXASession();
                xaResource = sess.getXAResource();
                this.localXAManager.addXAResource(xaResource);
                producer = sess.createProducer(null);
                initOK = true;
            }
            catch (JMSException e) {
                if (xaResource != null) {
                    try {
                        this.localXAManager.removeXAResource(xaResource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                initOK = false;
            }
            if (!initOK) continue;
            sender.setConn((Connection)conn);
            sender.setSess((Session)sess);
            sender.setProducer(producer);
            sender.setWeight(recordContainer.getFactoryRecord().getSendMessageWeight());
            sender.setCurWeight(0);
            sender.setLocalXAResource(this.localXAManager);
            sender.setStatus(2);
        }
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Boolean bl = this.isClosed;
        synchronized (bl) {
            if (this.isClosed.booleanValue()) {
                return;
            }
            this.isClosed = true;
        }
        List<Integer> ids = this.recordIds.getCloned();
        for (int i = 0; i < ids.size(); ++i) {
            ClusterSender sender = this.senders.get(ids.get(i));
            if (sender == null) continue;
            sender.close();
        }
    }

    public boolean getDisableMessageID() throws JMSException {
        return false;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return false;
    }

    public void setDeliveryMode(int paramInt) throws JMSException {
        int id = this.recordIds.getAvaiableId();
        this.senders.get(id).setDeliveryMode(paramInt);
        this.deliveryMode = paramInt;
    }

    public void setPriority(int paramInt) throws JMSException {
        int id = this.recordIds.getAvaiableId();
        this.senders.get(id).setPriority(paramInt);
        this.priority = paramInt;
    }

    public void setTimeToLive(long paramLong) throws JMSException {
        int id = this.recordIds.getAvaiableId();
        this.senders.get(id).setTimeToLive(paramLong);
        this.timeToLive = paramLong;
    }

    public void setDisableMessageID(boolean paramBoolean) throws JMSException {
    }

    public void setDisableMessageTimestamp(boolean paramBoolean) throws JMSException {
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public void send(Message paramMessage) throws JMSException {
        this.send(this.destination, paramMessage, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message paramMessage, int paramInt1, int paramInt2, long paramLong) throws JMSException {
        this.send(this.destination, paramMessage, paramInt1, paramInt2, paramLong);
    }

    public void send(Destination paramDestination, Message paramMessage) throws JMSException {
        this.send(paramDestination, paramMessage, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination paramDestination, Message paramMessage, int paramInt1, int paramInt2, long paramLong) throws JMSException {
        boolean retryFlag = true;
        int retryNum = 0;
        while (retryFlag) {
            if (this.isClosed.booleanValue()) {
                throw new JMSException("ClusterMessageProducer has been closed");
            }
            if (retryNum > 0 && ClusterSenderStrategy.getAvailableClusterSenderNum(this.recordIds, this.senders) <= 0) {
                throw new JMSException("no available message sender");
            }
            ClusterSender sender = null;
            for (int i = 0; i < 2 && (sender = ClusterSenderStrategy.getAvailableClusterSender(this.recordIds, this.senders)) == null; ++i) {
            }
            if (sender == null) {
                throw new JMSException("no available message sender");
            }
            try {
                sender.getProducer().send(paramDestination, paramMessage, paramInt1, paramInt2, paramLong);
                retryFlag = false;
                break;
            }
            catch (JMSException e) {
                sender.close();
                ++retryNum;
            }
        }
    }

    public boolean isBad() {
        return this.isClosed;
    }

    @Override
    public void run() {
        while (!this.isClosed.booleanValue()) {
            try {
                if (this.clusterSession.getTransacted()) {
                    this.reconnectLocalXA();
                } else if (this.clusterSession.isXATransaction()) {
                    this.reconnectXA();
                } else {
                    this.reconnect();
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            int interval = this.reconnectInterval;
            try {
                while (!this.isClosed.booleanValue()) {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                    if ((interval -= 3) > 0) continue;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

