/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ClusterId;
import com.tongtech.tmqi.jmsclient.ClusterReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;

public class ClusterReceiverStrategy {
    public static int getAvailableClusterReceiverNum(ClusterId ids, HashMap<Integer, ClusterReceiver> receivers) {
        int availableNum = 0;
        List<Integer> usedIds = ids.getCloned();
        for (int i = 0; i < usedIds.size(); ++i) {
            int id = usedIds.get(i);
            ClusterReceiver receiver = receivers.get(id);
            if (receiver == null || receiver.getStatus() != 2) continue;
            ++availableNum;
        }
        return availableNum;
    }

    public static ClusterReceiver getAvailableClusterReceiver(ClusterId ids, HashMap<Integer, ClusterReceiver> receivers) throws JMSException {
        List<Integer> usedIds = ids.getCloned();
        int maxNum = usedIds.size();
        ArrayList<Integer> markedIds = new ArrayList<Integer>();
        while (markedIds.size() < maxNum) {
            for (int i = 0; i < usedIds.size(); ++i) {
                int id = usedIds.get(i);
                ClusterReceiver receiver = receivers.get(id);
                if (receiver == null) {
                    markedIds.add(usedIds.get(i));
                    continue;
                }
                if (receiver.getStatus() != 2) {
                    markedIds.add(usedIds.get(i));
                    continue;
                }
                if (receiver.getCurWeight() >= receiver.getWeight()) {
                    markedIds.add(usedIds.get(i));
                    receiver.resetCurWeight();
                    ids.moveLast(id);
                    continue;
                }
                receiver.incrCurWeight();
                if (receiver.getCurWeight() >= receiver.getWeight()) {
                    receiver.resetCurWeight();
                    ids.moveLast(id);
                }
                return receiver;
            }
            usedIds.removeAll(markedIds);
        }
        return null;
    }
}

