/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ClusterId;
import com.tongtech.tmqi.jmsclient.ClusterSender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jms.JMSException;

public class ClusterSenderStrategy {
    private static List<Integer> cloneList(List<Integer> ids) {
        ArrayList<Integer> cloneIds = new ArrayList<Integer>();
        for (int i = 0; i < ids.size(); ++i) {
            cloneIds.add(ids.get(i));
        }
        return cloneIds;
    }

    public static int getAvailableClusterSenderNum(ClusterId ids, HashMap<Integer, ClusterSender> senders) {
        int availableNum = 0;
        List<Integer> usedIds = ids.getCloned();
        for (int i = 0; i < usedIds.size(); ++i) {
            int id = usedIds.get(i);
            ClusterSender sender = senders.get(id);
            if (sender == null || sender.getStatus() != 2) continue;
            ++availableNum;
        }
        return availableNum;
    }

    public static ClusterSender getAvailableClusterSender(ClusterId ids, HashMap<Integer, ClusterSender> senders) throws JMSException {
        List<Integer> usedIds = ids.getCloned();
        int maxNum = usedIds.size();
        ArrayList<Integer> markedIds = new ArrayList<Integer>();
        while (markedIds.size() < maxNum) {
            for (int i = 0; i < usedIds.size(); ++i) {
                int id = usedIds.get(i);
                ClusterSender sender = senders.get(id);
                if (sender == null) {
                    markedIds.add(usedIds.get(i));
                    continue;
                }
                if (sender.getStatus() != 2) {
                    markedIds.add(usedIds.get(i));
                    continue;
                }
                if (sender.getCurWeight() >= sender.getWeight()) {
                    markedIds.add(usedIds.get(i));
                    sender.resetCurWeight();
                    ids.moveLast(id);
                    continue;
                }
                sender.incrCurWeight();
                if (sender.getCurWeight() >= sender.getWeight()) {
                    sender.resetCurWeight();
                    ids.moveLast(id);
                }
                return sender;
            }
            usedIds.removeAll(markedIds);
        }
        return null;
    }
}

