/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.ClusterConnectionImpl;
import com.tongtech.tmqi.jmsclient.ClusterLocalXAResourceManager;
import com.tongtech.tmqi.jmsclient.ClusterMessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.ClusterMessageProducerImpl;
import com.tongtech.tmqi.jmsclient.ClusterQueueImpl;
import com.tongtech.tmqi.jmsclient.ClusterXAResourceImpl;
import com.tongtech.tmqi.jmsclient.MapMessageImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.ObjectMessageImpl;
import com.tongtech.tmqi.jmsclient.StreamMessageImpl;
import com.tongtech.tmqi.jmsclient.TextMessageImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class ClusterSessionImpl
implements Session,
Runnable,
XASession {
    private ClusterConnectionImpl clusterConnection;
    private List<ClusterMessageProducerImpl> producers = new ArrayList<ClusterMessageProducerImpl>();
    private List<ClusterMessageConsumerImpl> consumers = new ArrayList<ClusterMessageConsumerImpl>();
    private int sessionId;
    private boolean isClosed = false;
    private static final int SLEEP_INTERVAL = 3000;
    private int acknowledgeMode = 1;
    private boolean localTransactionFlag = false;
    private boolean xaTransactionFlag = false;
    private ClusterXAResourceImpl xaResource;
    private ClusterLocalXAResourceManager localXAManager;

    public ClusterSessionImpl(ClusterConnectionImpl clusterConnection, int sessionId) {
        this.clusterConnection = clusterConnection;
        this.sessionId = sessionId;
    }

    public ClusterSessionImpl(ClusterConnectionImpl clusterConnection, int sessionId, boolean localTransacted, boolean xaTransacted) throws JMSException {
        this.clusterConnection = clusterConnection;
        this.sessionId = sessionId;
        this.localTransactionFlag = localTransacted;
        if (this.localTransactionFlag) {
            try {
                this.localXAManager = new ClusterLocalXAResourceManager();
            }
            catch (Exception e) {
                throw new JMSException(e.getMessage());
            }
        }
        this.xaTransactionFlag = xaTransacted;
        if (this.xaTransactionFlag) {
            this.xaResource = new ClusterXAResourceImpl();
        }
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    public ClusterConnectionImpl getClusterConnection() {
        return this.clusterConnection;
    }

    public void setClusterConnection(ClusterConnectionImpl clusterConnection) {
        this.clusterConnection = clusterConnection;
    }

    public List<ClusterMessageProducerImpl> getProducers() {
        return this.producers;
    }

    public void setProducers(List<ClusterMessageProducerImpl> producers) {
        this.producers = producers;
    }

    public List<ClusterMessageConsumerImpl> getConsumers() {
        return this.consumers;
    }

    public void setConsumers(List<ClusterMessageConsumerImpl> consumers) {
        this.consumers = consumers;
    }

    public boolean isBad() {
        return this.isClosed;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.acknowledgeMode;
    }

    protected void setAcknowledgeMode(int acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void close() throws JMSException {
        int j;
        this.isClosed = true;
        for (j = 0; j < this.producers.size(); ++j) {
            this.producers.get(j).close();
        }
        this.producers.clear();
        for (j = 0; j < this.consumers.size(); ++j) {
            this.consumers.get(j).close();
        }
        this.consumers.clear();
    }

    public void commit() throws JMSException {
        if (this.xaTransactionFlag) {
            throw new TransactionInProgressException("commit not supported by non-XA session");
        }
        if (this.localTransactionFlag) {
            this.localXAManager.commit();
        }
    }

    public void recover() throws JMSException {
        throw new JMSException("recover not supported");
    }

    public void rollback() throws JMSException {
        if (this.xaTransactionFlag) {
            throw new TransactionInProgressException("rollback not supported by non-XA session");
        }
        if (this.localTransactionFlag) {
            this.localXAManager.rollback();
        }
    }

    @Override
    public void run() {
        while (!this.isClosed) {
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (ClusterMessageProducerImpl producer : this.producers) {
                if (!producer.isBad()) continue;
                this.producers.remove(producer);
            }
            for (ClusterMessageConsumerImpl consumer : this.consumers) {
                if (!consumer.isBad()) continue;
                this.consumers.remove(consumer);
            }
        }
    }

    public boolean getTransacted() throws JMSException {
        return this.localTransactionFlag;
    }

    public void unsubscribe(String paramString) throws JMSException {
        throw new JMSException("unsubscribe not supported");
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return new BytesMessageImpl(true, 2);
    }

    public MapMessage createMapMessage() throws JMSException {
        return new MapMessageImpl(2);
    }

    public Message createMessage() throws JMSException {
        MessageImpl message = new MessageImpl(2);
        return message;
    }

    public MessageListener getMessageListener() throws JMSException {
        return null;
    }

    public void setMessageListener(MessageListener paramMessageListener) throws JMSException {
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return new ObjectMessageImpl(2);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return new StreamMessageImpl(true, 2);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return null;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return null;
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessageImpl msg = new TextMessageImpl(2);
        return msg;
    }

    public MessageConsumer createConsumer(Destination paramDestination) throws JMSException {
        return new ClusterMessageConsumerImpl(this, paramDestination, null, false);
    }

    public MessageProducer createProducer(Destination paramDestination) throws JMSException {
        return new ClusterMessageProducerImpl(this, paramDestination);
    }

    public ObjectMessage createObjectMessage(Serializable paramSerializable) throws JMSException {
        ObjectMessageImpl objectMessage = new ObjectMessageImpl(2);
        objectMessage.setObject(paramSerializable);
        return objectMessage;
    }

    public Queue createQueue(String paramString) throws JMSException {
        return new ClusterQueueImpl(paramString);
    }

    public QueueBrowser createBrowser(Queue paramQueue) throws JMSException {
        return null;
    }

    public TextMessage createTextMessage(String paramString) throws JMSException {
        TextMessageImpl message = new TextMessageImpl(2);
        message.setText(paramString);
        return message;
    }

    public Topic createTopic(String paramString) throws JMSException {
        return null;
    }

    public MessageConsumer createConsumer(Destination paramDestination, String paramString) throws JMSException {
        return new ClusterMessageConsumerImpl(this, paramDestination, paramString, false);
    }

    public MessageConsumer createConsumer(Destination paramDestination, String paramString, boolean paramBoolean) throws JMSException {
        return new ClusterMessageConsumerImpl(this, paramDestination, paramString, paramBoolean);
    }

    public QueueBrowser createBrowser(Queue paramQueue, String paramString) throws JMSException {
        return null;
    }

    public TopicSubscriber createDurableSubscriber(Topic paramTopic, String paramString) throws JMSException {
        return null;
    }

    public TopicSubscriber createDurableSubscriber(Topic paramTopic, String paramString1, String paramString2, boolean paramBoolean) throws JMSException {
        return null;
    }

    public Session getSession() throws JMSException {
        return this;
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }

    public boolean isXATransaction() {
        return this.xaTransactionFlag;
    }

    public ClusterLocalXAResourceManager getLocalXAResourceManager() {
        return this.localXAManager;
    }
}

