/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.FlowControlEntry;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import java.io.PrintStream;
import java.util.Hashtable;

class ConnectionFlowControlEntry
extends FlowControlEntry {
    Logger logger = LoggerFactory.getLogger(ConnectionFlowControlEntry.class);
    protected boolean enableFlowControlCheck;
    protected int inQueueCounter = 0;
    protected int TEST_peakCount = 0;
    protected int TEST_pauseCount = 0;
    protected int TEST_resumeCount = 0;
    protected int flowControlChunkSize;
    protected int flowControlWaterMark;
    protected boolean resumeRequested = false;

    public ConnectionFlowControlEntry(FlowControl fc, ProtocolHandler protocolHandler, boolean enableFlowControlCheck, int flowControlChunkSize, int flowControlWaterMark) {
        super(fc, protocolHandler);
        this.enableFlowControlCheck = enableFlowControlCheck;
        this.flowControlChunkSize = flowControlChunkSize;
        this.flowControlWaterMark = flowControlWaterMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived() {
        ConnectionFlowControlEntry connectionFlowControlEntry = this;
        synchronized (connectionFlowControlEntry) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("ConnectionmessageReceived {}", this.inQueueCounter);
            }
            ++this.inQueueCounter;
            if (this.inQueueCounter > this.TEST_peakCount) {
                this.TEST_peakCount = this.inQueueCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageDelivered() {
        ConnectionFlowControlEntry connectionFlowControlEntry = this;
        synchronized (connectionFlowControlEntry) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("ConnectionmessageDelivered {}", this.inQueueCounter);
            }
            --this.inQueueCounter;
            if (this.enableFlowControlCheck) {
                this.checkAndResumeFlow();
            }
        }
    }

    @Override
    public void resetFlowControl(int reduceFlowCount) {
        this.inQueueCounter -= reduceFlowCount;
        if (this.inQueueCounter < 0) {
            this.inQueueCounter = 0;
        }
        if (this.enableFlowControlCheck) {
            this.checkAndResumeFlow();
        }
    }

    @Override
    public synchronized void setResumeRequested(boolean resumeRequested) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("setResumeRequsted-{} : {}", this, (Object)new Boolean(resumeRequested));
        }
        this.resumeRequested = resumeRequested;
        if (resumeRequested) {
            ++this.TEST_pauseCount;
            this.checkAndResumeFlow();
        }
    }

    @Override
    protected synchronized void sendResumeFlow() throws Exception {
        this.setResumeRequested(false);
        this.protocolHandler.resumeFlow(this.flowControlChunkSize);
        this.fc.removeFromReadyQueue(this);
        ++this.TEST_resumeCount;
    }

    private synchronized void checkAndResumeFlow() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ConnectionFlowControlEntry.checkAndResumeFlow {} {} {}", new Object[]{new Boolean(this.enableFlowControlCheck), new Integer(this.inQueueCounter), new Integer(this.flowControlWaterMark)});
        }
        if (this.resumeRequested && (!this.enableFlowControlCheck || this.inQueueCounter < this.flowControlWaterMark)) {
            this.fc.addToReadyQueue(this);
        }
    }

    @Override
    protected Hashtable getDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("enableFlowControlCheck", String.valueOf(this.enableFlowControlCheck));
        ht.put("inQueueCounter", String.valueOf(this.inQueueCounter));
        ht.put("peakCount", String.valueOf(this.TEST_peakCount));
        ht.put("isFlowPaused", String.valueOf(this.resumeRequested));
        ht.put("pauseCount", String.valueOf(this.TEST_pauseCount));
        ht.put("resumeCount", String.valueOf(this.TEST_resumeCount));
        return ht;
    }

    @Override
    protected Object TEST_GetAttribute(String name) {
        if (name.equals("FlowControl.Count")) {
            return new Integer(this.inQueueCounter);
        }
        if (name.equals("FlowControl.PeakCount")) {
            return new Integer(this.TEST_peakCount);
        }
        if (name.equals("FlowControl.IsFlowPaused")) {
            return this.resumeRequested;
        }
        if (name.equals("FlowControl.PauseCount")) {
            return new Integer(this.TEST_pauseCount);
        }
        return null;
    }

    @Override
    protected void status_report(PrintStream dbg) {
        dbg.println("FlowControlState for Connection : " + this.fc.connection);
        dbg.println("\t# pending messages : " + this.inQueueCounter);
        dbg.println("\t# resumeRequested : " + this.resumeRequested);
        dbg.println("\t# flowControlWaterMark : " + this.flowControlWaterMark);
    }

    public String toString() {
        return "ConnectionFlowControlEntry[" + this.fc.connection + "]";
    }
}

