/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.IllegalStateException;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.TemporaryDestination;
import java.io.PrintStream;
import java.util.Hashtable;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public abstract class Consumer {
    protected String messageSelector = null;
    protected ConnectionImpl connection = null;
    protected Long interestId = null;
    protected Integer destType = null;
    protected boolean durable = false;
    protected boolean noLocal = false;
    protected javax.jms.Destination destination = null;
    protected String durableName = null;
    private boolean isRegistered = false;
    protected boolean isClosed = false;
    protected int prefetchMaxMsgCount = 100;
    protected int prefetchThresholdPercent = 50;
    public int acknowledgeMode = -1;

    public Consumer(ConnectionImpl connection, javax.jms.Destination dest, String messageSelector, boolean noLocal) throws JMSException {
        if (dest == null) {
            String errorString = AdministeredObject.cr.getKString("C4050", "null");
            InvalidDestinationException jmse = new InvalidDestinationException(errorString, "C4050");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        this.messageSelector = messageSelector;
        this.connection = connection;
        this.destination = dest;
        this.noLocal = noLocal;
        this.checkConsumerCreation();
        this.prefetchMaxMsgCount = connection.prefetchMaxMsgCount;
        this.prefetchThresholdPercent = connection.prefetchThresholdPercent;
    }

    public Consumer(ConnectionImpl connection, javax.jms.Destination dest, String messageSelector) throws JMSException {
        this(connection, dest, messageSelector, false);
    }

    public Consumer(ConnectionImpl connection, javax.jms.Destination dest) throws JMSException {
        this(connection, dest, null, false);
    }

    protected void registerInterest() throws JMSException {
        this.connection.addInterest(this);
        this.isRegistered = true;
    }

    protected void deregisterInterest() throws JMSException {
        this.connection.removeInterest(this);
        FlowControl fc = this.connection.flowControl;
        fc.removeConsumerFlowControl(this);
        this.isRegistered = false;
    }

    protected void checkConsumerCreation() throws JMSException {
        TemporaryDestination.checkTemporaryDestinationConsumerAllowed(this.connection, this.destination);
    }

    protected abstract void onMessage(MessageImpl var1) throws JMSException;

    public abstract Long getReadQueueId();

    public Long getInterestId() {
        return this.interestId;
    }

    public void setInterestId(Long id) {
        this.interestId = id;
    }

    protected Integer getDestType() {
        return this.destType;
    }

    public void setDestType(Integer destType) {
        this.destType = destType;
    }

    protected boolean getIsRegistered() {
        return this.isRegistered;
    }

    protected void setDurable(boolean flag) {
        this.durable = flag;
    }

    public boolean getDurable() {
        return this.durable;
    }

    protected void setNoLocal(boolean flag) {
        this.noLocal = flag;
    }

    public boolean getNoLocal() throws JMSException {
        return this.noLocal;
    }

    protected void setMessageSelector(String selector) throws JMSException {
        this.messageSelector = selector;
    }

    public javax.jms.Destination getDestination() {
        return this.destination;
    }

    protected void setDurableName(String name) {
        this.durableName = name;
    }

    public String getDurableName() {
        return this.durableName;
    }

    protected ConnectionImpl getConnection() {
        return this.connection;
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this.messageSelector;
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4063");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4063");
            ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
        }
    }

    public void setPrefetchMaxMsgCount(int prefetchMaxMsgCount) {
        this.prefetchMaxMsgCount = prefetchMaxMsgCount;
    }

    public int getPrefetchMaxMsgCount() {
        return this.prefetchMaxMsgCount;
    }

    public void setPrefetchThresholdPercent(int prefetchThresholdPercent) {
        this.prefetchThresholdPercent = prefetchThresholdPercent;
    }

    public int getPrefetchThresholdPercent() {
        return this.prefetchThresholdPercent;
    }

    public abstract SessionImpl getSession() throws JMSException;

    protected void dump(PrintStream ps) {
    }

    protected Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("consumerID", String.valueOf(this.interestId));
        ht.put("noLocal", String.valueOf(this.noLocal));
        ht.put("Destination Class", this.destination.getClass().getName());
        if (this.destination instanceof Destination) {
            ht.put("Destination", ((Destination)this.destination).getName());
        }
        if (this.messageSelector != null) {
            ht.put("selector", String.valueOf(this.messageSelector));
        }
        ht.put("durable", String.valueOf(this.durable));
        if (this.durable) {
            ht.put("durableName", String.valueOf(this.durableName));
        }
        ht.put("isRegistered", String.valueOf(this.isRegistered));
        ht.put("isClosed", String.valueOf(this.isClosed));
        ht.put("FlowControl", this.connection.flowControl.getDebugState(this));
        return ht;
    }

    public String toString() {
        return "ConsumerID: " + this.interestId + ", ConnectionID=" + this.connection.getConnectionID();
    }
}

