/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.FlowControl;
import com.tongtech.tmqi.jmsclient.FlowControlEntry;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import java.io.PrintStream;
import java.util.Hashtable;

class ConsumerFlowControlEntry
extends FlowControlEntry {
    Logger logger = LoggerFactory.getLogger(ConsumerFlowControlEntry.class);
    protected Consumer consumer;
    protected int maxMsgCount;
    protected int thresholdCount;
    protected boolean resumeRequested = false;
    protected int inQueueCounter = 0;
    protected int TEST_peakCount = 0;
    protected int TEST_pauseCount = 0;
    protected int TEST_resumeCount = 0;
    protected int TEST_minResumeCount = Integer.MAX_VALUE;
    protected int TEST_lastResumeCount = -1;
    private static boolean sendResumeOnRecover = true;

    public ConsumerFlowControlEntry(FlowControl fc, ProtocolHandler protocolHandler, Consumer consumer) {
        super(fc, protocolHandler);
        this.consumer = consumer;
        int prefetchMaxMsgCount = consumer.getPrefetchMaxMsgCount();
        int prefetchThresholdPercent = consumer.getPrefetchThresholdPercent();
        this.maxMsgCount = prefetchMaxMsgCount;
        if (prefetchThresholdPercent < 0) {
            prefetchThresholdPercent = 0;
        }
        if (prefetchThresholdPercent > 100) {
            prefetchThresholdPercent = 100;
        }
        this.thresholdCount = (int)((double)((float)this.maxMsgCount * (float)prefetchThresholdPercent) / 100.0);
        if (this.thresholdCount >= this.maxMsgCount) {
            this.thresholdCount = this.maxMsgCount - 1;
        }
    }

    @Override
    public synchronized void messageReceived() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ConsumerMessageReceived {}", this.inQueueCounter);
        }
        ++this.inQueueCounter;
        if (this.inQueueCounter > this.TEST_peakCount) {
            this.TEST_peakCount = this.inQueueCounter;
        }
    }

    @Override
    public synchronized void messageDelivered() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("consumerMessageDelivered {}", this.inQueueCounter);
        }
        --this.inQueueCounter;
        this.checkAndResumeFlow();
    }

    @Override
    public synchronized void resetFlowControl(int count) {
        this.inQueueCounter = 0;
        if (sendResumeOnRecover) {
            this.checkAndResumeFlow();
        }
    }

    @Override
    public synchronized void setResumeRequested(boolean resumeRequested) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("setResumeRequsted[{}] :{} ", this, (Object)new Boolean(resumeRequested));
        }
        this.resumeRequested = resumeRequested;
        if (resumeRequested) {
            ++this.TEST_pauseCount;
            this.checkAndResumeFlow();
        }
    }

    @Override
    protected synchronized void sendResumeFlow() throws Exception {
        int count = -1;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ConsumerFlowControlEntry.sendResumeFlow maxMsgCount:{}  inQueueCounter:{}", new Integer(this.maxMsgCount), (Object)new Integer(this.inQueueCounter));
        }
        if (this.maxMsgCount > 0) {
            count = this.maxMsgCount - this.inQueueCounter;
        }
        this.setResumeRequested(false);
        this.protocolHandler.resumeConsumerFlow(this.consumer, count);
        this.fc.removeFromReadyQueue(this);
        if (count < this.TEST_minResumeCount) {
            this.TEST_minResumeCount = count;
        }
        this.TEST_lastResumeCount = count;
        ++this.TEST_resumeCount;
    }

    private void checkAndResumeFlow() {
        Object[] obj = new Object[]{this, new Boolean(this.resumeRequested), new Integer(this.maxMsgCount), new Integer(this.inQueueCounter), new Integer(this.thresholdCount)};
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("In ConsumerFlowControlEntry.checkAndResumeFlow : {}\n\tresumeRequested = {}, maxMsgCount = {}, inQueueCounter = {}, thresholdCount = {}", obj);
        }
        if (this.resumeRequested) {
            if (this.maxMsgCount <= 0 || this.inQueueCounter <= this.thresholdCount) {
                this.fc.addToReadyQueue(this);
            } else {
                this.logger.warn("not send jms_continue, inQueueCounter:{}, thresholdCount:{}", new Integer(this.inQueueCounter), (Object)new Integer(this.thresholdCount));
            }
        }
    }

    @Override
    protected Hashtable getDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("maxMsgCount", String.valueOf(this.maxMsgCount));
        ht.put("thresholdCount", String.valueOf(this.thresholdCount));
        ht.put("inQueueCounter", String.valueOf(this.inQueueCounter));
        ht.put("peakCount", String.valueOf(this.TEST_peakCount));
        ht.put("isFlowPaused", String.valueOf(this.resumeRequested));
        ht.put("pauseCount", String.valueOf(this.TEST_pauseCount));
        ht.put("resumeCount", String.valueOf(this.TEST_resumeCount));
        ht.put("lastResumeCount", String.valueOf(this.TEST_minResumeCount));
        ht.put("minResumeCount", this.TEST_lastResumeCount == -1 ? "---" : Integer.toString(this.TEST_lastResumeCount));
        return ht;
    }

    @Override
    protected Object TEST_GetAttribute(String name) {
        if (name.equals("FlowControl.Count")) {
            return new Integer(this.inQueueCounter);
        }
        if (name.equals("FlowControl.PeakCount")) {
            return new Integer(this.TEST_peakCount);
        }
        if (name.equals("FlowControl.IsFlowPaused")) {
            return this.resumeRequested;
        }
        if (name.equals("FlowControl.PauseCount")) {
            return new Integer(this.TEST_pauseCount);
        }
        if (name.equals("FlowControl.MinResumeCount")) {
            return new Integer(this.TEST_minResumeCount);
        }
        return null;
    }

    public String toString() {
        return "ConsumerFlowControlEntry[" + this.consumer + "]";
    }

    @Override
    protected void status_report(PrintStream dbg) {
        dbg.println("FlowControlState for : " + this);
        dbg.println("\t# pending messages : " + this.inQueueCounter);
        dbg.println("\t# resumeRequested : " + this.resumeRequested);
        dbg.println("\t# threshodCount : " + this.thresholdCount);
        dbg.println("\t# lastResumeCount : " + (this.TEST_lastResumeCount == -1 ? "---" : Integer.toString(this.TEST_lastResumeCount)));
    }

    static {
        if (System.getProperty("tmqi.resume_on_recover") != null) {
            sendResumeOnRecover = Boolean.getBoolean("tmqi.resume_on_recover");
        }
    }
}

