/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.FileMessage;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import java.io.PrintStream;
import javax.jms.JMSException;

public class FileMessageImpl
extends MessageImpl
implements FileMessage {
    private String file = null;
    private boolean renameFlag = false;

    public FileMessageImpl(int protocolType) throws JMSException {
        super(protocolType);
        this.setPacketType(7);
    }

    public FileMessageImpl(String file, int protocolType) throws JMSException {
        super(protocolType);
        this.file = file;
        this.setPacketType(7);
    }

    @Override
    public void setMessageBodyToPacket() throws JMSException {
        if (this.file == null) {
            return;
        }
        try {
            this.setMessageBody(this.file.getBytes("UTF8"));
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4014");
        }
    }

    @Override
    public void getMessageBodyFromPacket() throws JMSException {
        try {
            byte[] body = this.getMessageBody();
            if (body != null) {
                this.file = new String(body, "UTF8");
            }
            this.renameFlag = this.getBooleanProperty("JMS_TONG_RENAME_FLAG");
            this.properties.remove("JMS_TONG_RENAME_FLAG");
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4015");
        }
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public void setFile(String file) throws JMSException {
        this.checkMessageAccess();
        this.file = file;
    }

    @Override
    public boolean isRenamed() {
        return this.renameFlag;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("\nFile:\t").append(this.file).append(super.toString()).toString();
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

