/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.tmqi.io.MQAddress;
import java.net.MalformedURLException;
import java.util.Random;
import java.util.StringTokenizer;

public class MQAddressList
extends com.tongtech.tmqi.io.MQAddressList {
    public static final int PRIORITY = 1;
    public static final int RANDOM = 2;
    private int behavior;

    @Override
    protected MQAddress createMQAddress(String s) throws MalformedURLException {
        MQAddress mqAddress = InjectorUtil.createMQAddress();
        mqAddress.initialize(s);
        return mqAddress;
    }

    public static MQAddressList createMQAddressList(String addrs) throws MalformedURLException {
        MQAddressList alist = new MQAddressList();
        StringTokenizer st = new StringTokenizer(addrs, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            alist.add(alist.createMQAddress(s));
        }
        return alist;
    }

    public int getBehavior() {
        return this.behavior;
    }

    public void setBehavior(int behavior) {
        this.behavior = behavior;
        if (behavior == 2) {
            Random r = new Random();
            int max = this.size();
            for (int i = 0; i < max; ++i) {
                int pos = i + r.nextInt(max - i);
                Object o = this.get(i);
                this.set(i, this.get(pos));
                this.set(pos, o);
            }
        }
    }

    @Override
    public String toString() {
        String ret = "";
        for (int i = 0; i < this.size(); ++i) {
            ret = ret + "addr[" + i + "] :\t" + this.get(i) + "\n";
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        InjectorUtil.init();
        MQAddressList list = MQAddressList.createMQAddressList(args[0]);
        if (System.getProperty("test.random") != null) {
            list.setBehavior(2);
        }
        System.out.println(list);
    }
}

