/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

public class QueueBrowserImpl
implements QueueBrowser {
    private SessionImpl session = null;
    private Queue queue = null;
    private String messageSelector = null;
    private Vector consumers = new Vector();
    private boolean isClosed = false;

    public QueueBrowserImpl(SessionImpl session, Queue queue) throws JMSException {
        this(session, queue, null);
    }

    public QueueBrowserImpl(SessionImpl session, Queue queue, String selector) throws JMSException {
        if (queue == null) {
            String errorString = AdministeredObject.cr.getKString("C4050", "null");
            throw new InvalidDestinationException(errorString, "C4050");
        }
        this.session = session;
        this.queue = queue;
        this.messageSelector = selector;
        this.init();
    }

    private void init() throws JMSException {
        this.session.checkBrowserCreation();
        this.session.verifyDestination((Destination)this.queue, this.messageSelector, true);
    }

    public Queue getQueue() throws JMSException {
        this.checkState();
        return this.queue;
    }

    public String getMessageSelector() throws JMSException {
        this.checkState();
        return this.messageSelector;
    }

    public Enumeration getEnumeration() throws JMSException {
        this.checkState();
        return InjectorUtil.createBrowserConsumer(this.getSession().getConnection().getProtocolType(), this, this.queue, this.messageSelector);
    }

    protected void addBrowserConsumer(BrowserConsumer consumer) {
        this.consumers.addElement(consumer);
    }

    protected void removeBrowserConsumer(BrowserConsumer consumer) {
        this.consumers.removeElement(consumer);
    }

    public void close() throws JMSException {
        BrowserConsumer consumer = null;
        for (int i = this.consumers.size() - 1; i >= 0; --i) {
            consumer = (BrowserConsumer)this.consumers.elementAt(i);
            consumer.close();
        }
        this.isClosed = true;
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected void checkState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4046");
            throw new IllegalStateException(errorString, "C4046");
        }
        this.session.checkSessionState();
    }
}

