/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.QueueBrowserImpl;
import com.tongtech.tmqi.jmsclient.ReceiveQueue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class RemoteBrowserConsumer
extends BrowserConsumer {
    static Logger logger = LoggerFactory.getLogger(RemoteBrowserConsumer.class);
    private List messageIDList;

    public RemoteBrowserConsumer(QueueBrowserImpl browser, Destination dest, String messageSelector) throws JMSException {
        super(browser, dest, messageSelector);
    }

    @Override
    protected void init() throws JMSException {
        this.receiveQueue = new ReceiveQueue();
        this.messageIDs = this.session.getMessageIdSet(this);
        this.cursorEnd = this.messageIDs.length - 1;
        this.cursor = 0;
        this.addInterest();
        this.waitCounter = 0;
        this.messageIDList = new ArrayList();
        for (int i = 0; i < this.messageIDs.length; ++i) {
            this.messageIDList.add(this.messageIDs[i]);
        }
        this.requestMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasMoreElements() {
        if (this.receiveQueue.getIsClosed()) {
            String errorString = AdministeredObject.cr.getKString("C4046");
            throw new NoSuchElementException(errorString);
        }
        RemoteBrowserConsumer errorString = this;
        synchronized (errorString) {
            if (this.receiveQueue.size() > 0) {
                return true;
            }
        }
        try {
            return this.requestMessage();
        }
        catch (JMSException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean requestMessage() throws JMSException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(36);
        DataOutputStream dos = new DataOutputStream(bos);
        boolean moreComming = false;
        SysMessageID messageID = null;
        int listSize = this.messageIDList.size();
        int j = 0;
        while (!moreComming && j < listSize) {
            int count;
            ArrayList<SysMessageID> removeList = null;
            removeList = new ArrayList<SysMessageID>();
            for (count = 0; j < listSize && count < this.browseChunkLimit; ++count, ++j) {
                messageID = (SysMessageID)this.messageIDList.get(j);
                removeList.add(messageID);
                try {
                    messageID.writeID(dos);
                }
                catch (IOException e) {
                    ExceptionHandler.handleException((Exception)e, "C4038");
                }
                ++this.cursor;
            }
            if (count > 0) {
                try {
                    dos.flush();
                    bos.flush();
                }
                catch (IOException e) {
                    ExceptionHandler.handleException((Exception)e, "C4038");
                }
                moreComming = this.session.requestMessages(bos, this);
                bos.reset();
                if (removeList != null && removeList.size() != 0) {
                    this.messageIDList.removeAll(removeList);
                }
            }
            if (!moreComming) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nextElement() {
        Message message = null;
        RemoteBrowserConsumer remoteBrowserConsumer = this;
        synchronized (remoteBrowserConsumer) {
            if (!this.hasMoreElements()) {
                String errorString = AdministeredObject.cr.getKString("C4045");
                throw new NoSuchElementException(errorString);
            }
            try {
                message = this.receive(this.browseTimeout);
            }
            catch (JMSException e) {
                this.close();
                throw new NoSuchElementException(e.getMessage());
            }
        }
        if (message == null) {
            String errorString;
            if (this.receiveQueue.getIsClosed()) {
                errorString = AdministeredObject.cr.getKString("C4046");
                throw new NoSuchElementException(errorString);
            }
            this.close();
            errorString = AdministeredObject.cr.getKString("C4044");
            throw new NoSuchElementException(errorString);
        }
        return message;
    }
}

