/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.SSMessage;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsspi.ServerSession;
import java.io.PrintStream;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

class ServerSessionRunner {
    static Logger logger = LoggerFactory.getLogger(ServerSessionRunner.class);
    private final int SERVERSESSION_RUN = 0;
    private final int SERVERSESSION_STOP = 1;
    private final int SERVERSESSION_CLOSE = 2;
    private final int SERVERSESSION_RESET = 3;
    private SessionImpl session;
    private Vector serverSessionMessageQ = new Vector();
    private Object serverSessionSyncObj = new Object();
    private int serverSessionInProcess = 0;
    private Thread serverSessionThread = null;
    private boolean serverSessionInWait = false;
    private int serverSessionState = 0;
    private MessageListener messageListener = null;
    protected MessageImpl currentMessage = null;

    public ServerSessionRunner(SessionImpl session, MessageListener listener) {
        this.session = session;
        this.messageListener = listener;
    }

    protected MessageListener getMessageListener() throws JMSException {
        return this.messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessageListener(MessageListener listener) throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.serverSessionInProcess > 0) {
                String errorString = AdministeredObject.cr.getKString("C4048");
                throw new IllegalStateException(errorString, "C4048");
            }
            this.messageListener = listener;
        }
    }

    protected void run() {
        this.serverSessionProcessStart();
        this.currentMessage = null;
        int size = this.serverSessionMessageQ.size();
        this.serverSessionProcess(size);
        for (int i = 0; i < size; ++i) {
            try {
                MessageImpl message;
                this.checkState();
                this.serverSessionPreOnMessage();
                if (this.serverSessionState == 2) {
                    this.serverSessionProcess(i - size);
                    break;
                }
                SSMessage ssm = (SSMessage)this.serverSessionMessageQ.elementAt(0);
                this.currentMessage = message = ssm.message;
                if (ssm.serversession instanceof ServerSession) {
                    ((ServerSession)ssm.serversession).beforeMessageDelivery(message);
                }
                try {
                    boolean delivered = this.onMessage(message);
                    this.currentMessage = null;
                    this.serverSessionMessageQ.removeElementAt(0);
                    if (delivered) {
                        this.session.acknowledge(message);
                    }
                }
                catch (JMSException e) {
                    this.session.isRollbackOnly = true;
                    this.session.rollbackCause = e;
                    throw new RuntimeException(e.getMessage());
                }
                finally {
                    if (ssm.serversession instanceof ServerSession) {
                        ((ServerSession)ssm.serversession).afterMessageDelivery(message);
                    }
                }
            }
            catch (Throwable e) {
                this.session.isRollbackOnly = true;
                this.session.rollbackCause = e;
                this.serverSessionProcess(i - size);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage());
            }
            this.serverSessionProcess(-1);
        }
    }

    private boolean onMessage(Message message) throws JMSException {
        boolean delivered = true;
        try {
            this.messageListener.onMessage(message);
        }
        catch (RuntimeException e1) {
            logger.warn("", e1);
            delivered = false;
        }
        return delivered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionProcessStart() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.serverSessionInProcess > 0) {
                String errorString = AdministeredObject.cr.getKString("C4048");
                throw new java.lang.IllegalStateException(errorString);
            }
            this.serverSessionInProcess = 1;
            this.serverSessionThread = Thread.currentThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionProcess(int size) {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (size < 0) {
                this.serverSessionInProcess += size;
            } else {
                this.serverSessionInProcess = size;
                if (this.messageListener == null) {
                    this.serverSessionInProcess = 0;
                }
            }
            if (this.serverSessionInProcess <= 0) {
                this.serverSessionInProcess = 0;
                this.serverSessionThread = null;
                this.currentMessage = null;
                this.serverSessionSyncObj.notifyAll();
            }
            if (this.messageListener == null) {
                String errorString = AdministeredObject.cr.getKString("C4029");
                throw new java.lang.IllegalStateException(errorString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverSessionPreOnMessage() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            while (this.serverSessionState == 1) {
                try {
                    this.serverSessionInWait = true;
                    this.serverSessionSyncObj.notifyAll();
                    this.serverSessionSyncObj.wait();
                }
                catch (InterruptedException e) {
                    String errorString = AdministeredObject.cr.getKString("C4047");
                    throw new RuntimeException(errorString);
                }
                finally {
                    this.serverSessionInWait = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSessionRun() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionState = 0;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void serverSessionStop() throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.messageListener == null) {
                this.serverSessionState = 1;
                return;
            }
            if (this.serverSessionThread != Thread.currentThread()) {
                this.serverSessionState = 1;
                try {
                    while (this.serverSessionInProcess > 0 && !this.serverSessionInWait && this.serverSessionState == 1) {
                        this.serverSessionSyncObj.wait();
                    }
                }
                catch (InterruptedException e) {
                    if (this.serverSessionInProcess <= 0 || this.serverSessionInWait || this.serverSessionState != 1) return;
                    ExceptionHandler.handleException((Exception)e, "C4047");
                }
            } else {
                String errorString = AdministeredObject.cr.getKString("C4048");
                throw new IllegalStateException(errorString, "C4048");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverSessionClose() throws JMSException {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            if (this.messageListener == null) {
                this.serverSessionState = 2;
                return;
            }
            this.serverSessionStop();
            this.serverSessionState = 2;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    protected void loadMessage(MessageImpl message, javax.jms.ServerSession ss) {
        if (this.isReset()) {
            this.clear();
        }
        this.serverSessionMessageQ.addElement(new SSMessage(message, ss));
    }

    protected Thread getCurrentThread() {
        return this.serverSessionThread;
    }

    protected void dump(PrintStream ps) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionMessageQ.clear();
            if (this.serverSessionState == 3) {
                this.serverSessionState = this.SERVERSESSION_RUN;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = this.serverSessionSyncObj;
        synchronized (object) {
            this.serverSessionState = 3;
            this.serverSessionSyncObj.notifyAll();
        }
    }

    private void checkState() {
        if (this.isReset()) {
            throw new RuntimeException("Fail-over occurred, server session must be reset.");
        }
    }

    protected boolean isReset() {
        return this.serverSessionState == 3;
    }
}

