/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.FileMessage;
import com.tongtech.jms.ra.ManagedConnectionIF;
import com.tongtech.jms.util.InjectorUtil;
import com.tongtech.log.JDKLogger;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.io.PacketType;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.io.SysMessageID;
import com.tongtech.tmqi.jmsclient.BrowserConsumer;
import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.FileMessageImpl;
import com.tongtech.tmqi.jmsclient.MapMessageImpl;
import com.tongtech.tmqi.jmsclient.MessageConsumerImpl;
import com.tongtech.tmqi.jmsclient.MessageIDWriter;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.MessageProducerImpl;
import com.tongtech.tmqi.jmsclient.ObjectMessageImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.ReceiveQueue;
import com.tongtech.tmqi.jmsclient.RemoteAcknowledgeException;
import com.tongtech.tmqi.jmsclient.ServerSessionRunner;
import com.tongtech.tmqi.jmsclient.SessionQueue;
import com.tongtech.tmqi.jmsclient.SessionReader;
import com.tongtech.tmqi.jmsclient.StreamMessageImpl;
import com.tongtech.tmqi.jmsclient.TextMessageImpl;
import com.tongtech.tmqi.jmsclient.TlqSessionIdGen;
import com.tongtech.tmqi.jmsclient.Traceable;
import com.tongtech.tmqi.jmsclient.Transaction;
import com.tongtech.tmqi.jmsclient.UnifiedReadChannel;
import com.tongtech.tmqi.jmsclient.WriteChannel;
import com.tongtech.tmqi.jmsclient.XAResourceForRA;
import com.tongtech.tmqi.util.TupleInput;
import com.tongtech.tmqi.util.TupleOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.ServerSession;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionRolledBackException;

public class SessionImpl
implements Traceable {
    static Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private ServerSessionRunner serverSessionRunner = null;
    protected ConnectionImpl connection = null;
    public boolean isTransacted = false;
    public int acknowledgeMode = 1;
    protected SessionReader sessionReader = null;
    protected SessionQueue sessionQueue = null;
    protected UnifiedReadChannel readChannel = null;
    protected Hashtable consumers = new Hashtable();
    protected Vector producers = new Vector();
    protected WriteChannel writeChannel = null;
    protected Long sessionId = null;
    protected ProtocolHandler protocolHandler = null;
    public Transaction transaction = null;
    protected boolean failoverOccurred = false;
    protected int dupsOkLimit = 10;
    protected boolean isAckLimited = false;
    protected int ackLimit = 100;
    protected int ackCounter = 0;
    protected Vector unAckedMessageQueue = new Vector();
    protected boolean isClosed = false;
    protected boolean isStopped = false;
    protected boolean isXAClosed = false;
    protected boolean isXAInRC = false;
    protected boolean protectMode = false;
    protected Hashtable browserConsumers = new Hashtable();
    ReadWritePacket ackPkt = null;
    TupleOutput dos = new TupleOutput();
    protected boolean setJMSXConsumerTXID = false;
    private Object syncObject = new Object();
    private boolean inSyncState = false;
    private Object sessionSyncObj = new Object();
    protected boolean xaTxnMode = false;
    private Object raEndpointSyncObj = new Object();
    private ManagedConnectionIF mc = null;
    private boolean isDedicatedToServerSession = false;
    private long brokerSessionID = -1L;
    private int TEST_ackCount = 0;
    private int TEST_rxCount = 0;
    protected boolean dupsOkAckOnEmptyQueue = false;
    protected boolean dupsOkAckOnLimit = false;
    protected boolean dupsOkAckOnTimeout = false;
    protected long dupsOkAckTimeout = 0L;
    protected long dupsOkTimestamp = 0L;
    protected Object dupsOkSyncObj = new Object();
    protected boolean allowExtensions = false;
    private volatile boolean inResetState = false;
    public static final String SESSION_LOGGER_NAME = "javax.jms.session";
    protected static final JDKLogger sessionLogger = JDKLogger.getLogger("javax.jms.session", "com.tongtech.tmqi.jmsclient.resources.ClientResources");
    protected volatile boolean remore_broker_failed = false;
    protected volatile boolean isRollbackOnly = false;
    protected Throwable rollbackCause = null;
    public MessageIDWriter writer = null;

    protected SessionImpl() {
        this.ackPkt = InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        this.writer = InjectorUtil.createMessageIDWriter(this.connection.getProtocolType());
    }

    public SessionImpl(ConnectionImpl connection) throws JMSException {
        this(connection, false, 1, false, null);
    }

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int acknowledgeMode) throws JMSException {
        this(connection, isTransacted, acknowledgeMode, false, null);
    }

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int acknowledgeMode, ManagedConnectionIF mc) throws JMSException {
        this(connection, isTransacted, acknowledgeMode, false, mc);
    }

    public SessionImpl(ConnectionImpl connection, int acknowledgeMode) throws JMSException {
        this(connection, false, acknowledgeMode, true, null);
    }

    public SessionImpl(ConnectionImpl connection, boolean isTransacted, int acknowledgeMode, boolean allowJMSExtension, ManagedConnectionIF mc) throws JMSException {
        try {
            this.ackPkt = InjectorUtil.createReadWritePacket(connection.getProtocolType());
            this.writer = InjectorUtil.createMessageIDWriter(connection.getProtocolType());
            this.sessionQueue = new SessionQueue();
            this.sessionQueue.validateQueue();
            this.allowExtensions = allowJMSExtension;
            this.connection = connection;
            if (!isTransacted) {
                if (acknowledgeMode == 0) {
                    acknowledgeMode = 1;
                }
                this.checkAckMode(acknowledgeMode);
            }
            this.writeChannel = connection.getWriteChannel();
            this.readChannel = connection.readChannel;
            this.protocolHandler = connection.getProtocolHandler();
            this.isTransacted = isTransacted;
            this.acknowledgeMode = acknowledgeMode;
            this.sessionId = connection.getNextSessionId();
            if (mc != null) {
                this.mc = mc;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("SessionImpl, before init");
            }
            this.init();
            this.logLifeCycle("I200");
        }
        catch (JMSException jmse) {
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void checkAckMode(int ackMode) throws JMSException {
        if (ackMode != 1 && ackMode != 2 && ackMode != 3) {
            if (this.allowExtensions && ackMode == 32768) {
                if (this.connection.getBrokerProtocolLevel() <= 350) {
                    String errorString = AdministeredObject.cr.getKString("C4092", this.connection.getBrokerVersion());
                    com.tongtech.jms.JMSException jmse = new com.tongtech.jms.JMSException(errorString, "C4092");
                    ExceptionHandler.throwJMSException(jmse);
                }
                return;
            }
            String ackModeStr = String.valueOf(ackMode);
            String errorString = AdministeredObject.cr.getKString("C4067", ackModeStr);
            JMSException jmse = new JMSException(errorString, "C4067");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void init() throws JMSException {
        this.serverSessionRunner = new ServerSessionRunner(this, null);
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("isTransacted {}, mc {}", new Boolean(this.isTransacted), (Object)this.mc);
        }
        if (this.isTransacted) {
            if (this.mc == null) {
                this.transaction = new Transaction(this, true);
            } else {
                this.transaction = new Transaction(this, false);
                if (this.mc.xaTransactionStarted()) {
                    this.transaction.setTransactionID(this.mc.getTransactionID());
                    this.xaTxnMode = true;
                }
            }
        }
        if (this.connection.getIsStopped()) {
            this.sessionQueue.setIsLocked(true);
        }
        this.connection.addToReadQTable(this.sessionId, this.sessionQueue);
        this.connection.addSession(this);
        this.dupsOkLimit = this.connection.getDupsOkLimit();
        this.isAckLimited = this.connection.getIsAckLimited();
        this.ackLimit = this.connection.getAckLimit();
        this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID && this.isTransacted;
        this.protectMode = this.connection.getProtectMode();
        this.isDedicatedToServerSession = this.connection.getIsDedicatedToConnectionConsumer();
        this.dupsOkInit();
        this.sessionReader = new SessionReader(this);
        if (this.isDedicatedToServerSession) {
            this.sessionReader.close();
        } else {
            this.sessionReader.start();
        }
    }

    protected void dupsOkInit() {
        if (!this.isTransacted && this.acknowledgeMode == 3) {
            if (this.isDedicatedToServerSession) {
                this.dupsOkAckOnEmptyQueue = true;
            } else {
                this.dupsOkAckOnEmptyQueue = this.connection.dupsOkAckOnEmptyQueue;
                if (!this.dupsOkAckOnEmptyQueue) {
                    this.dupsOkAckTimeout = this.connection.dupsOkAckTimeout;
                    if (this.dupsOkAckTimeout > 0L) {
                        this.dupsOkAckOnTimeout = true;
                    } else {
                        this.dupsOkAckOnLimit = true;
                        this.dupsOkAckTimeout = 0L;
                    }
                }
            }
        }
        if (this.dupsOkAckOnTimeout || this.dupsOkAckOnEmptyQueue || this.dupsOkAckOnLimit) {
            if (logger.isTraceEnabled()) {
                logger.trace("*** dupsOkAckOnEmptyQueue: " + this.dupsOkAckOnEmptyQueue);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("*** dupsOkAckOnTimeout: " + this.dupsOkAckOnTimeout);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("*** dupsOkAckTimeout: " + this.dupsOkAckTimeout);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("*** dupsOkAckOnLimit: " + this.dupsOkAckOnLimit);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("*** Session ackMode:  " + this.acknowledgeMode);
        }
    }

    protected void switchOnXATransaction() throws JMSException {
        if (this.xaTxnMode) {
            return;
        }
        if (this.isTransacted) {
            this.setInSyncState();
            try {
                this.receiveRollback();
                this.transaction.rollbackToXA();
            }
            finally {
                this.releaseInSyncState();
            }
        }
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
            this.isTransacted = true;
            this.setJMSXConsumerTXID = this.connection.connectionMetaData.setJMSXConsumerTXID;
        }
        this.xaTxnMode = true;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    protected void switchOffXATransaction() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    public void addMessageConsumer(MessageConsumerImpl consumer) throws JMSException {
        this.consumers.put(consumer.interestId, consumer);
    }

    protected void checkBrowserCreation() throws JMSException {
        if (this.isDedicatedToServerSession) {
            this.checkConsumerCreation();
        }
    }

    protected void checkConsumerCreation() throws JMSException {
        if (this.isDedicatedToServerSession || this.serverSessionRunner.getMessageListener() != null) {
            String errorString = AdministeredObject.cr.getKString("C4031");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4031");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    public void removeMessageConsumer(MessageConsumerImpl consumer) {
        this.consumers.remove(consumer.interestId);
    }

    protected MessageConsumerImpl getMessageConsumer(Object key) {
        return (MessageConsumerImpl)this.consumers.get(key);
    }

    public Hashtable getAllMessageConsumer() {
        return this.consumers;
    }

    public void addBrowserConsumer(BrowserConsumer consumer) {
        consumer.getBrowser().addBrowserConsumer(consumer);
        this.browserConsumers.put(consumer.interestId, consumer);
    }

    public void removeBrowserConsumer(BrowserConsumer consumer) {
        this.browserConsumers.remove(consumer.interestId);
        consumer.getBrowser().removeBrowserConsumer(consumer);
    }

    protected BrowserConsumer getBrowserConsumer(Object key) {
        return (BrowserConsumer)this.browserConsumers.get(key);
    }

    protected void addMessageProducer(MessageProducerImpl producer) {
        this.producers.add(producer);
    }

    protected void removeMessageProducer(MessageProducerImpl producer) {
        this.producers.remove(producer);
    }

    protected void verifyDestination(javax.jms.Destination destination, String selector, boolean browser) throws JMSException {
        this.protocolHandler.verifyDestination(destination, selector, browser);
    }

    protected SysMessageID[] getMessageIdSet(Consumer consumer) throws JMSException {
        return this.protocolHandler.browse(consumer);
    }

    protected boolean requestMessages(ByteArrayOutputStream bos, BrowserConsumer consumer) throws JMSException {
        return this.protocolHandler.deliver(bos, consumer);
    }

    protected ProtocolHandler getProtocolHandler() {
        return this.connection.getProtocolHandler();
    }

    protected Long getSessionId() {
        return this.sessionId;
    }

    public ConnectionImpl getConnection() {
        return this.connection;
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4059");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4059");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        if (this.isTransacted) {
            this.checkFailOver();
            this.transaction.send(message);
        } else {
            this.writeChannel.writeJMSMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _stopFromRA() throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.stop(false);
        }
    }

    public void _closeFromRA() throws JMSException {
        if (this.isTransacted) {
            if (this.xaTxnMode) {
                this.receiveCommit();
            } else if (!this.connection.isBroken() && !this.connection.recoverInProcess) {
                this.transaction.releaseBrokerResource();
            }
        }
    }

    protected void stop() throws JMSException {
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(boolean doWait) throws JMSException {
        if (this.isStopped || this.isClosed) {
            return;
        }
        this.checkPermission();
        Object object = this.sessionSyncObj;
        synchronized (object) {
            this.sessionQueue.stop(doWait);
            this.serverSessionRunner.serverSessionStop();
            MessageConsumerImpl[] consumerArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < consumerArray.length; ++i) {
                if (doWait) {
                    consumerArray[i].stop();
                    continue;
                }
                consumerArray[i].stopNoWait();
            }
            this.isStopped = true;
        }
    }

    protected void reset() throws JMSException {
        try {
            this.sessionQueue.clear();
            MessageConsumerImpl consumer = null;
            Enumeration enum2 = this.consumers.elements();
            while (enum2.hasMoreElements()) {
                consumer = (MessageConsumerImpl)enum2.nextElement();
                consumer.receiveQueue.clear();
            }
            if (this.unAckedMessageQueue != null) {
                this.unAckedMessageQueue.removeAllElements();
            }
            this.consumers.clear();
            this.remore_broker_failed = false;
            if (this.serverSessionRunner != null) {
                this.serverSessionRunner.reset();
            }
        }
        finally {
            this.sessionQueue.start();
            this.isStopped = false;
        }
    }

    protected void recreateSession() throws JMSException {
        if (this.connection.getBrokerProtocolLevel() >= 350) {
            this.protocolHandler.createSession(this);
        }
        if (this.isTransacted && !this.connection.isConnectedToHABroker) {
            this.transaction = new Transaction(this, true);
        }
        this.failoverOccurred = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws JMSException {
        Object object = this.sessionSyncObj;
        synchronized (object) {
            this.sessionQueue.start();
            this.serverSessionRunner.serverSessionRun();
            MessageConsumerImpl[] consumerArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
            for (int i = 0; i < consumerArray.length; ++i) {
                consumerArray[i].start();
            }
            this.isStopped = false;
        }
    }

    protected void checkPermission() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread || Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            String errorString = AdministeredObject.cr.getKString("C4049");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4049");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeUndeliverableFromRAEndpoint(MessageImpl message, XAResourceForRA xar, boolean sendToDMQ) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.readChannel.getFlowControl().messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(new Long(message.getInterestID()));
            this.readChannel.getFlowControl().messageDelivered(consumer);
            ++this.TEST_rxCount;
            try {
                this.setInSyncState();
                if (xar != null && xar.started()) {
                    XAResourceForRA xAResourceForRA = xar;
                    synchronized (xAResourceForRA) {
                        this.ackPkt.setTransactionID(xar.getTransactionID());
                    }
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(message);
                this.doAcknowledgeUndeliverable(true, sendToDMQ);
            }
            finally {
                this.releaseInSyncState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl message, XAResourceForRA xar) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            if (sessionLogger.isLoggable(Level.FINER)) {
                this.logMessageDelivered(message);
            }
            this.readChannel.getFlowControl().messageDelivered();
            Consumer consumer = (Consumer)this.consumers.get(new Long(message.getInterestID()));
            this.readChannel.getFlowControl().messageDelivered(consumer);
            ++this.TEST_rxCount;
            try {
                this.setInSyncState();
                if (xar != null && xar.started()) {
                    XAResourceForRA xAResourceForRA = xar;
                    synchronized (xAResourceForRA) {
                        this.ackPkt.setTransactionID(xar.getTransactionID());
                    }
                } else {
                    this.ackPkt.setTransactionID(0L);
                }
                this.writeMessageID(message);
                this.doAcknowledge(true);
            }
            finally {
                this.releaseInSyncState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeFromRAEndpoint(MessageImpl message) throws JMSException {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.acknowledge(message);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void acknowledge(MessageImpl message) throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("start call session.acknowledge.");
        }
        this.readChannel.getFlowControl().messageDelivered();
        Consumer consumer = (Consumer)this.consumers.get(new Long(message.getInterestID()));
        if (consumer == null) {
            consumer = this.connection.interestTable.getConsumer(new Long(message.getInterestID()));
        }
        this.readChannel.getFlowControl().messageDelivered(consumer);
        ++this.TEST_rxCount;
        try {
            this.setInSyncState();
            if (this.isTransacted) {
                if (logger.isDebugEnabled()) {
                    logger.debug("before transactedAcknowledge");
                }
                this.transactedAcknowledge(message);
                return;
            }
            switch (this.acknowledgeMode) {
                case 1: {
                    this.autoAcknowledge(message);
                    return;
                }
                case 2: {
                    this.prepareClientAcknowledge(message);
                    return;
                }
                case 3: {
                    if (this.dupsOkAckOnTimeout) {
                        this.syncedDupsOkAcknowledge(message);
                        return;
                    } else {
                        this.dupsOkAcknowledge(message);
                        return;
                    }
                }
                case 32768: {
                    return;
                }
                default: {
                    this.autoAcknowledge(message);
                    return;
                }
            }
        }
        catch (JMSException jmse) {
            if (this.isTransacted || this.acknowledgeMode != 1 && this.acknowledgeMode != 3 || !this.isRemoteException(jmse)) throw jmse;
            this.recreateConsumers();
            ExceptionHandler.throwRemoteAcknowledgeException(jmse, "C4107");
            throw jmse;
        }
        finally {
            this.releaseInSyncState();
        }
    }

    protected void logMessageDelivered(MessageImpl message) {
        try {
            if (sessionLogger.isLoggable(Level.FINER)) {
                Destination mqDest = (Destination)message.getJMSDestination();
                String domain = mqDest.isQueue() ? "Queue" : "Topic";
                String pktType = PacketType.getString(message.getPacket().getPacketType());
                String param = "MQTrace=MessageConsumer, ThreadID=" + Thread.currentThread().getName() + ", ClientID=" + this.connection.getClientID() + ", ConnectionID=" + this.connection.getConnectionID() + ", SessionID=" + this.getBrokerSessionID() + ", ConsumerID=" + message.getInterestID() + ", Destination=" + mqDest.getName() + ", Domain=" + domain + ", MessageID=" + message.getJMSMessageID() + ", MessageType=" + pktType;
                sessionLogger.log(Level.FINER, "I302", param);
                if (sessionLogger.isLoggable(Level.FINEST)) {
                    param = "MQTrace=MessageConsumer, ConsumerID=" + message.getInterestID() + ", Message=" + message.toString();
                    sessionLogger.log(Level.FINEST, "I302", param);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void autoAcknowledge(MessageImpl message) throws JMSException {
        this.writeMessageID(message);
        this.doAcknowledge(true);
    }

    protected void transactedAcknowledge(MessageImpl message) throws JMSException {
        try {
            boolean isAddedToList = this.prepareTransactedAcknowledge(message);
            if (logger.isDebugEnabled()) {
                logger.debug("isAddedToList={}", new Boolean(isAddedToList));
            }
            if (isAddedToList) {
                if (logger.isDebugEnabled()) {
                    logger.debug("ackPkt.setTransactionID={} ackpkt={}", new Long(this.transaction.getTransactionID()), (Object)this.ackPkt);
                }
                this.ackPkt.setTransactionID(this.transaction.getTransactionID());
                this.writeMessageID(message);
                this.doAcknowledge(true);
            }
        }
        catch (JMSException jmse) {
            if (jmse instanceof RemoteAcknowledgeException) {
                this.remore_broker_failed = true;
            }
            throw jmse;
        }
    }

    protected void writeMessageID(MessageImpl message) throws JMSException {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("interestID={}, msgID={}", new Long(message.getInterestID()), (Object)message.getFixedMessageID());
            }
            this.writer.writeID(this.dos, message);
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    protected void writeMessageID(UnAckedMessage message) throws JMSException {
        try {
            this.writer.writeID(this.dos, message);
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    protected void writeMessageID(ReadOnlyPacket pkt) throws JMSException {
        try {
            this.writer.writeID(this.dos, pkt);
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4038");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAcknowledgeUndeliverable(boolean requireAckFromBroker, boolean sendToDMQ) throws JMSException {
        try {
            this.dos.flush();
            this.ackPkt.setMessageBody(this.dos.toByteArray());
            this.ackPkt.setSendAcknowledge(requireAckFromBroker);
            this.protocolHandler.acknowledgeUndeliverable(this.ackPkt, sendToDMQ);
            ++this.TEST_ackCount;
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4016");
        }
        finally {
            this.dos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
    }

    protected void doAcknowledge(boolean requireAckFromBroker) throws JMSException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("sessionImple doAcknowledge");
            }
            this.dos.flush();
            this.ackPkt.setMessageBody(this.dos.toByteArray());
            this.ackPkt.setSendAcknowledge(requireAckFromBroker);
            this.checkFailOver();
            if (logger.isDebugEnabled()) {
                logger.debug("before protocolHandler ");
            }
            this.protocolHandler.acknowledge(this.ackPkt);
            ++this.TEST_ackCount;
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4016");
        }
        finally {
            this.dos.reset();
            this.ackCounter = 0;
            this.dupsOkTimestamp = 0L;
        }
    }

    protected void dupsOkAcknowledge(MessageImpl message) throws JMSException {
        this.addMessageToAckList(message);
        if (this.dupsOkShouldAcknowledge()) {
            this.dupsOkCommitAcknowledge();
        }
    }

    protected void dupsOkCommitAcknowledge() throws JMSException {
        if (logger.isTraceEnabled()) {
            logger.trace("***** dups ok committing ack .... size: " + this.ackCounter);
        }
        this.dequeueUnAckedMessages();
        this.doAcknowledge(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkAcknowledge(MessageImpl message) throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter == 0) {
                this.dupsOkTimestamp = System.currentTimeMillis();
            }
            this.dupsOkAcknowledge(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncedDupsOkCommitAcknowledge() throws JMSException {
        Object object = this.dupsOkSyncObj;
        synchronized (object) {
            if (this.ackCounter > 0) {
                this.dupsOkCommitAcknowledge();
            }
        }
    }

    protected boolean dupsOkShouldAcknowledge() {
        if (this.dupsOkAckOnTimeout) {
            boolean timeToAck = System.currentTimeMillis() - this.dupsOkTimestamp >= this.dupsOkAckTimeout;
            return this.ackCounter == this.dupsOkLimit || timeToAck;
        }
        if (this.dupsOkAckOnEmptyQueue) {
            return this.ackCounter == this.dupsOkLimit || this.sessionQueue.isEmpty();
        }
        return this.ackCounter == this.dupsOkLimit;
    }

    protected boolean addMessageToAckList(MessageImpl message) throws JMSException {
        boolean isAddedToList = false;
        logger.debug("msgid = {}, getIsOnAckList()={}", (Object)message.getJMSMessageID(), (Object)new Boolean(message.getIsOnAckList()));
        if (message != null && !message.getIsOnAckList()) {
            message.setIsOnAckList(true);
            UnAckedMessage unacked = new UnAckedMessage(message);
            this.unAckedMessageQueue.addElement(unacked);
            ++this.ackCounter;
            isAddedToList = true;
        }
        return isAddedToList;
    }

    protected void removeMessageFromAckList(UnAckedMessage unacked) {
        this.unAckedMessageQueue.removeElement(unacked);
        --this.ackCounter;
    }

    protected void prepareClientAcknowledge(MessageImpl message) throws JMSException {
        this.addMessageToAckList(message);
        if (this.isAckLimited) {
            this.checkClientAckLimit();
        }
    }

    protected void checkClientAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String errorString = AdministeredObject.cr.getKString("C4023");
            if (logger.isTraceEnabled()) {
                logger.trace(errorString);
            }
        }
    }

    protected boolean prepareTransactedAcknowledge(MessageImpl message) throws JMSException {
        boolean isAddedToList = false;
        isAddedToList = this.addMessageToAckList(message);
        if (this.isAckLimited) {
            this.checkTransactedAckLimit();
        }
        return isAddedToList;
    }

    protected void checkTransactedAckLimit() throws JMSException {
        if (this.ackCounter > this.ackLimit) {
            String errorString = AdministeredObject.cr.getKString("C4026");
            if (logger.isTraceEnabled()) {
                logger.trace(errorString);
            }
        }
    }

    protected void clientAcknowledge(MessageImpl message) throws JMSException {
        if (this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4075");
            JMSException jmse = new JMSException(errorString, "C4075");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.checkClientAckMessage(message);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(message);
            if (this.unAckedMessageQueue.size() > 0) {
                this.dequeueUnAckedMessages();
                this.doClientAcknowledge();
            }
        }
    }

    protected void clientAcknowledgeThisMessage(MessageImpl message) throws JMSException {
        this.checkClientAckMessage(message);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(message);
            UnAckedMessage unAckedMessage = null;
            for (int i = 0; i < this.unAckedMessageQueue.size(); ++i) {
                unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
                if (!message.messageID.equals(unAckedMessage.getMessageID())) continue;
                this.writeMessageID(unAckedMessage);
                this.unAckedMessageQueue.removeElementAt(i);
                this.doClientAcknowledge();
                return;
            }
        }
    }

    protected void clientAcknowledgeUpThroughThisMessage(MessageImpl message) throws JMSException {
        if (this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4075");
            JMSException jmse = new JMSException(errorString, "C4075");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.checkClientAckMessage(message);
        this.checkSessionState();
        if (!this.isTransacted) {
            this.prepareClientAcknowledge(message);
            if (this.isMessageInUnAckedQueue(message)) {
                UnAckedMessage unAckedMessage = null;
                boolean found = false;
                while (!found) {
                    unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.firstElement();
                    this.writeMessageID(unAckedMessage);
                    this.unAckedMessageQueue.removeElementAt(0);
                    if (!message.messageID.equals(unAckedMessage.getMessageID())) continue;
                    found = true;
                }
                this.doClientAcknowledge();
            }
        }
    }

    private void doClientAcknowledge() throws JMSException {
        if (this.remore_broker_failed) {
            ExceptionHandler.throwRemoteAcknowledgeException(null, "C4108");
        }
        try {
            this.doAcknowledge(true);
        }
        catch (JMSException jmse) {
            if (this.isRemoteException(jmse)) {
                this.remore_broker_failed = true;
                ExceptionHandler.throwRemoteAcknowledgeException(jmse, "C4108");
            }
            throw jmse;
        }
    }

    protected boolean isMessageInUnAckedQueue(MessageImpl message) throws JMSException {
        boolean inQueue = false;
        UnAckedMessage unAckedMessage = null;
        int size = this.unAckedMessageQueue.size();
        for (int i = 0; i < size; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            if (!message.messageID.equals(unAckedMessage.getMessageID())) continue;
            inQueue = true;
            i = size;
        }
        return inQueue;
    }

    protected void checkSessionState() throws JMSException {
        if (this.isClosed) {
            String errorString = AdministeredObject.cr.getKString("C4059");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4059");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected void checkFailOver() throws JMSException {
        if (this.isTransacted && this.failoverOccurred) {
            String errorString = AdministeredObject.cr.getKString("C4103");
            JMSException jmse = new JMSException(errorString, "C4103");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkSessionState();
        return new BytesMessageImpl(true, this.connection.getProtocolType());
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkSessionState();
        return new MapMessageImpl(this.connection.getProtocolType());
    }

    public Message createMessage() throws JMSException {
        this.checkSessionState();
        MessageImpl message = new MessageImpl(this.connection.getProtocolType());
        return message;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkSessionState();
        return new ObjectMessageImpl(this.connection.getProtocolType());
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkSessionState();
        ObjectMessageImpl objectMessage = new ObjectMessageImpl(this.connection.getProtocolType());
        objectMessage.setObject(object);
        return objectMessage;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkSessionState();
        return new StreamMessageImpl(true, this.connection.getProtocolType());
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkSessionState();
        TextMessageImpl msg = new TextMessageImpl(this.connection.getProtocolType());
        return msg;
    }

    public FileMessage createFileMessage() throws JMSException {
        this.checkSessionState();
        return new FileMessageImpl(this.connection.getProtocolType());
    }

    public FileMessage createFileMessage(String file) throws JMSException {
        this.checkSessionState();
        return new FileMessageImpl(file, this.connection.getProtocolType());
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkSessionState();
        TextMessageImpl message = new TextMessageImpl(this.connection.getProtocolType());
        message.setText(text);
        return message;
    }

    public boolean getTransacted() throws JMSException {
        this.checkSessionState();
        return this.isTransacted;
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            return 0;
        }
        return this.acknowledgeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        block12: {
            Object jmse;
            String errorString;
            this.checkSessionState();
            if (!this.isTransacted) {
                errorString = AdministeredObject.cr.getKString("C4024");
                jmse = new IllegalStateException(errorString, "C4024");
                ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
            }
            if (this.failoverOccurred) {
                this.rollback();
                errorString = AdministeredObject.cr.getKString("C4074");
                jmse = new TransactionRolledBackException(errorString, "C4074");
                ExceptionHandler.throwJMSException((JMSException)((Object)jmse));
            }
            if (this.isRollbackOnly) {
                if (this.rollbackCause instanceof Exception) {
                    ExceptionHandler.handleException((Exception)this.rollbackCause, "C4038");
                } else {
                    Exception e = new Exception(this.rollbackCause);
                    ExceptionHandler.handleException(e, "C4038");
                }
            }
            this.setInSyncState();
            try {
                this.receiveCommit();
                this.transaction.commit();
                Hashtable consumers = this.getAllMessageConsumer();
                Enumeration consumerIds = consumers.keys();
                while (consumerIds.hasMoreElements()) {
                    Long id = (Long)consumerIds.nextElement();
                    MessageConsumerImpl consumer = (MessageConsumerImpl)consumers.get(id);
                    consumer.clearTranMsgFileName();
                }
            }
            catch (JMSException jmse2) {
                if (this.isRemoteException(jmse2)) {
                    this.doRemoteFailedRollback(jmse2);
                    break block12;
                }
                throw jmse2;
            }
            finally {
                this.releaseInSyncState();
            }
        }
    }

    protected void doRemoteFailedRollback(JMSException jmse) throws JMSException {
        this.recreateConsumers();
        String errorString = AdministeredObject.cr.getKString("C4109");
        com.tongtech.jms.TransactionRolledBackException newjmse = new com.tongtech.jms.TransactionRolledBackException(errorString, "C4109");
        newjmse.setLinkedException((Exception)((Object)jmse));
        ExceptionHandler.throwJMSException((JMSException)((Object)newjmse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        block12: {
            this.checkSessionState();
            if (!this.isTransacted) {
                String errorString = AdministeredObject.cr.getKString("C4024");
                IllegalStateException jmse = new IllegalStateException(errorString, "C4024");
                ExceptionHandler.throwJMSException((JMSException)jmse);
            }
            this.setInSyncState();
            try {
                if (this.remore_broker_failed) {
                    this.recreateConsumers();
                    this.remore_broker_failed = false;
                    return;
                }
                if (this.connection.isConnectedToHABroker) {
                    this.rollbackHATransaction();
                    break block12;
                }
                this.protocolHandler.rollbackStart(this);
                Long tempTxid = new Long(this.getTransaction().getTransactionID());
                try {
                    this.receiveRollback();
                    this.transaction.rollback();
                }
                catch (JMSException e) {
                    throw e;
                }
                finally {
                    this.protocolHandler.rollbackEnd(tempTxid);
                }
            }
            finally {
                this.isRollbackOnly = false;
                this.rollbackCause = null;
                this.failoverOccurred = false;
                this.releaseInSyncState();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackHATransaction() throws JMSException {
        block6: {
            this.protocolHandler.rollbackStart(this);
            Long tempTxid = new Long(this.getTransaction().getTransactionID());
            try {
                this.receiveRollback();
                this.transaction.rollback();
            }
            catch (JMSException jmse) {
                String ecode = jmse.getErrorCode();
                if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
                    this.rollbackFailed(jmse);
                    break block6;
                }
                throw jmse;
            }
            finally {
                this.protocolHandler.rollbackEnd(tempTxid);
            }
        }
    }

    private void rollbackFailed(JMSException jmse) throws JMSException {
        if (!this.connection.tmqiReconnect) {
            throw jmse;
        }
        SessionImpl.yield();
        this.connection.checkReconnecting(null);
        if (this.connection.isCloseCalled || this.connection.connectionIsBroken) {
            throw jmse;
        }
        this.transaction.startNewLocalTransaction();
    }

    public static void yield() {
        try {
            Thread.yield();
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConsumers() throws JMSException {
        MessageConsumerImpl[] consumerArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
        for (int i = 0; i < consumerArray.length; ++i) {
            consumerArray[i].close();
        }
        this.consumers.clear();
    }

    private void closeProducers() throws JMSException {
        MessageProducerImpl[] _producers = this.producers.toArray(new MessageProducerImpl[0]);
        for (int i = 0; i < _producers.length; ++i) {
            _producers[i].close();
        }
        this.producers.clear();
    }

    private void closeBrowserConsumers() throws JMSException {
        BrowserConsumer[] bcArray = this.browserConsumers.values().toArray(new BrowserConsumer[0]);
        for (int i = 0; i < bcArray.length; ++i) {
            bcArray[i].close();
        }
        this.browserConsumers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        sessionLogger.log(Level.FINEST, "##### closing session.  consumer table size: " + this.consumers.values().size());
        int reduceFlowCount = 0;
        this.checkPermission();
        try {
            this.prepareToClose();
            Object object = this.sessionSyncObj;
            synchronized (object) {
                block18: {
                    if (!this.isClosed) break block18;
                    return;
                }
                this.sessionQueue.stop(true);
                reduceFlowCount = this.sessionQueue.size();
                if (this.isTransacted) {
                    if (this.xaTxnMode) {
                        this.receiveCommit();
                    } else if (!this.connection.isBroken() && !this.connection.recoverInProcess) {
                        this.transaction.releaseBrokerResource();
                    }
                }
                this.closeConsumers();
                this.closeProducers();
                this.closeBrowserConsumers();
                this.sessionReader.close();
                this.serverSessionRunner.serverSessionClose();
                this.connection.removeSession(this);
                this.connection.removeFromReadQTable(this.sessionId);
                if (this.connection.getBrokerProtocolLevel() >= 350 && !this.connection.isBroken() && !this.connection.recoverInProcess) {
                    this.protocolHandler.deleteSession(this);
                }
                this.isClosed = true;
            }
        }
        finally {
            sessionLogger.log(Level.FINEST, "***** consumer table size: " + this.consumers.values().size());
            if (!this.isClosed) {
                this.sessionReader.close();
            }
            if (this.consumers.values().size() > 0) {
                this.cleanUpConsumers();
            }
            this.isClosed = true;
            this.releaseInSyncState();
            this.resetConnectionFlowControl(reduceFlowCount);
            if (sessionLogger.isLoggable(Level.FINE)) {
                this.logLifeCycle("I201");
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("session closed ...");
        }
        if (logger.isTraceEnabled()) {
            logger.trace("", this);
        }
    }

    protected void cleanUpConsumers() {
        sessionLogger.log(Level.FINEST, "Cleaning up consumers in session.  SessionID: " + this.sessionId);
        MessageConsumerImpl[] consumerArray = this.consumers.values().toArray(new MessageConsumerImpl[0]);
        for (int i = 0; i < consumerArray.length; ++i) {
            consumerArray[i].receiveQueue.close();
            consumerArray[i].isClosed = true;
        }
        this.consumers.clear();
    }

    protected void resetConnectionFlowControl(int reduceFlowCount) {
        if (this.connection.isCloseCalled) {
            return;
        }
        if (this.connection.protectMode && reduceFlowCount > 0) {
            this.readChannel.getFlowControl().resetFlowControl(this.connection, reduceFlowCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFromRA() {
        Object object = this.raEndpointSyncObj;
        synchronized (object) {
            this.sessionReader.close();
        }
    }

    public void _setRAEndpointSession() {
    }

    public void _startLocalTransaction() throws JMSException {
        if (this.isTransacted) {
            if (this.transaction == null) {
                throw new com.tongtech.jms.JMSException("MQRA:S:Can't start local transaction-transacted w/o Transaction Object");
            }
        } else {
            if (this.transaction != null) {
                throw new com.tongtech.jms.JMSException("MQRA:S:Can't start local transaction-already transacted");
            }
            this.transaction = new Transaction(this, true);
            this.isTransacted = true;
        }
    }

    protected boolean needToWait() {
        return !this.connection.isBroken();
    }

    /*
     * Unable to fully structure code
     */
    public void recover() throws JMSException {
        this.checkSessionState();
        if (this.isTransacted) {
            errorString = AdministeredObject.cr.getKString("C4025");
            jmse = new IllegalStateException(errorString, "C4025");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        if (this.acknowledgeMode == 32768) {
            errorString = AdministeredObject.cr.getKString("C4091");
            jmse = new IllegalStateException(errorString, "C4091");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        if (this.remore_broker_failed) {
            this.recreateConsumers();
            this.remore_broker_failed = false;
            return;
        }
        this.setInSyncState();
        try {
            switch (this.acknowledgeMode) {
                case 1: {
                    if (Thread.currentThread() != this.sessionReader.sessionThread) ** GOTO lbl21
                    this.sessionReader.currentMessage.doAcknowledge = false;
                    ** GOTO lbl23
lbl21:
                    // 1 sources

                    if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
                        this.serverSessionRunner.currentMessage.doAcknowledge = false;
                    }
                }
lbl23:
                // 5 sources

                case 2: 
                case 3: {
                    if (Thread.currentThread() == this.sessionReader.sessionThread) {
                        this.prepareClientAcknowledge(this.sessionReader.currentMessage);
                        break;
                    }
                    if (Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) break;
                    this.prepareClientAcknowledge(this.serverSessionRunner.currentMessage);
                }
            }
        }
        catch (Exception var1_2) {
            // empty catch block
        }
        try {
            this.stopSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop();
            }
            this.redeliverMessagesInQueues(false);
            this.redeliverUnAckedMessages(true);
            this.failoverOccurred = false;
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
            }
        }
        finally {
            this.releaseInSyncState();
            this.resumeSession();
        }
    }

    protected void stopSession() throws JMSException {
        this.protocolHandler.stopSession(this);
    }

    protected void resumeSession() throws JMSException {
        this.protocolHandler.resumeSession(this);
    }

    protected void rollbackSession() throws JMSException {
        this.protocolHandler.rollbackSession(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInSyncState() throws JMSException {
        Object object = this.syncObject;
        synchronized (object) {
            this.checkSessionState();
            if (this.inSyncState) {
                String errorString = AdministeredObject.cr.getKString("C4055");
                IllegalStateException jmse = new IllegalStateException(errorString, "C4055");
                ExceptionHandler.throwJMSException((JMSException)jmse);
            }
            this.inSyncState = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseInSyncState() {
        Object object = this.syncObject;
        synchronized (object) {
            this.inSyncState = false;
            this.syncObject.notifyAll();
        }
    }

    protected boolean getInSyncState() {
        return this.inSyncState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareToClose() {
        Object object = this.syncObject;
        synchronized (object) {
            while (this.inSyncState) {
                try {
                    this.syncObject.wait();
                }
                catch (InterruptedException e) {
                    logger.warn("", e);
                }
            }
            this.inSyncState = true;
        }
    }

    protected void receiveCommit() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.transactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.transactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
    }

    protected void clearUnackedMessageQ() {
        this.unAckedMessageQueue.clear();
    }

    protected void receiveRollback() throws JMSException {
        if (Thread.currentThread() == this.sessionReader.sessionThread) {
            this.prepareTransactedAcknowledge(this.sessionReader.currentMessage);
        } else if (Thread.currentThread() == this.serverSessionRunner.getCurrentThread()) {
            this.prepareTransactedAcknowledge(this.serverSessionRunner.currentMessage);
        }
        this.stopSession();
        this.rollbackSession();
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.stop();
        }
        this.redeliverUnAckedMessages(true);
        this.redeliverMessagesInQueues(false);
        if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
            this.start();
        }
        this.resumeSession();
    }

    protected void redeliverUnAckedMessages(boolean redeliverFlag) throws JMSException {
        this.dequeueUnAckedMessages();
        this.redeliver(redeliverFlag);
    }

    protected void redeliverMessagesInQueues(boolean redeliverFlag) throws JMSException {
        this.dequeueMessagesInQueues();
        this.redeliver(redeliverFlag);
    }

    protected void dequeueMessagesInQueues() throws JMSException {
        MessageConsumerImpl consumer = null;
        Enumeration enum2 = this.consumers.elements();
        int reduceFlowCount = 0;
        while (enum2.hasMoreElements()) {
            consumer = (MessageConsumerImpl)enum2.nextElement();
            reduceFlowCount += consumer.receiveQueue.size();
            this.dequeueReceiveQ(consumer.receiveQueue);
            this.readChannel.getFlowControl().resetFlowControl(consumer, 0);
        }
        this.dequeueSessionQ(this.sessionQueue);
        this.resetConnectionFlowControl(reduceFlowCount += this.sessionQueue.size());
    }

    protected void dequeueReceiveQ(ReceiveQueue queue) throws JMSException {
        MessageImpl message = null;
        while (!queue.isEmpty()) {
            message = (MessageImpl)queue.dequeue();
            if (message == null) continue;
            this.writeMessageID(message);
        }
    }

    protected void dequeueSessionQ(SessionQueue queue) throws JMSException {
        ReadOnlyPacket pkt = null;
        while (!queue.isEmpty()) {
            pkt = (ReadOnlyPacket)queue.dequeue();
            if (pkt == null) continue;
            this.writeMessageID(pkt);
        }
    }

    private void dequeueUnAckedMessages() throws JMSException {
        UnAckedMessage unAckedMessage = null;
        int size = this.unAckedMessageQueue.size();
        for (int i = 0; i < size; ++i) {
            unAckedMessage = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
            this.writeMessageID(unAckedMessage);
        }
        this.unAckedMessageQueue.removeAllElements();
        this.ackCounter = 0;
    }

    protected void redeliver(boolean redeliverFlag) throws JMSException {
        if (this.dos.size() == 0) {
            return;
        }
        ReadWritePacket pkt = InjectorUtil.createReadWritePacket(this.connection.getProtocolType());
        try {
            this.dos.flush();
            pkt.setMessageBody(this.dos.toByteArray());
            if (this.isTransacted) {
                pkt.setTransactionID(this.transaction.getTransactionID());
            }
            this.protocolHandler.redeliver(pkt, redeliverFlag, this.isTransacted);
            this.dos.reset();
        }
        catch (IOException e) {
            ExceptionHandler.handleException((Exception)e, "C4018");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkSessionState();
        return this.serverSessionRunner.getMessageListener();
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkSessionState();
        if (listener != null && this.consumers.size() > 0) {
            String errorString = AdministeredObject.cr.getKString("C4031");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4031");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
        this.serverSessionRunner.setMessageListener(listener);
    }

    public void run() {
        this.serverSessionRunner.run();
    }

    protected void loadMessageToServerSession(MessageImpl message, ServerSession ss) {
        this.serverSessionRunner.loadMessage(message, ss);
    }

    protected SessionQueue getSessionQueue() {
        return this.sessionQueue;
    }

    public boolean _getAckSendAcknowledge() {
        return this.ackPkt.getSendAcknowledge();
    }

    public int _getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    protected boolean _getXaTxnMode() {
        return this.xaTxnMode;
    }

    protected void _setXaTxnMode(boolean mode) {
        this.xaTxnMode = mode;
    }

    public long getBrokerSessionID() {
        return this.brokerSessionID;
    }

    public void setBrokerSessionID(long brokerSessionID) {
        this.brokerSessionID = brokerSessionID;
    }

    public Transaction _getTransaction() {
        return this.transaction;
    }

    public void _initXATransactionForMC(long transactionID) throws JMSException {
        if (this.transaction == null) {
            this.transaction = new Transaction(this, false);
        }
        this.transaction.setTransactionID(transactionID);
        this.xaTxnMode = true;
        this.isTransacted = true;
    }

    public void _finishXATransactionForMC() {
        this.xaTxnMode = false;
        this.isTransacted = false;
        this.transaction = null;
    }

    @Override
    public void dump(PrintStream ps) {
    }

    protected Hashtable getDebugState(boolean verbose) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("sessionId", String.valueOf(this.sessionId));
        ht.put("brokerSessionID", String.valueOf(this.brokerSessionID));
        ht.put("isTransacted", String.valueOf(this.isTransacted));
        ht.put("ackMode", String.valueOf(this.acknowledgeMode));
        ht.put("dupsOkLimit", String.valueOf(this.dupsOkLimit));
        ht.put("isAckLimited", String.valueOf(this.isAckLimited));
        ht.put("ackLimit", String.valueOf(this.ackLimit));
        ht.put("ackCounter", String.valueOf(this.ackCounter));
        ht.put("xaTxnMode", String.valueOf(this.xaTxnMode));
        ht.put("rxCount", String.valueOf(this.TEST_rxCount));
        ht.put("ackCount", String.valueOf(this.TEST_ackCount));
        ht.put("isStopped", String.valueOf(this.isStopped));
        ht.put("# Consumers", String.valueOf(this.consumers.size()));
        int n = 0;
        Enumeration enum2 = this.consumers.elements();
        while (enum2.hasMoreElements()) {
            MessageConsumerImpl consumer = (MessageConsumerImpl)enum2.nextElement();
            ht.put("Consumer[" + n + "]", consumer.getDebugState(verbose));
            ++n;
        }
        ht.put("# Producers", String.valueOf(this.producers.size()));
        MessageProducerImpl[] _producers = this.producers.toArray(new MessageProducerImpl[0]);
        for (int i = 0; i < _producers.length; ++i) {
            ht.put("Producer[" + i + "]", _producers[i].getDebugState(verbose));
        }
        if (verbose) {
            ht.put("unacked", this.unAckedMessageQueue);
        }
        return ht;
    }

    private void checkClientAckMessage(MessageImpl message) throws JMSException {
        Long id;
        if (this.connection.getBrokerProtocolLevel() < 350 && !this.consumers.containsKey(id = new Long(message.getInterestID()))) {
            String errorString = AdministeredObject.cr.getKString("C4058");
            IllegalStateException jmse = new IllegalStateException(errorString, "C4058");
            ExceptionHandler.throwJMSException((JMSException)jmse);
        }
    }

    protected void removeUnAckedMessages(Long interestId) throws JMSException {
        int size = this.unAckedMessageQueue.size();
        if (size > 0) {
            int i;
            Vector<UnAckedMessage> removeq = new Vector<UnAckedMessage>();
            long consumerID = interestId;
            for (i = 0; i < size; ++i) {
                UnAckedMessage msg = (UnAckedMessage)this.unAckedMessageQueue.elementAt(i);
                if (msg.getConsumerID() != consumerID) continue;
                removeq.addElement(msg);
            }
            for (i = 0; i < removeq.size(); ++i) {
                if (logger.isTraceEnabled()) {
                    logger.trace("removing msg from unackq: " + removeq.elementAt(i));
                }
                this.removeMessageFromAckList((UnAckedMessage)removeq.elementAt(i));
            }
        }
    }

    public void logLifeCycle(String key) {
        if (sessionLogger.isLoggable(Level.FINE)) {
            sessionLogger.log(Level.FINE, key, this);
        }
    }

    public String toString() {
        return "ConnectionID=" + this.connection.getConnectionID() + ", SessionID=" + this.brokerSessionID;
    }

    protected void recreateConsumers() throws JMSException {
        try {
            int i;
            sessionLogger.finest("Re-creating consumers for the session: " + this.sessionId);
            Object[] savedConsumers = this.consumers.values().toArray();
            this.stopSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.stop(false);
            }
            this.sessionQueue.clear();
            for (i = 0; i < savedConsumers.length; ++i) {
                ((MessageConsumerImpl)savedConsumers[i]).receiveQueue.clear();
                ((MessageConsumerImpl)savedConsumers[i]).deregisterInterest();
                ((MessageConsumerImpl)savedConsumers[i]).logLifeCycle("I301");
            }
            if (this.unAckedMessageQueue != null) {
                this.unAckedMessageQueue.removeAllElements();
            }
            this.consumers.clear();
            if (this.isTransacted) {
                this.transaction.rollback();
            }
            for (i = 0; i < savedConsumers.length; ++i) {
                ((MessageConsumerImpl)savedConsumers[i]).registerInterest();
                ((MessageConsumerImpl)savedConsumers[i]).logLifeCycle("I300");
            }
            this.resumeSession();
            if (Thread.currentThread() != this.sessionReader.sessionThread && Thread.currentThread() != this.serverSessionRunner.getCurrentThread()) {
                this.start();
            }
            this.remore_broker_failed = false;
            sessionLogger.finest("Consumers recreated for the session: " + this.sessionId);
        }
        catch (JMSException jmse) {
            sessionLogger.log(Level.SEVERE, jmse.getMessage(), (Object)jmse);
            throw jmse;
        }
    }

    protected boolean isRemoteException(JMSException jmse) {
        boolean isRemoteFailed = false;
        String errcode = jmse.getErrorCode();
        if (("C4110".equals(errcode) || "C4107".equals(errcode) || "C4108".equals(errcode) || "C4109".equals(errcode)) && this.matchConsumerIDs((RemoteAcknowledgeException)jmse)) {
            isRemoteFailed = true;
        }
        return isRemoteFailed;
    }

    protected boolean matchConsumerIDs(RemoteAcknowledgeException rae) {
        Hashtable prop = rae.getProperties();
        if (prop == null) {
            return false;
        }
        String cvalue = (String)prop.get("JMQRemoteConsumerIDs");
        if (cvalue == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(cvalue);
        while (st.hasMoreTokens()) {
            String cidstr = st.nextToken();
            Long cid = new Long(cidstr);
            Object obj = this.consumers.get(cid);
            if (obj == null) continue;
            sessionLogger.finest("SessionImpl.matchConsumerIDs: Consumer ID matches: " + cidstr);
            return true;
        }
        return false;
    }

    public static long genSessionId() {
        return TlqSessionIdGen.getNextId();
    }

    public class UnAckedMessage {
        private SysMessageID mid = null;
        private long cid = -1L;
        private String msgid = null;
        private String destination = null;
        private String srcNode = null;
        private boolean isQueue = true;
        private String subQueue = null;
        private long seqId;

        private UnAckedMessage(MessageImpl message) {
            if (message.getRealAckMsgInfo() == null) {
                this.mid = message.getMessageID();
                this.cid = message.getInterestID();
                this.msgid = message.getPacket().getMessageID();
                this.destination = message.getPacket().getDestination();
                this.srcNode = message.getPacket().getSrcNode();
                this.isQueue = message.getPacket().getIsQueue();
                this.subQueue = message.getPacket().getSubQueue();
                this.seqId = message.getSeqId();
            } else {
                TupleInput input = new TupleInput(message.getRealAckMsgInfo());
                this.cid = input.readLong();
                this.msgid = input.readString();
                this.isQueue = input.readBoolean();
                this.destination = input.readString();
                this.srcNode = input.readString();
                this.subQueue = input.readString();
                this.seqId = input.readLong();
            }
        }

        public SysMessageID getMessageID() {
            return this.mid;
        }

        public long getConsumerID() {
            return this.cid;
        }

        public String getMsgId() {
            return this.msgid;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getSrcNode() {
            return this.srcNode;
        }

        public boolean getIsQueue() {
            return this.isQueue;
        }

        public String getSubQueue() {
            return this.subQueue;
        }

        public long getSeqId() {
            return this.seqId;
        }

        public void setSeqId(long seqId) {
            this.seqId = seqId;
        }
    }
}

