/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.Traceable;
import java.io.PrintStream;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class TextMessageImpl
extends MessageImpl
implements TextMessage,
Traceable {
    private String text = null;

    @Override
    public void setMessageBodyToPacket() throws JMSException {
        if (this.text == null) {
            return;
        }
        try {
            if (this.getStringProperty("JMS_TONG_SM4_ID") != null) {
                byte[] body = this.text.getBytes("UTF8");
                body = this.sm4crypt(body, this.getStringProperty("JMS_TONG_SM4_ID"));
                this.setMessageBody(body);
            } else {
                this.setMessageBody(this.text.getBytes("UTF8"));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4014");
        }
    }

    @Override
    public void getMessageBodyFromPacket() throws JMSException {
        try {
            byte[] body = this.getMessageBody();
            if (this.getStringProperty("JMS_TONG_SM4_ID") != null) {
                body = this.sm4decrypt(body, this.getStringProperty("JMS_TONG_SM4_ID"));
            }
            if (body != null) {
                this.text = new String(body, "UTF8");
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4015");
        }
    }

    public TextMessageImpl(int packetType) throws JMSException {
        super(packetType);
        this.setPacketType(1);
    }

    @Override
    public void clearBody() throws JMSException {
        this.text = null;
        this.setMessageReadMode(false);
    }

    public void setText(String string) throws JMSException {
        this.checkMessageAccess();
        this.text = string;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    @Override
    public String toString() {
        return new StringBuffer().append("\nText:\t").append(this.text).append(super.toString()).toString();
    }

    @Override
    public void dump(PrintStream ps) {
    }
}

