/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.AdministeredObject;
import com.tongtech.tmqi.io.ReadWritePacket;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.WriteChannel;
import com.tongtech.tmqi.util.JMQXid;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TransactionRolledBackException;

public class Transaction {
    protected SessionImpl session = null;
    protected ProtocolHandler protocolHandler = null;
    protected WriteChannel writeChannel = null;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    private boolean setJMSXProducerTXID = false;
    static Logger logger = LoggerFactory.getLogger(Transaction.class);
    private boolean resetFailOverFlag = false;
    public static final int TRANSACTION_STARTED = 0;
    public static final int TRANSACTION_ENDED = 1;
    public static final int TRANSACTION_PREPARED = 2;
    public static final int TRANSACTION_COMMITTED = 3;
    public static final int TRANSACTION_ROLLBACK_ONLY = 4;
    public static final int TRANSACTION_VERIFY_STATUS_COMMITTED = 7;
    public static final int TRANSACTION_VERIFY_STATUS_ROLLEDBACK = 8;

    protected Transaction(SessionImpl session, boolean startLocal) throws JMSException {
        this.session = session;
        this.writeChannel = session.connection.getWriteChannel();
        this.protocolHandler = session.protocolHandler;
        this.setJMSXProducerTXID = session.connection.connectionMetaData.setJMSXProducerTXID;
        if (logger.isTraceEnabled()) {
            logger.trace("startLocal {}", new Boolean(startLocal));
        }
        if (startLocal) {
            if (session.connection.isConnectedToHABroker) {
                session.protocolHandler.setTwoPhaseCommitFlag(true);
            }
            this.startNewLocalTransaction();
        }
    }

    protected void setProtocolHandler(ProtocolHandler pHandler) {
        this.protocolHandler = pHandler;
    }

    protected void init() throws JMSException {
        this.startNewLocalTransaction();
        this.setJMSXProducerTXID = this.session.connection.connectionMetaData.setJMSXProducerTXID;
    }

    protected synchronized void commit() throws JMSException {
        try {
            if (this.session.connection.isConnectedToHABroker) {
                this.commitHATransaction();
                this.session.clearUnackedMessageQ();
                this.startHANewLocalTransaction();
            } else {
                this.protocolHandler.commit(this.transactionID, -1, null);
                if (logger.isDebugEnabled()) {
                    logger.debug("*** in Transaction.commit(), txID: {}", new Long(this.transactionID));
                }
                this.session.clearUnackedMessageQ();
                this.startNewLocalTransaction();
            }
        }
        catch (JMSException jmse) {
            this.checkCommitException(jmse);
        }
    }

    private void checkCommitException(JMSException jmse) throws JMSException {
        try {
            if (jmse instanceof TransactionRolledBackException) {
                this.session.clearUnackedMessageQ();
            } else {
                String ecode = jmse.getErrorCode();
                if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
                    this.session.clearUnackedMessageQ();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw jmse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitHATransaction() throws JMSException {
        block9: {
            this.resetFailOverFlag = false;
            int tstate = -1;
            try {
                this.protocolHandler.endHATransaction(this.transactionID);
                tstate = 1;
                this.protocolHandler.prepareHATransaction(this.transactionID);
                tstate = 2;
                this.protocolHandler.commitHATransaction(this.transactionID);
                tstate = 3;
                this.resetFailOverFlag = true;
            }
            catch (TransactionRolledBackException tre) {
                this.resetFailOverFlag = true;
                this.throwRollbackException(tre);
            }
            catch (JMSException e) {
                String ecode = e.getErrorCode();
                if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
                    this.checkCommitStatus(e, tstate);
                    this.resetFailOverFlag = true;
                    break block9;
                }
                throw e;
            }
            finally {
                if (this.resetFailOverFlag) {
                    this.session.failoverOccurred = false;
                    this.resetFailOverFlag = false;
                }
            }
        }
    }

    private void startHANewLocalTransaction() throws JMSException {
        block7: {
            try {
                this.startNewLocalTransaction();
                if (this.session.failoverOccurred) {
                    this.session.failoverOccurred = false;
                }
            }
            catch (JMSException jmse) {
                SessionImpl.yield();
                this.session.connection.checkReconnecting(null);
                if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
                    throw jmse;
                }
                String ecode = jmse.getErrorCode();
                if (!"C4001".equals(ecode) && !"C4000".equals(ecode)) break block7;
                try {
                    this.startNewLocalTransaction();
                    if (this.session.failoverOccurred) {
                        this.session.failoverOccurred = false;
                    }
                }
                catch (JMSException jmse2) {
                    SessionImpl.sessionLogger.log(Level.WARNING, "C4105", (Object)jmse2);
                }
            }
        }
    }

    private void checkCommitStatus(JMSException jmse, int tstate) throws JMSException {
        if (!this.session.connection.tmqiReconnect) {
            throw jmse;
        }
        SessionImpl.yield();
        this.session.connection.checkReconnecting(null);
        if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
            throw jmse;
        }
        try {
            this.verifyTransaction(tstate);
        }
        catch (TransactionRolledBackException tre) {
            this.resetFailOverFlag = true;
            this.session.failoverOccurred = false;
            if (logger.isTraceEnabled()) {
                logger.trace("*** in checkCommitStatus(), reset session.failoverOccurred flag to false.");
            }
            throw tre;
        }
        catch (JMSException jmsexception) {
            throw jmsexception;
        }
    }

    private void verifyTransaction(int tstate) throws JMSException {
        if (tstate < 1) {
            this.createAndThrowFailoverRollbackException();
        }
        int state = this.protocolHandler.verifyHATransaction(this.transactionID, tstate);
        switch (state) {
            case 7: {
                if (logger.isTraceEnabled()) {
                    logger.trace("transaction verified: state is successful");
                }
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.protocolHandler.commitHATransaction(this.transactionID);
                    SessionImpl.sessionLogger.log(Level.INFO, "verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jmse) {
                    if (!this.session.connection.tmqiReconnect) {
                        throw jmse;
                    }
                    SessionImpl.yield();
                    this.session.connection.checkReconnecting(null);
                    if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
                        throw jmse;
                    }
                    this.protocolHandler.rollback(this.transactionID);
                }
            }
        }
        this.createAndThrowFailoverRollbackException();
    }

    private void createAndThrowFailoverRollbackException() throws TransactionRolledBackException {
        String errorString = AdministeredObject.cr.getKString("C4074");
        TransactionRolledBackException tre = new TransactionRolledBackException(errorString, "C4074");
        this.throwRollbackException(tre);
    }

    private void throwRollbackException(TransactionRolledBackException tre) throws TransactionRolledBackException {
        try {
            this.startNewLocalTransaction();
        }
        catch (Exception e) {
            this.transactionID = -1L;
            logger.warn("", e);
        }
        throw tre;
    }

    protected synchronized void rollback() throws JMSException {
        if (!this.session.failoverOccurred) {
            this.protocolHandler.rollback(this.transactionID);
            if (logger.isDebugEnabled()) {
                logger.debug("*** in Transaction.rollback(), txID: {}", new Long(this.transactionID));
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace("*** rollback pkt not sent because failover occurred.");
        }
        this.startNewLocalTransaction();
    }

    protected void rollbackToXA() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
        this.transactionID = -1L;
    }

    protected void send(Message message) throws JMSException {
        MessageImpl messageImpl = (MessageImpl)message;
        if (this.setJMSXProducerTXID) {
            messageImpl.setStringProperty("JMSXProducerTXID", String.valueOf(this.transactionID));
        }
        ReadWritePacket pkt = messageImpl.getPacket();
        pkt.setTransactionID(this.transactionID);
        this.writeChannel.writeJMSMessage(message);
    }

    protected JMQXid[] recoverXATransactions(int flags) throws JMSException {
        return this.protocolHandler.recover(flags);
    }

    protected void prepareXATransaction(JMQXid xid) throws JMSException {
        this.protocolHandler.prepare(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, xid);
    }

    protected void commitXATransaction(JMQXid xid, boolean onePhase) throws JMSException {
        try {
            int flags = onePhase ? 0x40000000 : 0;
            this.protocolHandler.commit(this.jmqXid != null ? this.transactionID : 0L, flags, xid);
            this.session.clearUnackedMessageQ();
        }
        catch (JMSException jmse) {
            this.checkCommitException(jmse);
        }
    }

    protected void rollbackXATransaction(JMQXid xid) throws JMSException {
        this.protocolHandler.rollback(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, xid);
    }

    protected void startXATransaction(int xaflags, JMQXid xid) throws JMSException {
        this.startTransaction(xaflags, xid);
    }

    protected void endXATransaction(int xaflags, JMQXid xid) throws JMSException {
    }

    protected void startNewLocalTransaction() throws JMSException {
        this.transactionID = -1L;
        this.jmqXid = null;
        this.startTransaction(-1, null);
    }

    protected synchronized void startTransaction(int flags, JMQXid xid) throws JMSException {
        if (this.transactionID == -1L) {
            if (logger.isTraceEnabled()) {
                logger.trace("Txn:strtTxn:getting a new Txn ID");
            }
            boolean found = false;
            while (!found) {
                try {
                    this.transactionID = xid == null ? this.protocolHandler.startTransaction(0L, flags, xid, this.session.getBrokerSessionID()) : this.protocolHandler.startTransaction(0L, flags, xid, this.session.getBrokerSessionID());
                    if (this.transactionID < 0L) {
                        logger.warn("get error txid: transactionID {}", new Long(this.transactionID));
                        throw new JMSException("get error txid: transactionID" + this.transactionID);
                    }
                    found = true;
                }
                catch (JMSException jmse) {
                    logger.error("startTransaction fail", jmse);
                    throw jmse;
                }
            }
            if (xid != null) {
                this.jmqXid = xid;
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("@@@ in Transaction.startTransaction(),come to  re start transid txID: {}, flags={}", new Long(this.transactionID), (Object)new Long(flags));
            }
            if (this.jmqXid != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("@@@ in Transaction.startTransaction(), re start transid txID: {}", new Long(this.transactionID), (Object)new Long(this.transactionID));
                }
            } else {
                this.transactionID = this.protocolHandler.startTransaction(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, flags, xid, this.session.getBrokerSessionID());
            }
            if (xid != null) {
                this.jmqXid = xid;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("*** in Transaction.startTransaction(), new txID: {}", new Long(this.transactionID));
        }
        if (this.transactionID < 0L) {
            throw new JMSException("get error txid: " + this.transactionID);
        }
    }

    protected void releaseBrokerResource() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
    }

    private int getNextTransactionID() throws JMSException {
        return this.session.connection.getNextTransactionID();
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public synchronized void setTransactionID(long transactionID) {
        this.transactionID = transactionID;
    }

    public void forgetXATransaction(JMQXid xid) throws JMSException {
        this.protocolHandler.forgetTransaction(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, xid);
    }
}

