/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.io.ReadOnlyPacket;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.Consumer;
import com.tongtech.tmqi.jmsclient.ExceptionHandler;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.ProtocolHandler;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.Message;

public class WriteChannel {
    static Logger logger = LoggerFactory.getLogger(WriteChannel.class);
    private ProtocolHandler protocolHandler = null;
    private ConnectionImpl connection = null;
    public static final String JMQSize = "JMQSize";
    private int flowCount = -1;
    protected boolean turnOffFlowControl = false;

    public WriteChannel(ConnectionImpl conn) {
        this.connection = conn;
        this.protocolHandler = conn.getProtocolHandler();
        if (System.getProperty("NotmqiProducerFlowControl") != null) {
            this.turnOffFlowControl = true;
        }
    }

    protected void addInterest(Consumer consumer) throws JMSException {
        this.protocolHandler.addInterest(consumer);
    }

    protected void removeInterest(Consumer consumer) throws JMSException {
        this.protocolHandler.removeInterest(consumer);
    }

    protected void unsubscribe(String durableName) throws JMSException {
        this.protocolHandler.unsubscribe(durableName);
    }

    protected void writeJMSMessage(Message message) throws JMSException {
        if (this.turnOffFlowControl && this.connection.getBrokerProtocolLevel() < 350) {
            this.protocolHandler.writeJMSMessage(message);
        } else {
            this.sendWithFlowControl(message);
        }
    }

    public void updateFlowControl(ReadOnlyPacket pkt) throws JMSException {
        int jmqSize = -1;
        try {
            Integer prop = (Integer)pkt.getProperties().get(JMQSize);
            if (prop != null) {
                jmqSize = prop;
            }
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        catch (ClassNotFoundException e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
        this.setFlowCount(jmqSize);
    }

    private synchronized void setFlowCount(int jmqSize) {
        this.flowCount = jmqSize;
        this.notifyAll();
    }

    protected void sendWithFlowControl(Message message) throws JMSException {
        this.pause(message);
        this.protocolHandler.writeJMSMessage(message);
    }

    protected synchronized void pause(Message message) {
        while (this.flowCount == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("WriteChannel : Waiting for RESUME_FLOW");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace("WriteChannel : wait() returned...");
        }
        if (this.flowCount > 0) {
            --this.flowCount;
        }
        if (this.flowCount == 0) {
            ((MessageImpl)message).getPacket().setFlowPaused(true);
        } else {
            ((MessageImpl)message).getPacket().setFlowPaused(false);
        }
    }

    protected void close() {
        if (logger.isTraceEnabled()) {
            logger.trace("WriteChannel.close() : Waking up blocked producers");
        }
        this.setFlowCount(-1);
    }
}

