/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmsclient;

import com.tongtech.jms.ra.ManagedConnectionIF;
import com.tongtech.jms.ra.SessionAdapterIF;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmsclient.ConnectionImpl;
import com.tongtech.tmqi.jmsclient.SessionImpl;
import com.tongtech.tmqi.jmsclient.XAResourceForRA;
import com.tongtech.tmqi.jmsclient.XASessionImpl;
import com.tongtech.tmqi.util.JMQXid;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceForMC
implements XAResource {
    static Logger logger = LoggerFactory.getLogger(XAResourceForMC.class);
    private ConnectionImpl raConnection;
    private ConnectionImpl epConnection;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;
    private ManagedConnectionIF mc;
    private int id;
    private long transactionID = -1L;
    private JMQXid jmqXid = null;
    protected boolean started = false;
    protected boolean active = false;
    private static Hashtable xaTable = new Hashtable();

    public XAResourceForMC(ManagedConnectionIF mc, ConnectionImpl raConnection, ConnectionImpl epConnection) throws JMSException {
        this.mc = mc;
        this.id = mc.getMCId();
        this.raConnection = raConnection;
        this.epConnection = epConnection;
        if (raConnection == null) {
            System.err.println("MQRA:XARFMC:constr:raConnectionNull:unable to acquire RMId:assuming distinct");
        } else if (raConnection._isClosed()) {
            System.err.println("MQRA:XARFMC:constr:raConnectionClosed:unable to acquire RMId:assuming distinct");
        } else {
            try {
                this.resourceManagerId = raConnection.getProtocolHandler().generateUID();
            }
            catch (Exception e) {
                System.err.println("MQRA:XARFMC:constr:Exc aquiring RMId:assume distinct");
            }
        }
    }

    @Override
    public synchronized void commit(Xid foreignXid, boolean onePhase) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        try {
            if (!this.epConnection._isClosed()) {
                if (onePhase) {
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HAOnePhaseCommit(foreignXid, jmqXid);
                    } else {
                        this.epConnection.getProtocolHandler().commit(0L, 0x40000000, jmqXid);
                    }
                } else if (this.epConnection.isConnectedToHABroker()) {
                    this.HATwoPhaseCommit(jmqXid);
                } else {
                    this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid);
                }
                SessionAdapterIF sa = this.mc.getConnectionAdapter().getSessionAdapter();
                if (sa != null) {
                    sa.getXASession()._finishXATransactionForMC();
                }
            } else {
                System.err.println("MQRA:XARFMC:commit:ConnectionClosed:throw XAExc txn:1p=" + onePhase + ":xid=" + jmqXid.toString());
                XAException xae = new XAException(-7);
                throw xae;
            }
            this.active = false;
        }
        catch (XAException xaexception) {
            throw xaexception;
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:commit:XAException-Exception=" + jmse.getMessage());
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.removeXid(jmqXid);
    }

    private void HAOnePhaseCommit(Xid foreignXid, JMQXid jmqXid) throws JMSException, XAException {
        int tstate = 1;
        try {
            this.prepare(foreignXid, true);
            tstate = 2;
            if (this.isXATracking()) {
                xaTable.put(jmqXid, XAResourceForRA.XA_PREPARE);
            }
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, true);
        }
        catch (Exception jmse) {
            this.checkCommitStatus(jmse, tstate, jmqXid, true);
        }
        this.removeXid(jmqXid);
    }

    private void HATwoPhaseCommit(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer ts = (Integer)xaTable.get(jmqXid);
                if (ts != null && ts == 2) {
                    this.checkCommitStatus((Exception)((Object)jmse), 2, jmqXid, false);
                }
            }
            throw jmse;
        }
        this.removeXid(jmqXid);
    }

    private void checkPrepareStatus(XAException xae, JMQXid jmqXid) throws XAException {
        if (!this.epConnection.tmqiReconnect) {
            throw xae;
        }
        try {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw xae;
            }
            this.verifyPrepare(jmqXid);
        }
        catch (XAException xae2) {
            throw xae2;
        }
        catch (Exception e) {
            XAException xae3 = new XAException(-7);
            xae3.initCause(e);
            throw xae3;
        }
    }

    private void verifyPrepare(JMQXid jmqXid) throws XAException, JMSException {
        SessionImpl.sessionLogger.log(Level.INFO, "XA verifyPrepare(), jmqXid: " + jmqXid);
        int state = this.epConnection.protocolHandler.verifyHATransaction(0L, 1, jmqXid);
        switch (state) {
            case 6: {
                SessionImpl.sessionLogger.log(Level.INFO, "transaction in prepared state: " + this.transactionID);
                return;
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    private void checkCommitStatus(Exception cause, int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        try {
            this.doCheckCommitStatus(cause, tstate, jmqXid, onePhase);
        }
        catch (Exception ex) {
            if (ex instanceof JMSException) {
                throw (JMSException)((Object)ex);
            }
            if (ex instanceof XAException) {
                throw (XAException)ex;
            }
            XAException xae = new XAException(-7);
            xae.initCause(ex);
            throw xae;
        }
    }

    private void doCheckCommitStatus(Exception ex, int tstate, JMQXid jmqXid, boolean onePhase) throws Exception {
        if (!this.epConnection.tmqiReconnect) {
            throw ex;
        }
        SessionImpl.yield();
        this.epConnection.checkReconnecting(null);
        if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
            throw ex;
        }
        this.verifyTransaction(tstate, jmqXid, onePhase);
    }

    private void verifyTransaction(int tstate, JMQXid jmqXid, boolean onePhase) throws JMSException, XAException {
        int state = this.epConnection.protocolHandler.verifyHATransaction(0L, tstate, jmqXid);
        switch (state) {
            case 7: {
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.epConnection.getProtocolHandler().commit(0L, 0, jmqXid, onePhase);
                    SessionImpl.sessionLogger.log(Level.INFO, "XA verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jmse) {
                    SessionImpl.yield();
                    this.epConnection.checkReconnecting(null);
                    throw jmse;
                }
            }
        }
        XAException xae = new XAException(100);
        throw xae;
    }

    @Override
    public synchronized void end(Xid foreignXid, int flags) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        try {
            this.epConnection.protocolHandler.endTransaction(0L, flags, jmqXid);
            SessionAdapterIF sa = this.mc.getConnectionAdapter().getSessionAdapter();
            if (sa != null) {
                sa.getXASession()._finishXATransactionForMC();
            }
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:end:XAException-Exception=" + jmse.getMessage());
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.started = false;
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XAResourceForRA.XA_END);
        }
    }

    @Override
    public void forget(Xid foreignXid) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource foreignXaRes) throws XAException {
        return this.getClass().isInstance(foreignXaRes) ? this.isSameJMQRM((XAResourceForMC)foreignXaRes) : false;
    }

    public boolean isSameJMQRM(XAResourceForMC xaResource) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xaResource.getResourceManagerId();
        }
        return false;
    }

    @Override
    public synchronized int prepare(Xid foreignXid) throws XAException {
        int result = 0;
        try {
            this.prepare(foreignXid, false);
        }
        catch (XAException xae) {
            if (this.epConnection.isConnectedToHABroker) {
                this.checkPrepareStatus(xae, this.jmqXid);
            }
            throw xae;
        }
        if (this.isXATracking()) {
            xaTable.put(this.jmqXid, XAResourceForRA.XA_PREPARE);
        }
        return result;
    }

    private synchronized int prepare(Xid foreignXid, boolean onePhase) throws XAException {
        int result = 0;
        JMQXid jmqXid = new JMQXid(foreignXid);
        try {
            if (this.epConnection._isClosed()) {
                System.err.println("MQRA:XARFMC:prepare:ConnectionClosed:Rollback txn:xid=" + jmqXid.toString());
                XAException xae = new XAException(-7);
                throw xae;
            }
            this.epConnection.getProtocolHandler().prepare(0L, jmqXid, onePhase);
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:prepare:XAException-Exception=" + jmse.getMessage());
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        JMQXid[] result = null;
        try {
            if (!this.epConnection._isClosed()) {
                result = this.epConnection.getProtocolHandler().recover(flags);
            }
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:recover:XAException-Exception=" + jmse.getMessage());
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        return result;
    }

    @Override
    public synchronized void rollback(Xid foreignXid) throws XAException {
        JMQXid jmqXid;
        block10: {
            jmqXid = new JMQXid(foreignXid);
            XASessionImpl xas = null;
            SessionAdapterIF sa = null;
            try {
                if (!this.epConnection._isClosed()) {
                    sa = this.mc.getConnectionAdapter().getSessionAdapter();
                    if (this.epConnection.isConnectedToHABroker()) {
                        this.HARollback(jmqXid);
                    } else {
                        this.epConnection.getProtocolHandler().rollback(0L, jmqXid, true);
                    }
                    if (sa != null) {
                        xas = sa.getXASession();
                        xas._finishXATransactionForMC();
                    }
                    this.active = false;
                    break block10;
                }
                System.err.println("MQRA:XARFMC:rollback:ConnectionClosed:Rollback txn:xid=" + jmqXid.toString());
                XAException xae = new XAException(-7);
                throw xae;
            }
            catch (Exception jmse) {
                System.err.println("MQRA:XARFMC:rollback:XAException-Exception=" + jmse.getMessage());
                logger.warn("", jmse);
                XAException xae = new XAException(-7);
                xae.initCause(jmse);
                throw xae;
            }
            finally {
                if (sa != null && (xas = sa.getXASession()) != null) {
                    xas.failoverOccurred = false;
                }
            }
        }
        this.removeXid(jmqXid);
    }

    private void HARollback(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jmqXid, true);
        }
        catch (JMSException jmse) {
            SessionImpl.yield();
            this.epConnection.checkReconnecting(null);
            if (this.epConnection.isCloseCalled || this.epConnection.connectionIsBroken) {
                throw jmse;
            }
            this.retryRollBack(jmqXid);
        }
        this.removeXid(jmqXid);
    }

    private void retryRollBack(JMQXid jmqXid) throws JMSException, XAException {
        try {
            this.epConnection.getProtocolHandler().rollback(0L, jmqXid, true, true);
        }
        catch (JMSException jmse) {
            if (this.isXATracking()) {
                Integer tstate = (Integer)xaTable.get(jmqXid);
                if (tstate != null && tstate != 2) {
                    ConnectionImpl.connectionLogger.log(Level.WARNING, jmse.toString());
                }
                throw jmse;
            }
            throw jmse;
        }
    }

    @Override
    public boolean setTransactionTimeout(int transactionTimeout) throws XAException {
        return false;
    }

    @Override
    public synchronized void start(Xid foreignXid, int flags) throws XAException {
        JMQXid jmqXid = new JMQXid(foreignXid);
        try {
            this.transactionID = this.epConnection.protocolHandler.startTransaction(this.transactionID, flags, jmqXid);
            this.jmqXid = jmqXid;
            SessionAdapterIF sa = this.mc.getConnectionAdapter().getSessionAdapter();
            if (sa != null) {
                sa.getXASession()._initXATransactionForMC(this.transactionID);
            }
        }
        catch (Exception jmse) {
            System.err.println("MQRA:XARFMC:start:XAException-Exception=" + jmse.getMessage());
            logger.warn("", jmse);
            XAException xae = new XAException(-7);
            xae.initCause(jmse);
            throw xae;
        }
        this.started = true;
        this.active = true;
        if (this.isXATracking()) {
            xaTable.put(jmqXid, XAResourceForRA.XA_START);
        }
    }

    public int getId() {
        return this.id;
    }

    public synchronized long getTransactionID() {
        return this.transactionID;
    }

    public boolean started() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }

    private boolean isXATracking() {
        return this.epConnection.isConnectedToHABroker() && XAResourceForRA.XATracking;
    }

    private void removeXid(JMQXid jmqXid) {
        if (this.isXATracking()) {
            xaTable.remove(jmqXid);
        }
    }
}

