/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.ClusConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusMessageConsumer;
import com.tongtech.tmqi.jmscluster_v2.ClusProducer;
import com.tongtech.tmqi.jmscluster_v2.ClusQueueReceiver;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import com.tongtech.tmqi.jmscluster_v2.ConntionMemberKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;

public class CheckClusConnThead
extends Thread {
    static Logger logger = LoggerFactory.getLogger(CheckClusConnThead.class);
    private static final long SLEEP_TIME = 1000L;
    ClusConnection clusConn;
    private ConcurrentHashMap clusterConectionMemberStates;
    String jndiurl;
    String factoryName;
    Map changeurls = new HashMap();
    long last_checkTime = System.currentTimeMillis();
    private static final long JMS_SERVER_CHECK_TIME = 300000L;
    private static final String JMS_SERVER_CHANGE_ADD = "add";
    private static final String JMS_SERVER_CHANGE_DEL = "del";

    public CheckClusConnThead(ClusConnection clusConn) {
        this.clusConn = clusConn;
        this.clusterConectionMemberStates = clusConn.getClusterConectionMemberStates();
        this.jndiurl = clusConn.getClusterFactory().getJndiURLS();
        this.factoryName = clusConn.getClusterFactory().getFactoryName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConntionMemberKey connkey = null;
        while (!this.clusConn.isStopped()) {
            if (this.clusConn.getClusterConnionState() == 2) {
                this.clusConn.setClusterConnionState(3);
                break;
            }
            ClusConnection clusConnection = this.clusConn;
            synchronized (clusConnection) {
                if (System.currentTimeMillis() - this.last_checkTime > 300000L) {
                    if (this.checkJndiServerChanged()) {
                        for (String url : this.changeurls.keySet()) {
                            String flag = (String)this.changeurls.get(url);
                            for (int i = 0; i < this.clusConn.getMaxConnsPerClusterMember(); ++i) {
                                connkey = new ConntionMemberKey(this.clusterConectionMemberStates, this.clusConn.getClientID(), this.clusConn.getJmsServerUrls(), this.clusConn.getMaxConnsPerClusterMember());
                                if (flag.equals(JMS_SERVER_CHANGE_ADD)) {
                                    this.clusConn.AddJmsServerUrls(url);
                                    ClusConnection.setConntionMemberStateRecon(this.clusterConectionMemberStates, connkey.getMyKey(url, i));
                                    continue;
                                }
                                if (!flag.equals(JMS_SERVER_CHANGE_DEL)) continue;
                                ClusConnection.setConntionMemberStateDel(this.clusterConectionMemberStates, connkey.getMyKey(url, i));
                            }
                        }
                        this.changeurls.clear();
                    }
                    this.last_checkTime = System.currentTimeMillis();
                }
                for (String connectionKey : this.clusterConectionMemberStates.keySet()) {
                    if (!this.checkConnectionNeedReConn(connectionKey)) continue;
                    this.closeConnMemmberByKey(connectionKey);
                    try {
                        this.ReConAllObjByKey(connectionKey);
                    }
                    catch (Exception e) {
                        logger.error("Re conn fail,e={}", e);
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error("e={}", e);
            }
        }
    }

    private boolean checkConnectionNeedReConn(String connectionKey) {
        String state = (String)this.clusterConectionMemberStates.get(connectionKey);
        return state != null && state.equals("2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnMemmberByKey(String connectionKey) {
        ConcurrentHashMap clusterSessions = this.clusConn.getClusterSessions();
        Iterator iterator = clusterSessions.keySet().iterator();
        while (iterator.hasNext()) {
            ClusSession clusSession;
            ClusSession clusSession2 = clusSession = (ClusSession)clusterSessions.get(iterator.next());
            synchronized (clusSession2) {
                ConcurrentHashMap clusConsumers = clusSession.getClusterconsumers();
                Iterator consuermIt = clusConsumers.keySet().iterator();
                while (consuermIt.hasNext()) {
                    ClusMessageConsumer clusConsumer = (ClusMessageConsumer)clusConsumers.get(consuermIt.next());
                    if (clusConsumer.isClosed()) continue;
                    ClusMessageConsumer clusMessageConsumer = clusConsumer;
                    synchronized (clusMessageConsumer) {
                        MessageConsumer consumer = (MessageConsumer)clusConsumer.getClusterConsumerMembers().get(connectionKey);
                        clusConsumer.getClusterConsumerMembers().remove(connectionKey);
                        try {
                            if (consumer != null) {
                                consumer.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error("close producer fail ,e={}", e);
                        }
                    }
                }
                ConcurrentHashMap clusProducers = clusSession.getClusterproducers();
                Iterator producerIt = clusProducers.keySet().iterator();
                while (producerIt.hasNext()) {
                    ClusProducer clusProducer = (ClusProducer)clusProducers.get(producerIt.next());
                    if (clusProducer.isClosed()) continue;
                    ClusProducer clusProducer2 = clusProducer;
                    synchronized (clusProducer2) {
                        MessageProducer producer = (MessageProducer)clusProducer.getClusterProducerMembers().get(connectionKey);
                        clusProducer.getClusterProducerMembers().remove(connectionKey);
                        try {
                            if (producer != null) {
                                producer.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error("close producer fail !", e);
                        }
                    }
                }
                Session session = (Session)clusSession.getClusterSessionMembers().get(connectionKey);
                clusSession.getClusterSessionMembers().remove(connectionKey);
                try {
                    logger.trace("will close session{}", session);
                    if (session != null) {
                        session.close();
                    }
                }
                catch (Exception e) {
                    logger.error("close session fail", e);
                }
            }
        }
        Connection conn = (Connection)this.clusConn.getClusterConectionMembers().get(connectionKey);
        if (conn != null) {
            try {
                logger.trace("will close connection{}", conn);
                conn.close();
            }
            catch (JMSException e) {
                logger.error("close conn fail,", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ReConAllObjByKey(String connectionKey) throws JMSException {
        try {
            this.clusConn.createConnsMembers(connectionKey);
            ConcurrentHashMap clusterSessions = this.clusConn.getClusterSessions();
            Iterator iterator = clusterSessions.keySet().iterator();
            while (iterator.hasNext()) {
                ClusSession clusSession;
                ClusSession clusSession2 = clusSession = (ClusSession)clusterSessions.get(iterator.next());
                synchronized (clusSession2) {
                    clusSession.createClusterSessionMemmber(connectionKey);
                    ConcurrentHashMap clusProducers = clusSession.getClusterproducers();
                    Iterator producerIt = clusProducers.keySet().iterator();
                    while (producerIt.hasNext()) {
                        ClusProducer clusProducer = (ClusProducer)clusProducers.get(producerIt.next());
                        clusProducer.createProducerMember(connectionKey);
                    }
                    ConcurrentHashMap clusConsumers = clusSession.getClusterconsumers();
                    Iterator consuermIt = clusConsumers.keySet().iterator();
                    while (consuermIt.hasNext()) {
                        ClusMessageConsumer clusMessageConsumer;
                        ClusMessageConsumer clusConsumer;
                        MessageConsumer consumer = (MessageConsumer)clusConsumers.get(consuermIt.next());
                        if (consumer instanceof ClusMessageConsumer) {
                            clusMessageConsumer = clusConsumer = (ClusMessageConsumer)consumer;
                            synchronized (clusMessageConsumer) {
                                clusConsumer.createConsumerMember(connectionKey);
                                continue;
                            }
                        }
                        if (consumer instanceof ClusQueueReceiver) {
                            clusMessageConsumer = clusConsumer = (ClusQueueReceiver)consumer;
                            synchronized (clusMessageConsumer) {
                                ((ClusQueueReceiver)clusConsumer).createReceiverMember(connectionKey, null);
                                continue;
                            }
                        }
                        logger.error("not suport type of consumer{} ", consumer);
                        throw new JMSException("not suport type of consumer");
                    }
                }
            }
            ClusConnection.setConntionMemberStateOK(this.clusConn.getClusterConectionMemberStates(), connectionKey);
        }
        catch (Exception e) {
            String error = "CheckClusConnThead reConn:" + connectionKey;
            logger.error(error, e);
            ClusConnection.setConntionMemberStateRecon(this.clusConn.getClusterConectionMemberStates(), connectionKey);
        }
    }

    private boolean checkJndiServerChanged() {
        Properties pro = new Properties();
        boolean changflag = false;
        this.changeurls.clear();
        pro.setProperty("java.naming.factory.initial", "tongtech.jms.jndi.JmsContextFactory");
        pro.setProperty("java.naming.provider.url", this.jndiurl);
        try {
            int j;
            boolean findflag;
            int i;
            InitialContext ctx = new InitialContext(pro);
            ClusConnectionFactory cluscf = (ClusConnectionFactory)ctx.lookup(this.factoryName);
            List newUrlsList = cluscf.getUrls();
            List oldUrlList = this.clusConn.getJmsServerUrls();
            for (i = 0; i < newUrlsList.size(); ++i) {
                findflag = false;
                for (j = 0; j < oldUrlList.size(); ++j) {
                    if (!((String)newUrlsList.get(i)).equals((String)oldUrlList.get(j))) continue;
                    findflag = true;
                    break;
                }
                if (findflag) continue;
                this.changeurls.put(newUrlsList.get(i), JMS_SERVER_CHANGE_ADD);
                oldUrlList.add(newUrlsList.get(i));
                changflag = true;
            }
            for (i = 0; i < oldUrlList.size(); ++i) {
                findflag = false;
                for (j = 0; j < newUrlsList.size(); ++j) {
                    if (!((String)newUrlsList.get(j)).equals((String)oldUrlList.get(i))) continue;
                    findflag = true;
                    break;
                }
                if (findflag) continue;
                this.changeurls.put(oldUrlList.get(i), JMS_SERVER_CHANGE_DEL);
                oldUrlList.remove(i);
                changflag = true;
            }
        }
        catch (Exception e) {
            logger.error("CheckClusConnThead checkJndiServerChanged fail," + e);
        }
        return changflag;
    }
}

