/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import com.tongtech.tmqi.jmscluster_v2.ConntionMemberKey;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class ClusMessageConsumer
implements MessageConsumer {
    static Logger logger = LoggerFactory.getLogger(ClusMessageConsumer.class);
    private javax.jms.Destination destination;
    private MessageListener msgListener;
    private ClusSession clusSession;
    private boolean durable = false;
    private String durableName;
    private boolean noLocal;
    public ConcurrentHashMap clusterConsumerMembers = new ConcurrentHashMap();
    private String selector;
    private int strategy;
    private ConntionMemberKey conntionMemberkey;
    private int clusterConsumerID;
    private boolean closed = false;

    public ConcurrentHashMap getClusterConsumerMembers() {
        return this.clusterConsumerMembers;
    }

    public void setClusterConsumerMembers(ConcurrentHashMap clusterConsumerMembers) {
        this.clusterConsumerMembers = clusterConsumerMembers;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public ClusMessageConsumer(ClusSession session, javax.jms.Destination destination, String selector, int clusterConsumerID) throws JMSException {
        this.clusSession = session;
        this.selector = selector;
        this.destination = destination;
        this.clusterConsumerID = clusterConsumerID;
        this.conntionMemberkey = new ConntionMemberKey(this.clusSession.clusConnection.getClusterConectionMemberStates(), this.clusSession.clusConnection.getClientID(), this.clusSession.clusConnection.getJmsServerUrls(), this.clusSession.clusConnection.getMaxConnsPerClusterMember());
    }

    public void createConsumerMember(String connectionKey) throws JMSException {
        ConcurrentHashMap sessionmember = this.clusSession.getClusterSessionMembers();
        if (sessionmember == null) {
            throw new JMSException("session is not create!");
        }
        if (connectionKey != null) {
            MessageConsumer consumer = (MessageConsumer)this.clusterConsumerMembers.get(connectionKey);
            if (consumer != null) {
                consumer.close();
            }
            if (this.destination instanceof Topic) {
                TopicSession tsession = (TopicSession)sessionmember.get(connectionKey);
                if (tsession == null) {
                    throw new JMSException("session is not create!");
                }
                TopicSubscriber sub = this.durable ? (this.selector == null ? tsession.createDurableSubscriber((Topic)this.destination, this.durableName) : tsession.createDurableSubscriber((Topic)this.destination, this.durableName, this.selector, this.noLocal)) : (this.selector == null ? tsession.createSubscriber((Topic)this.destination) : tsession.createSubscriber((Topic)this.destination, this.selector, this.noLocal));
                if (sub != null) {
                    this.clusterConsumerMembers.put(connectionKey, sub);
                }
            } else {
                Session session = (Session)sessionmember.get(connectionKey);
                if (session == null) {
                    throw new JMSException("session is not create!");
                }
                consumer = this.selector != null ? session.createConsumer(this.destination, this.selector) : session.createConsumer(this.destination);
                this.clusterConsumerMembers.put(connectionKey, consumer);
            }
        } else {
            for (String temkey : sessionmember.keySet()) {
                if (this.destination instanceof Topic) {
                    TopicSession tsession = (TopicSession)sessionmember.get(temkey);
                    if (tsession == null) {
                        throw new JMSException("session is not create!");
                    }
                    TopicSubscriber sub = this.durable ? (this.selector == null ? tsession.createDurableSubscriber((Topic)this.destination, this.durableName) : tsession.createDurableSubscriber((Topic)this.destination, this.durableName, this.selector, this.noLocal)) : (this.selector == null ? tsession.createSubscriber((Topic)this.destination) : tsession.createSubscriber((Topic)this.destination, this.selector, this.noLocal));
                    if (sub == null) continue;
                    this.clusterConsumerMembers.put(temkey, sub);
                    continue;
                }
                Session session = (Session)sessionmember.get(temkey);
                if (session == null) {
                    throw new JMSException("session is not create!");
                }
                MessageConsumer consumer = this.selector != null ? session.createConsumer(this.destination, this.selector) : session.createConsumer(this.destination);
                this.clusterConsumerMembers.put(temkey, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        ClusMessageConsumer clusMessageConsumer = this;
        synchronized (clusMessageConsumer) {
            this.closed = true;
            if (this.clusterConsumerMembers.isEmpty()) {
                return;
            }
            for (String connectionkey : this.clusterConsumerMembers.keySet()) {
                MessageConsumer consumer = (MessageConsumer)this.clusterConsumerMembers.get(connectionkey);
                if (consumer != null) {
                    consumer.close();
                }
                this.clusterConsumerMembers.remove(connectionkey);
            }
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.msgListener;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws JMSException {
        Message msg = null;
        int retrycount = 0;
        if (this.clusterConsumerMembers.isEmpty()) {
            throw new JMSException("all consumer hava closed, please retry again!");
        }
        while (retrycount < this.clusterConsumerMembers.size()) {
            ++retrycount;
            String connectionkey = this.clusSession.getIsXa() || this.clusSession.getTransacted() ? this.clusSession.getCurrentTransConntionKey() : this.conntionMemberkey.getNextconnkey();
            MessageConsumer consumer = (MessageConsumer)this.clusterConsumerMembers.get(connectionkey);
            if (consumer == null) continue;
            MessageConsumer messageConsumer = consumer;
            synchronized (messageConsumer) {
                try {
                    msg = consumer.receive();
                }
                catch (JMSException e) {
                    logger.error("cluster MessageConsumer receive error\uff0cconntion will Reconnte  e={}", e);
                    ClusConnection.setConntionMemberStateRecon(this.clusSession.clusConnection.getClusterConectionMemberStates(), connectionkey);
                }
            }
            if (msg != null) {
                logger.debug("cluster MessageConsumer receive one Message={}", msg);
                return msg;
            }
            this.conntionMemberkey.setIgnoreTimes(connectionkey, ConntionMemberKey.NORMOR_IGNORETIMES);
        }
        return null;
    }

    public Message receive(long timeout) throws JMSException {
        Message msg = null;
        int retrycount = 0;
        long start_time = System.currentTimeMillis();
        long mytime = 0L;
        int clusterconusernum = this.clusterConsumerMembers.size();
        if (clusterconusernum == 0) {
            throw new JMSException("all consumer hava closed, please retry again!");
        }
        while (retrycount <= 0 || System.currentTimeMillis() - start_time <= timeout) {
            String connectionkey;
            if (this.clusSession.getIsXa() || this.clusSession.getTransacted()) {
                if (retrycount != 0 && this.clusSession.haveTransedNum == 0) {
                    this.clusSession.getNextSessionTrans();
                }
                connectionkey = this.clusSession.getCurrentTransConntionKey();
            } else {
                connectionkey = this.conntionMemberkey.getNextconnkey();
            }
            ++retrycount;
            MessageConsumer consumer = (MessageConsumer)this.clusterConsumerMembers.get(connectionkey);
            if (consumer != null) {
                block16: {
                    try {
                        msg = consumer.receiveNoWait();
                    }
                    catch (JMSException e) {
                        logger.error("cluster MessageConsumer receive error\uff0cconntion will Reconnte.", e);
                        ClusConnection.setConntionMemberStateRecon(this.clusSession.clusConnection.getClusterConectionMemberStates(), connectionkey);
                        if (!this.clusSession.getIsXa() && !this.clusSession.getTransacted()) break block16;
                        throw e;
                    }
                }
                if (msg != null) {
                    if (this.clusSession.getIsXa() || this.clusSession.getTransacted()) {
                        this.clusSession.addHaveTransedNum();
                    }
                    logger.debug("cluster MessageConsumer receive one Message={}", msg);
                    return msg;
                }
                if (this.clusSession.getIsXa() || this.clusSession.getTransacted()) {
                    this.clusSession.getConntionMemberkey().setIgnoreTimes(connectionkey, ConntionMemberKey.NORMOR_IGNORETIMES);
                } else {
                    this.conntionMemberkey.setIgnoreTimes(connectionkey, ConntionMemberKey.NORMOR_IGNORETIMES);
                }
            } else {
                ClusConnection.setConntionMemberStateRecon(this.clusSession.clusConnection.getClusterConectionMemberStates(), connectionkey);
            }
            try {
                if (retrycount == 0 || retrycount % clusterconusernum != 0) continue;
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return null;
    }

    public Message receiveNoWait() throws JMSException {
        Message msg = null;
        int retrycount = 0;
        if (this.clusterConsumerMembers.isEmpty()) {
            throw new JMSException("all consumer hava closed, please retry again!");
        }
        while (retrycount < this.clusterConsumerMembers.size()) {
            ++retrycount;
            String connectionkey = this.clusSession.getIsXa() || this.clusSession.getTransacted() ? this.clusSession.getCurrentTransConntionKey() : this.conntionMemberkey.getNextconnkey();
            MessageConsumer consumer = (MessageConsumer)this.clusterConsumerMembers.get(connectionkey);
            if (consumer == null) continue;
            try {
                msg = consumer.receiveNoWait();
            }
            catch (JMSException e) {
                logger.error("cluster MessageConsumer receive error\uff0cconntion will Reconnte  e={}", e);
                ClusConnection.setConntionMemberStateRecon(this.clusSession.clusConnection.getClusterConectionMemberStates(), connectionkey);
            }
            if (msg != null) {
                logger.debug("cluster MessageConsumer receive one Message={}", msg);
                return msg;
            }
            if ((this.clusSession.getIsXa() || this.clusSession.getTransacted()) && this.clusSession.getHaveTransedNum() == 0) {
                this.clusSession.getNextSessionTrans();
                continue;
            }
            this.conntionMemberkey.setIgnoreTimes(connectionkey, ConntionMemberKey.NORMOR_IGNORETIMES);
        }
        return null;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.msgListener = listener;
        for (String connectionkey : this.clusterConsumerMembers.keySet()) {
            MessageConsumer consumer = (MessageConsumer)this.clusterConsumerMembers.get(connectionkey);
            if (consumer == null) continue;
            consumer.setMessageListener(listener);
        }
    }

    public String toString() {
        return "ClusMessageConsumer: destination=" + ((Destination)this.destination).getName() + "cluster consumerid=" + this.clusterConsumerID;
    }

    public ClusSession getclusSession() {
        return this.clusSession;
    }

    public void setclusSession(ClusSession clusSession) {
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }
}

