/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.jms.JMSException;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.Destination;
import com.tongtech.tmqi.Topic;
import com.tongtech.tmqi.jmsclient.TopicPublisherImpl;
import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import com.tongtech.tmqi.jmscluster_v2.ConntionMemberKey;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

public class ClusProducer
implements MessageProducer {
    static Logger logger = LoggerFactory.getLogger(ClusProducer.class);
    private ClusSession clusSession;
    private javax.jms.Topic topic;
    private ConcurrentHashMap clusterProducerMembers = new ConcurrentHashMap();
    private javax.jms.Destination destination;
    private int deliveryMode = 2;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private int priority;
    private long timeToLive;
    private int strategy;
    private ConntionMemberKey conntionMemberkey;
    private boolean closed = false;

    public ClusProducer(ClusSession clusSession, javax.jms.Destination destination) throws javax.jms.JMSException {
        this.clusSession = clusSession;
        this.destination = destination;
        this.strategy = this.clusSession.clusConnection.getStrategy();
        this.conntionMemberkey = new ConntionMemberKey(clusSession.clusConnection.getClusterConectionMemberStates(), clusSession.clusConnection.getClientID(), clusSession.clusConnection.getJmsServerUrls(), clusSession.clusConnection.getMaxConnsPerClusterMember());
    }

    public void createProducerMember(String connectionKey) throws javax.jms.JMSException {
        ConcurrentHashMap sessionmember = this.clusSession.getClusterSessionMembers();
        if (sessionmember == null) {
            throw new javax.jms.JMSException("session is not create!");
        }
        if (connectionKey != null) {
            Session session;
            MessageProducer producer = (MessageProducer)this.clusterProducerMembers.get(connectionKey);
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((session = (Session)sessionmember.get(connectionKey)) == null) {
                throw new javax.jms.JMSException("session is not create!");
            }
            producer = session.createProducer(this.destination);
            if (this.deliveryMode != 0) {
                producer.setDeliveryMode(this.deliveryMode);
            }
            if (this.timeToLive != 0L) {
                producer.setTimeToLive(this.timeToLive);
            }
            if (this.priority != 0) {
                producer.setPriority(this.priority);
            }
            this.clusterProducerMembers.put(connectionKey, producer);
        } else {
            int producernum = 0;
            for (String connectionkey : sessionmember.keySet()) {
                Session session = (Session)sessionmember.get(connectionkey);
                if (session == null) continue;
                try {
                    MessageProducer producer = session.createProducer(this.destination);
                    if (this.deliveryMode != 0) {
                        producer.setDeliveryMode(this.deliveryMode);
                    }
                    if (this.timeToLive != 0L) {
                        producer.setTimeToLive(this.timeToLive);
                    }
                    if (this.priority != 0) {
                        producer.setPriority(this.priority);
                    }
                    this.clusterProducerMembers.put(connectionkey, producer);
                    ++producernum;
                }
                catch (Exception e) {
                    ClusConnection.setConntionMemberStateRecon(this.clusSession.clusConnection.getClusterConectionMemberStates(), connectionKey);
                }
            }
            if (producernum == 0) {
                logger.error("all session is broken,please reconn.");
                throw new javax.jms.JMSException("all session is broken,please reconn.");
            }
        }
    }

    public void createPublisherMember(String connectionKey, javax.jms.Topic topic) throws javax.jms.JMSException {
        ConcurrentHashMap sessionmember = this.clusSession.getClusterSessionMembers();
        if (sessionmember == null || sessionmember.size() == 0) {
            throw new javax.jms.JMSException("session is not create!");
        }
        if (connectionKey != null) {
            TopicSession topicsession;
            TopicPublisher publisher;
            Object obj = this.clusterProducerMembers.get(connectionKey);
            if (obj != null && obj instanceof TopicPublisherImpl) {
                publisher = (TopicPublisher)this.clusterProducerMembers.get(connectionKey);
                try {
                    publisher.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((topicsession = (TopicSession)sessionmember.get(connectionKey)) == null) {
                throw new javax.jms.JMSException("session is not create!");
            }
            publisher = topicsession.createPublisher(topic);
            if (this.deliveryMode != 0) {
                publisher.setDeliveryMode(this.deliveryMode);
            }
            if (this.timeToLive != 0L) {
                publisher.setTimeToLive(this.timeToLive);
            }
            if (this.priority != 0) {
                publisher.setPriority(this.priority);
            }
            this.clusterProducerMembers.put(connectionKey, publisher);
        } else {
            for (String connectionkey : sessionmember.keySet()) {
                TopicSession topicsession = (TopicSession)sessionmember.get(connectionkey);
                if (topicsession == null) continue;
                TopicPublisher publisher = topicsession.createPublisher(topic);
                if (this.deliveryMode != 0) {
                    publisher.setDeliveryMode(this.deliveryMode);
                }
                if (this.timeToLive != 0L) {
                    publisher.setTimeToLive(this.timeToLive);
                }
                if (this.priority != 0) {
                    publisher.setPriority(this.priority);
                }
                this.clusterProducerMembers.put(connectionkey, publisher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws javax.jms.JMSException {
        ClusProducer clusProducer = this;
        synchronized (clusProducer) {
            this.closed = true;
            if (this.clusterProducerMembers.isEmpty()) {
                return;
            }
            for (String connectionkey : this.clusterProducerMembers.keySet()) {
                MessageProducer producer = (MessageProducer)this.clusterProducerMembers.get(connectionkey);
                if (producer != null) {
                    producer.close();
                }
                this.clusterProducerMembers.remove(connectionkey);
            }
        }
    }

    public ConcurrentHashMap getClusterProducerMembers() {
        return this.clusterProducerMembers;
    }

    public void setClusterProducerMembers(ConcurrentHashMap clusterProducerMembers) {
        this.clusterProducerMembers = clusterProducerMembers;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public void send(javax.jms.Destination destination, Message message) throws javax.jms.JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message) throws javax.jms.JMSException {
        this.send(this.destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws javax.jms.JMSException {
        this.send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(javax.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws javax.jms.JMSException {
        int reSendcount = 0;
        javax.jms.JMSException mye = null;
        if (destination == null) {
            destination = this.destination;
        }
        while (reSendcount < this.clusSession.clusConnection.getMaxreSendcount()) {
            String connectionKey;
            if (this.clusSession.getIsXa() || this.clusSession.getTransacted()) {
                if (reSendcount != 0 && this.clusSession.haveTransedNum == 0) {
                    this.clusSession.getNextSessionTrans();
                }
                connectionKey = this.clusSession.getCurrentTransConntionKey();
            } else {
                connectionKey = this.conntionMemberkey.getNextconnkey();
            }
            ++reSendcount;
            MessageProducer producer = (MessageProducer)this.clusterProducerMembers.get(connectionKey);
            if (producer == null) continue;
            MessageProducer messageProducer = producer;
            synchronized (messageProducer) {
                block14: {
                    try {
                        logger.debug("cluster will send message={}", message);
                        producer.send(message, deliveryMode, priority, timeToLive);
                        if (!this.clusSession.getIsXa() && !this.clusSession.getTransacted()) break block14;
                        this.clusSession.addHaveTransedNum();
                    }
                    catch (javax.jms.JMSException e) {
                        if (!e.getMessage().contains("no space")) {
                            ClusConnection.setConntionMemberStateRecon(this.clusSession.clusConnection.getClusterConectionMemberStates(), connectionKey);
                            logger.error("cluster producer send msg fail,need conn retry connecte.", e);
                        }
                        mye = e;
                        if (this.clusSession.getIsXa() || this.clusSession.getTransacted()) {
                            this.clusSession.getConntionMemberkey().setIgnoreTimes(connectionKey, ConntionMemberKey.NORMOR_IGNORETIMES);
                            throw e;
                        }
                        this.conntionMemberkey.setIgnoreTimes(connectionKey, ConntionMemberKey.NORMOR_IGNORETIMES);
                        continue;
                    }
                }
                logger.debug("cluster will send message={}", message);
                break;
            }
        }
        if (reSendcount >= this.clusSession.clusConnection.getMaxreSendcount()) {
            if (mye != null) {
                throw new JMSException("cluster sender send message fail,", mye.getErrorCode(), mye);
            }
            throw new JMSException("cluster sender send message fail.");
        }
    }

    public javax.jms.Destination getDestination() {
        return this.destination;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) throws javax.jms.JMSException {
        this.deliveryMode = deliveryMode;
        if (this.clusterProducerMembers.isEmpty()) {
            return;
        }
        for (String connectionkey : this.clusterProducerMembers.keySet()) {
            MessageProducer producer = (MessageProducer)this.clusterProducerMembers.get(connectionkey);
            if (producer == null) continue;
            producer.setDeliveryMode(deliveryMode);
        }
    }

    public boolean getDisableMessageID() {
        return this.disableMessageID;
    }

    public void setDisableMessageID(boolean disableMessageID) {
        this.disableMessageID = disableMessageID;
    }

    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) throws javax.jms.JMSException {
        this.priority = priority;
        if (this.clusterProducerMembers.isEmpty()) {
            return;
        }
        for (String connectionkey : this.clusterProducerMembers.keySet()) {
            MessageProducer producer = (MessageProducer)this.clusterProducerMembers.get(connectionkey);
            if (producer == null) continue;
            producer.setPriority(priority);
        }
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) throws javax.jms.JMSException {
        this.timeToLive = timeToLive;
        if (this.clusterProducerMembers.isEmpty()) {
            return;
        }
        for (String connectionkey : this.clusterProducerMembers.keySet()) {
            MessageProducer producer = (MessageProducer)this.clusterProducerMembers.get(connectionkey);
            if (producer == null) continue;
            producer.setTimeToLive(timeToLive);
        }
    }

    public String toString() {
        if (this.destination != null) {
            return "ClusProducer {destination= " + ((Destination)this.destination).getName() + " }";
        }
        if (this.topic != null) {
            return "ClusProducer {topic= " + ((Topic)this.topic).getName() + " }";
        }
        return null;
    }

    public javax.jms.Topic getTopic() throws javax.jms.JMSException {
        return this.topic;
    }
}

