/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.backport.java.util.concurrent.ConcurrentHashMap;
import com.tongtech.backport.java.util.concurrent.CopyOnWriteArrayList;
import com.tongtech.jms.QueueConnection;
import com.tongtech.jms.TopicConnection;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.BasicQueue;
import com.tongtech.tmqi.jmsclient.BytesMessageImpl;
import com.tongtech.tmqi.jmsclient.MapMessageImpl;
import com.tongtech.tmqi.jmsclient.MessageImpl;
import com.tongtech.tmqi.jmsclient.ObjectMessageImpl;
import com.tongtech.tmqi.jmsclient.StreamMessageImpl;
import com.tongtech.tmqi.jmsclient.TextMessageImpl;
import com.tongtech.tmqi.jmsclient.XASessionImpl;
import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.ClusMessageConsumer;
import com.tongtech.tmqi.jmscluster_v2.ClusProducer;
import com.tongtech.tmqi.jmscluster_v2.ClusQueueReceiver;
import com.tongtech.tmqi.jmscluster_v2.ClusQueueSender;
import com.tongtech.tmqi.jmscluster_v2.ClusTopicPublisher;
import com.tongtech.tmqi.jmscluster_v2.ClusTopicSubscriber;
import com.tongtech.tmqi.jmscluster_v2.ClusXAResourceImpl;
import com.tongtech.tmqi.jmscluster_v2.ConntionMemberKey;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;

public class ClusSession
implements Session,
TopicSession,
QueueSession,
XASession {
    static Logger logger = LoggerFactory.getLogger(ClusSession.class);
    public static int CLU_SESSION__TYPE_TOPICSESSION = 1;
    public static int CLU_SESSION__TYPE_QUEUEQUESESSION = 2;
    public static int CLU_SESSION__TYPE_SESSION = 0;
    public ClusConnection clusConnection;
    private ClusXAResourceImpl clusterXAResource;
    private ConcurrentHashMap clusterSessionMembers = new ConcurrentHashMap();
    private ConcurrentHashMap clusterSessionMembersHaveTrans = new ConcurrentHashMap();
    private ConcurrentHashMap clusterproducers = new ConcurrentHashMap();
    private ConcurrentHashMap clusterconsumers = new ConcurrentHashMap();
    private boolean transacted = false;
    private String currentTransConntionKey;
    private boolean ignoreClose;
    private int clusterSessionID;
    private int clusterConSumerSeq = 0;
    private int clusterProducerSeq = 0;
    private int ackMode;
    private boolean closed = false;
    private int SessionType = CLU_SESSION__TYPE_SESSION;
    private final CopyOnWriteArrayList consumers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList browsers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList tempDestEventListeners = new CopyOnWriteArrayList();
    private boolean isXa;
    private ConntionMemberKey conntionMemberkey;
    public int haveTransedNum = 0;

    public ClusSession(ClusConnection clusConnection, int clusterSessionID, boolean transacted, int ackMode) {
        this.clusConnection = clusConnection;
        this.clusterSessionID = clusterSessionID;
        this.transacted = transacted;
        this.ackMode = ackMode;
        this.conntionMemberkey = new ConntionMemberKey(clusConnection.getClusterConectionMemberStates(), clusConnection.getClientID(), clusConnection.getJmsServerUrls(), clusConnection.getMaxConnsPerClusterMember());
    }

    public void createClusterSessionMemmber(String connectionkey) throws JMSException {
        if (this.clusConnection == null) {
            throw new JMSException("clusConnection is null");
        }
        this.clusConnection.assertNotClosed();
        if (this.isXa && this.clusterXAResource == null) {
            throw new JMSException("clusterXAResource is null");
        }
        ConcurrentHashMap clusterConectionMembers = this.clusConnection.getClusterConectionMembers();
        Connection connection = (Connection)clusterConectionMembers.get(connectionkey);
        if (connection != null) {
            Object session = this.SessionType == CLU_SESSION__TYPE_TOPICSESSION ? ((TopicConnection)connection).createTopicSession(this.transacted, this.ackMode) : (this.SessionType == CLU_SESSION__TYPE_TOPICSESSION ? ((QueueConnection)connection).createQueueSession(this.transacted, this.ackMode) : connection.createSession(this.transacted, this.ackMode));
            this.clusterSessionMembers.put(connectionkey, session);
            if (this.isXa) {
                if (session instanceof XASessionImpl) {
                    XASessionImpl mysession = (XASessionImpl)session;
                    XAResource xaresource = mysession.getXAResource();
                    this.clusterXAResource.xaResources.put(connectionkey, xaresource);
                } else {
                    throw new JMSException("not suport session type ");
                }
            }
        }
    }

    public void createClusterSession(boolean isXa) throws JMSException {
        this.isXa = isXa;
        if (this.clusConnection == null) {
            throw new JMSException("clusConnection is null");
        }
        this.clusConnection.assertNotClosed();
        if (isXa) {
            this.clusterXAResource = new ClusXAResourceImpl(this, this.conntionMemberkey);
        }
        ConcurrentHashMap clusterConectionMembers = this.clusConnection.getClusterConectionMembers();
        for (String connectionkey : clusterConectionMembers.keySet()) {
            Connection connection = (Connection)clusterConectionMembers.get(connectionkey);
            if (connection == null) continue;
            Object session = this.SessionType == CLU_SESSION__TYPE_TOPICSESSION ? ((TopicConnection)connection).createTopicSession(this.transacted, this.ackMode) : (this.SessionType == CLU_SESSION__TYPE_TOPICSESSION ? ((QueueConnection)connection).createQueueSession(this.transacted, this.ackMode) : connection.createSession(this.transacted, this.ackMode));
            this.clusterSessionMembers.put(connectionkey, session);
            if (!isXa) continue;
            if (session instanceof XASessionImpl) {
                XASessionImpl mysession = (XASessionImpl)session;
                XAResource xaresource = mysession.getXAResource();
                this.clusterXAResource.xaResources.put(connectionkey, xaresource);
                continue;
            }
            throw new JMSException("not suport session type ");
        }
        if (!isXa && this.transacted) {
            this.currentTransConntionKey = this.conntionMemberkey.getNextconnkey();
        }
    }

    protected boolean isIgnoreClose() {
        return this.ignoreClose;
    }

    protected void setIgnoreClose(boolean ignoreClose) {
        this.ignoreClose = ignoreClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        ClusSession clusSession = this;
        synchronized (clusSession) {
            this.closed = true;
            if (this.clusConnection == null || this.clusConnection.getClusterConnionState() == 3) {
                return;
            }
            ConcurrentHashMap clusterConectionMembers = this.clusConnection.getClusterConectionMembers();
            logger.trace("cluster session={} will  closed.", this);
            for (String connectionkey : this.clusterSessionMembers.keySet()) {
                Session session = (Session)this.clusterSessionMembers.get(connectionkey);
                if (session == null) continue;
                try {
                    session.close();
                }
                catch (JMSException e) {
                    logger.error("session close error " + (Object)((Object)e));
                }
                finally {
                    this.clusterSessionMembers.remove(connectionkey);
                }
            }
            this.clusConnection.getClusterSessions().remove(this.clusterSessionID);
        }
    }

    public void setClusterSessionMemberTrans(String connectionkey, boolean havetranflag) {
        String value = havetranflag ? "true" : "false";
        this.clusterSessionMembersHaveTrans.put(connectionkey, value);
    }

    public boolean getClusterSessionMemberTrans(String connectionkey) {
        String value = (String)this.clusterSessionMembersHaveTrans.get(connectionkey);
        return value != null && value.equals("true");
    }

    public void commit() throws JMSException {
        if (this.clusConnection == null || this.clusConnection.getClusterConnionState() == 3) {
            throw new JMSException("cluster conn is closed! ");
        }
        if (this.isXa) {
            throw new JMSException("cluster conn used XA,can not call session.commit,please check FactoryName[" + this.clusConnection.getClusterFactory().getFactoryName() + "] config on server !! ");
        }
        if (this.currentTransConntionKey == null) {
            throw new JMSException("cluster Session not have begin");
        }
        Session session = (Session)this.clusterSessionMembers.get(this.currentTransConntionKey);
        if (session == null) {
            throw new JMSException("the session in cluster Session hava closed");
        }
        session.commit();
        logger.trace("cluster Session commit ok");
        this.setCurrentTransConntionKey(null);
        this.setHaveTransedNum(0);
        if (!this.isXa && this.transacted) {
            this.currentTransConntionKey = this.conntionMemberkey.getNextconnkey();
        }
    }

    public BytesMessage createBytesMessage() throws JMSException {
        BytesMessageImpl message = new BytesMessageImpl(2);
        return message;
    }

    public MapMessage createMapMessage() throws JMSException {
        MapMessageImpl msg = new MapMessageImpl(2);
        return msg;
    }

    public Message createMessage() throws JMSException {
        MessageImpl msg = new MessageImpl(2);
        return msg;
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessageImpl message = new ObjectMessageImpl(2);
        return message;
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        ObjectMessageImpl message = new ObjectMessageImpl(2);
        message.setObject(serializable);
        return message;
    }

    public Queue createQueue(String s) throws JMSException {
        return new BasicQueue(s);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessageImpl msg = new StreamMessageImpl(2);
        return msg;
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return null;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return null;
    }

    public void unsubscribe(String s) throws JMSException {
        if (this.clusConnection == null || this.clusConnection.getClusterConnionState() == 3) {
            throw new JMSException("connection  closed");
        }
        ConcurrentHashMap clusterConectionMembers = this.clusConnection.getClusterConectionMembers();
        for (String connectionkey : this.clusterSessionMembers.keySet()) {
            Session session = (Session)this.clusterSessionMembers.get(connectionkey);
            if (session == null || !this.getClusterSessionMemberTrans(connectionkey)) continue;
            session.unsubscribe(s);
        }
    }

    public TextMessage createTextMessage() throws JMSException {
        TextMessageImpl msg = new TextMessageImpl(2);
        return msg;
    }

    public TextMessage createTextMessage(String s) throws JMSException {
        TextMessageImpl msg = new TextMessageImpl(2);
        msg.setText(s);
        return msg;
    }

    public Topic createTopic(String s) throws JMSException {
        if (this.clusConnection == null || this.clusConnection.getClusterConnionState() == 3) {
            throw new JMSException("connection  closed");
        }
        ConcurrentHashMap clusterConectionMembers = this.clusConnection.getClusterConectionMembers();
        for (String connectionkey : this.clusterSessionMembers.keySet()) {
            Session session = (Session)this.clusterSessionMembers.get(connectionkey);
            if (session == null || !this.getClusterSessionMemberTrans(connectionkey)) continue;
            return session.createTopic(s);
        }
        return null;
    }

    public int getAcknowledgeMode() throws JMSException {
        return this.ackMode;
    }

    public boolean getTransacted() throws JMSException {
        return this.transacted;
    }

    public void recover() throws JMSException {
        logger.error("cluster session recover method  not implemet!!");
        throw new JMSException("cluster session recover method  not implemet!!");
    }

    public void rollback() throws JMSException {
        if (this.clusConnection == null || this.clusConnection.getClusterConnionState() == 3) {
            throw new JMSException("connection  closed");
        }
        if (this.isXa) {
            throw new JMSException("cluster conn used XA,can not call session.rollback,please check FactoryName[" + this.clusConnection.getClusterFactory().getFactoryName() + "] config on server !! ");
        }
        if (this.currentTransConntionKey != null) {
            Session session = (Session)this.clusterSessionMembers.get(this.currentTransConntionKey);
            if (session == null) {
                throw new JMSException("the session in cluster Session hava closed");
            }
            session.rollback();
            logger.trace("cluster Session commit ok");
        }
        this.setCurrentTransConntionKey(null);
        this.setHaveTransedNum(0);
        if (!this.isXa && this.transacted) {
            this.currentTransConntionKey = this.conntionMemberkey.getNextconnkey();
        }
    }

    public XAResource getXAResource() {
        return this.clusterXAResource;
    }

    public Session getSession() {
        return this;
    }

    public void run() {
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return null;
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        return null;
    }

    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusMessageConsumer consumer = new ClusMessageConsumer(this, destination, selector, consumerSeq);
        consumer.createConsumerMember(null);
        this.clusterconsumers.put(new Integer(consumerSeq), consumer);
        return consumer;
    }

    public MessageConsumer createConsumer(Destination destination, String selector, boolean noLocal) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusMessageConsumer consumer = new ClusMessageConsumer(this, destination, selector, consumerSeq);
        consumer.createConsumerMember(null);
        this.clusterconsumers.put(new Integer(consumerSeq), consumer);
        return consumer;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusTopicSubscriber sub = new ClusTopicSubscriber(this, topic, null, consumerSeq);
        sub.setDurable(true);
        sub.setDurableName(name);
        sub.createConsumerMember(null);
        this.clusterconsumers.put(new Integer(consumerSeq), sub);
        return sub;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusTopicSubscriber sub = new ClusTopicSubscriber(this, topic, selector, consumerSeq);
        sub.setDurable(true);
        sub.setDurableName(name);
        sub.createConsumerMember(null);
        this.clusterconsumers.put(new Integer(consumerSeq), sub);
        return sub;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusTopicSubscriber sub = new ClusTopicSubscriber(this, topic, null, consumerSeq);
        sub.setDurable(false);
        sub.createConsumerMember(null);
        this.clusterconsumers.put(new Integer(consumerSeq), sub);
        return sub;
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean local) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusTopicSubscriber sub = new ClusTopicSubscriber(this, topic, selector, consumerSeq);
        sub.setDurable(false);
        sub.setNoLocal(local);
        sub.createConsumerMember(null);
        this.clusterconsumers.put(new Integer(consumerSeq), sub);
        return sub;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusQueueReceiver cluRecever = new ClusQueueReceiver(this, null, null, consumerSeq);
        cluRecever.createReceiverMember(null, queue);
        this.clusterconsumers.put(new Integer(consumerSeq), cluRecever);
        return cluRecever;
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws JMSException {
        int consumerSeq = this.getNextclusterConSumerSeq();
        ClusQueueReceiver cluRecever = new ClusQueueReceiver(this, (Destination)queue, selector, consumerSeq);
        cluRecever.createReceiverMember(null, queue);
        this.clusterconsumers.put(new Integer(consumerSeq), cluRecever);
        return cluRecever;
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        int producerSeq = this.getNextclusterProducerSeq();
        ClusProducer producer = new ClusProducer(this, destination);
        producer.createProducerMember(null);
        this.clusterproducers.put(new Integer(producerSeq), producer);
        return producer;
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        int producerSeq = this.getNextclusterProducerSeq();
        ClusQueueSender producer = new ClusQueueSender(this, queue);
        producer.createProducerMember(null);
        this.clusterproducers.put(new Integer(producerSeq), producer);
        return producer;
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        int producerSeq = this.getNextclusterProducerSeq();
        ClusTopicPublisher pulisher = new ClusTopicPublisher(this, topic);
        pulisher.createPublisherMember(null, topic);
        this.clusterproducers.put(new Integer(producerSeq), pulisher);
        return pulisher;
    }

    protected void onConsumerClose(MessageConsumer consumer) {
        this.consumers.remove(consumer);
    }

    private QueueBrowser addQueueBrowser(QueueBrowser browser) {
        this.browsers.add(browser);
        return browser;
    }

    private TopicSubscriber addTopicSubscriber(TopicSubscriber subscriber) {
        this.consumers.add(subscriber);
        return subscriber;
    }

    private QueueReceiver addQueueReceiver(QueueReceiver receiver) {
        this.consumers.add(receiver);
        return receiver;
    }

    public void setIsXa(boolean isXa) {
        this.isXa = isXa;
    }

    public boolean getIsXa() {
        return this.isXa;
    }

    public String toString() {
        return "ClusSession {  connectionid=" + this.clusConnection.getClientID() + "clusterSessionid=" + this.clusterSessionID + "}";
    }

    public ConcurrentHashMap getClusterSessionMembers() {
        return this.clusterSessionMembers;
    }

    public void setClusterSessionMembers(ConcurrentHashMap clusterSessionMembers) {
        this.clusterSessionMembers = clusterSessionMembers;
    }

    private synchronized int getNextclusterConSumerSeq() {
        this.clusterConSumerSeq = this.clusterConSumerSeq >= Integer.MAX_VALUE ? 0 : ++this.clusterConSumerSeq;
        return this.clusterConSumerSeq;
    }

    private synchronized int getNextclusterProducerSeq() {
        this.clusterProducerSeq = this.clusterProducerSeq >= Integer.MAX_VALUE ? 0 : ++this.clusterProducerSeq;
        return this.clusterProducerSeq;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null);
    }

    public MessageListener getMessageListener() throws JMSException {
        return null;
    }

    public void setMessageListener(MessageListener arg0) throws JMSException {
    }

    public String getCurrentTransConntionKey() {
        return this.currentTransConntionKey;
    }

    public void setCurrentTransConntionKey(String currentTransConntionKey) {
        this.currentTransConntionKey = currentTransConntionKey;
    }

    public ConcurrentHashMap getClusterproducers() {
        return this.clusterproducers;
    }

    public void setClusterproducers(ConcurrentHashMap clusterproducers) {
        this.clusterproducers = clusterproducers;
    }

    public ConcurrentHashMap getClusterconsumers() {
        return this.clusterconsumers;
    }

    public void setClusterconsumers(ConcurrentHashMap clusterconsumers) {
        this.clusterconsumers = clusterconsumers;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public int getSessionType() {
        return this.SessionType;
    }

    public void setSessionType(int sessionType) {
        this.SessionType = sessionType;
    }

    public ConntionMemberKey getConntionMemberkey() {
        return this.conntionMemberkey;
    }

    public int getHaveTransedNum() {
        return this.haveTransedNum;
    }

    public void setHaveTransedNum(int haveTransedNum) {
        this.haveTransedNum = haveTransedNum;
    }

    public void addHaveTransedNum() {
        ++this.haveTransedNum;
    }

    public void getNextSessionTrans() throws JMSException {
        this.currentTransConntionKey = this.conntionMemberkey.getNextconnkey();
    }
}

