/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.jmscluster_v2;

import com.tongtech.tmqi.jmscluster_v2.ClusConnection;
import com.tongtech.tmqi.jmscluster_v2.ClusConnectionFactory;
import com.tongtech.tmqi.jmscluster_v2.ClusSession;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;

public class XaClusConnection
extends ClusConnection
implements XAConnection {
    private TransactionManager transactionManager;

    public XaClusConnection(ClusConnectionFactory cluConnectionFactory, TransactionManager transactionManager) {
        super(cluConnectionFactory);
        this.transactionManager = transactionManager;
        super.setXA(true);
    }

    @Override
    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        try {
            boolean isXa = true;
            if (isXa) {
                transacted = true;
                ackMode = 0;
            }
            ClusSession session = (ClusSession)super.createSession(transacted, ackMode);
            if (isXa) {
                session.setIgnoreClose(true);
                session.setIsXa(true);
            } else {
                session.setIgnoreClose(false);
            }
            return session;
        }
        catch (JMSException e) {
            JMSException jmsException = new JMSException("Rollback Exception");
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }

    protected XAResource createXaResource(ClusSession session) throws JMSException {
        return session.getXAResource();
    }

    public XASession createXASession() throws JMSException {
        return (XASession)this.createSession(false, 1);
    }

    protected class Synchronization
    implements javax.transaction.Synchronization {
        private final ClusSession session;

        private Synchronization(ClusSession session) {
            this.session = session;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
        }
    }
}

