/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.pool;

import com.tongtech.backport.java.util.concurrent.CopyOnWriteArrayList;
import com.tongtech.jms.Connection;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.tmqi.pool.ConnectionPool;
import com.tongtech.tmqi.pool.PooledSession;
import com.tongtech.tmqi.pool.PooledSessionEventListener;
import com.tongtech.tmqi.pool.SessionKey;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class PooledConnection
implements TopicConnection,
QueueConnection {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnection.class);
    private ConnectionPool pool;
    private boolean stopped;
    private final CopyOnWriteArrayList connTempQueues = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList connTempTopics = new CopyOnWriteArrayList();

    public PooledConnection(ConnectionPool pool) {
        this.pool = pool;
        this.pool.incrementReferenceCount();
    }

    public PooledConnection newInstance() {
        return new PooledConnection(this.pool);
    }

    public void close() throws JMSException {
        this.cleanupConnectionTemporaryDestinations();
        if (this.pool != null) {
            this.pool.decrementReferenceCount();
            this.pool = null;
        }
    }

    public void start() throws JMSException {
        this.assertNotClosed();
        this.pool.start();
    }

    public void stop() throws JMSException {
        this.stopped = true;
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer((Destination)topic, s, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.getConnection().getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.getConnection().setExceptionListener(exceptionListener);
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.getConnection().getClientID() == null || !this.getClientID().equals(clientID)) {
            this.getConnection().setClientID(clientID);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer((Destination)queue, selector, serverSessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession result = (PooledSession)this.pool.createSession(transacted, ackMode);
        result.addTempDestEventListener(new PooledSessionEventListener(){

            @Override
            public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
                PooledConnection.this.connTempQueues.add(tempQueue);
            }

            @Override
            public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
                PooledConnection.this.connTempTopics.add(tempTopic);
            }
        });
        return result;
    }

    public Connection getConnection() throws JMSException {
        this.assertNotClosed();
        return this.pool.getConnection();
    }

    protected void assertNotClosed() {
        if (this.stopped || this.pool == null) {
            throw new IllegalStateException();
        }
    }

    protected com.tongtech.jms.Session createSession(SessionKey key) throws JMSException {
        return (com.tongtech.jms.Session)this.getConnection().createSession(key.isTransacted(), key.getAckMode());
    }

    public String toString() {
        return "PooledConnection { " + this.pool + " }";
    }

    protected void cleanupConnectionTemporaryDestinations() {
        for (TemporaryQueue tempQueue : this.connTempQueues) {
            try {
                tempQueue.delete();
            }
            catch (JMSException ex) {
                LOG.info("failed to delete Temporary Queue \"" + tempQueue.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempQueues.clear();
        for (TemporaryTopic tempTopic : this.connTempTopics) {
            try {
                tempTopic.delete();
            }
            catch (JMSException ex) {
                LOG.info("failed to delete Temporary Topic \"" + tempTopic.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempTopics.clear();
    }
}

