/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.pool;

import com.tongtech.backport.java.util.concurrent.atomic.AtomicBoolean;
import com.tongtech.jms.Connection;
import com.tongtech.jms.JMSException;
import com.tongtech.log.Logger;
import com.tongtech.log.LoggerFactory;
import com.tongtech.org.apache.commons.pool.ObjectPoolFactory;
import com.tongtech.org.apache.commons.pool.impl.GenericObjectPoolFactory;
import com.tongtech.tmqi.ConnectionFactory;
import com.tongtech.tmqi.pool.ConnectionKey;
import com.tongtech.tmqi.pool.ConnectionPool;
import com.tongtech.tmqi.pool.PooledConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class PooledConnectionFactory
implements javax.jms.ConnectionFactory,
com.tongtech.jms.ConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(PooledConnectionFactory.class);
    private javax.jms.ConnectionFactory connectionFactory;
    private Map cache = new HashMap();
    private ObjectPoolFactory poolFactory;
    private int maxSessions = 100;
    private int maxConnections = 10;
    private int idleTimeout = 30000;
    private boolean blockIfSessionPoolIsFull = true;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private long expiryTimeout = 0L;

    public PooledConnectionFactory() {
        this(new ConnectionFactory());
    }

    public PooledConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public javax.jms.ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(javax.jms.ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public javax.jms.Connection createConnection() throws javax.jms.JMSException {
        return this.createConnection(null, null);
    }

    public synchronized javax.jms.Connection createConnection(String userName, String password) throws javax.jms.JMSException {
        if (this.stopped.get()) {
            LOG.debug("PooledConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        userName = null;
        password = null;
        ConnectionKey key = new ConnectionKey(userName, password);
        LinkedList<ConnectionPool> pools = (LinkedList<ConnectionPool>)this.cache.get(key);
        if (pools == null) {
            pools = new LinkedList<ConnectionPool>();
            this.cache.put(key, pools);
        }
        ConnectionPool connection = null;
        if (pools.size() == this.maxConnections) {
            connection = (ConnectionPool)pools.removeFirst();
        }
        if (connection != null && connection.expiredCheck()) {
            connection = null;
        }
        if (connection == null) {
            Connection delegate = this.createConnection(key);
            connection = this.createConnectionPool(delegate);
        }
        pools.add(connection);
        return new PooledConnection(connection);
    }

    protected ConnectionPool createConnectionPool(Connection connection) {
        ConnectionPool result = new ConnectionPool(connection, this.getPoolFactory());
        result.setIdleTimeout(this.getIdleTimeout());
        result.setExpiryTimeout(this.getExpiryTimeout());
        return result;
    }

    protected Connection createConnection(ConnectionKey key) throws javax.jms.JMSException {
        if (key.getUserName() == null && key.getPassword() == null) {
            return (Connection)this.connectionFactory.createConnection();
        }
        return (Connection)this.connectionFactory.createConnection(key.getUserName(), key.getPassword());
    }

    private void start() {
        try {
            this.stopped.set(false);
            this.createConnection();
        }
        catch (javax.jms.JMSException e) {
            LOG.warn("Create pooled connection during start failed.", e);
        }
    }

    private void stop() {
        LOG.debug("Stop the PooledConnectionFactory, number of connections in cache: " + this.cache.size());
        this.stopped.set(true);
        for (LinkedList connections : this.cache.values()) {
            Iterator iterator = connections.iterator();
            while (iterator.hasNext()) {
                try {
                    ConnectionPool connection = (ConnectionPool)iterator.next();
                    connection.close();
                }
                catch (Exception e) {
                    LOG.warn("Close connection failed", e);
                }
            }
        }
        this.cache.clear();
    }

    public ObjectPoolFactory getPoolFactory() {
        if (this.poolFactory == null) {
            this.poolFactory = this.createPoolFactory();
        }
        return this.poolFactory;
    }

    public void setPoolFactory(ObjectPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.blockIfSessionPoolIsFull = block;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected ObjectPoolFactory createPoolFactory() {
        if (this.blockIfSessionPoolIsFull) {
            return new GenericObjectPoolFactory(null, this.maxSessions);
        }
        return new GenericObjectPoolFactory(null, this.maxSessions, 0, -1L);
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    @Override
    public void close() throws JMSException {
        this.stop();
    }
}

