/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tmqi.util;

import java.io.IOException;
import java.io.InputStream;

public class FastInputStream
extends InputStream {
    protected int len;
    protected int off;
    protected int mark;
    protected byte[] buf;

    public FastInputStream(byte[] buffer) {
        this.buf = buffer;
        this.len = buffer.length;
    }

    public FastInputStream(byte[] buffer, int offset, int length) {
        this.buf = buffer;
        this.off = offset;
        this.len = length;
    }

    @Override
    public int available() {
        return this.len - this.off;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int pos) {
        this.mark = pos;
    }

    @Override
    public void reset() {
        this.off = this.mark;
    }

    @Override
    public long skip(long count) {
        int myCount = (int)count;
        if (myCount + this.off > this.len) {
            myCount = this.len - this.off;
        }
        this.off += myCount;
        return myCount;
    }

    @Override
    public int read() throws IOException {
        return this.readFast();
    }

    @Override
    public int read(byte[] toBuf) throws IOException {
        return this.readFast(toBuf, 0, toBuf.length);
    }

    @Override
    public int read(byte[] toBuf, int offset, int length) throws IOException {
        return this.readFast(toBuf, offset, length);
    }

    public final int readFast() {
        return this.off < this.len ? this.buf[this.off++] & 0xFF : -1;
    }

    public final int readFast(byte[] toBuf) {
        return this.readFast(toBuf, 0, toBuf.length);
    }

    public final int readFast(byte[] toBuf, int offset, int length) {
        int avail = this.len - this.off;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        for (int i = 0; i < length; ++i) {
            toBuf[offset++] = this.buf[this.off++];
        }
        return length;
    }

    public final byte[] getBufferBytes() {
        return this.buf;
    }

    public final int getBufferOffset() {
        return this.off;
    }

    public final int getBufferLength() {
        return this.len;
    }
}

